/* support for format statements -- called from cmn0.lisp */

#include <stdio.h>

static FILE *fp;

int OpenCMNFile (char *fileName)
{
  fp = fopen(fileName,"w");
  if (fp == NULL) 
    {
      printf("Cannot open %s.\n",fileName);
      fflush(stdout);
      return 1;
    }
return 0;
}

CloseCMNFile (void)
{
  if (fp != NULL) fclose(fp);
  fp = NULL;
}


PrintCMNFile (char *arr)
{
    fprintf(fp,"%s\n",arr);
}

LinetoCMNFile (float *arr)
{
    fprintf(fp," %.2f %.2f lineto\n",arr[0],arr[1]);
}

RLinetoCMNFile (float *arr)
{
    fprintf(fp," %.2f %.2f rlineto\n",arr[0],arr[1]);
}

MovetoCMNFile (float *arr)
{
    fprintf(fp," %.2f %.2f moveto\n",arr[0],arr[1]);
}

RMovetoCMNFile (float *arr)
{
    fprintf(fp," %.2f %.2f rmoveto\n",arr[0],arr[1]);
}

CurvetoCMNFile (float *arr)
{
    fprintf(fp," %.2f %.2f %.2f %.2f %.2f %.2f curveto\n",arr[0],arr[1],arr[2],arr[3],arr[4],arr[5]);
}

FillinCMNFile (float *arr, char *cmd)
{
  fprintf(fp," %.2f %.2f %.2f %.2f %s\n",arr[0],arr[1],arr[2],arr[3],cmd);
}

GlyphCMNFile (int glf)
{
  fprintf(fp," (\\%d) show\n",glf);
}

FontGlyphCMNFile (char *font, int size, int glf)
{
  fprintf(fp," gsave /%s findfont %d scalefont setfont (\\%d) show grestore\n",font,size,glf);
}

FontTextCMNFile (char *font, int size, char *str)
{
  fprintf(fp," gsave /%s findfont %d scalefont setfont (%s) show grestore\n",font,size,str);
}

StemCMNFile (float *arr)
{
  fprintf(fp," %.2f setlinewidth %.2f %.2f moveto %.2f %.2f lineto stroke 0 setlinewidth\n",arr[3],arr[0],arr[1],arr[0],arr[2]);
}

VerticalLineCMNFile (float *arr)
{
  fprintf(fp," %.2f %.2f moveto %.2f %.2f lineto\n",arr[0],arr[1],arr[0],arr[2]);
}

HorizontalLineCMNFile (float *arr)
{
  fprintf(fp," %.2f %.2f moveto %.2f %.2f lineto\n",arr[0],arr[1],arr[2],arr[1]);
}

SlantedLineCMNFile (float *arr)
{
  fprintf(fp," %.2f %.2f moveto %.2f %.2f lineto %.2f %.2f lineto %.2f %.2f lineto closepath fill\n",
	   arr[0],arr[1],arr[0],arr[1]+arr[4],arr[2],arr[3]+arr[4],arr[2],arr[3]);
}


#ifndef AKCL
/* a very simple PS previewer for the NeXT */
/* from /LocalLibrary/NextAnswers/postscript.798 */

#import "/usr/include/dpsclient/dpsNeXT.h"

int SendFileToPS(char *fileName, int x0, int y0, int x1, int y1)
{
	NXStream *st;
	NXEvent event;
	DPSContext ctx;
	char *addr;
	int len, maxlen, windows;
	st = NXMapFile(fileName, NX_READONLY);
	if (st) {
		NXGetMemoryBuffer(st, &addr, &len, &maxlen);
		ctx = DPSCreateContext(0,0,NULL,NULL);

		DPSPrintf(ctx,"/showpage {initgraphics} bind def\n");
		DPSPrintf(ctx,"%d %d %d %d 0 window\n"
			  "windowdeviceround\n"
			  "1 0 currentwindow orderwindow\n",
			  x0,y0,x1,y1);
		DPSPrintf(ctx,"%d currentwindow seteventmask\n",
			  NX_MOUSEDOWNMASK+NX_MOUSEUPMASK+NX_KEYDOWNMASK);
		DPSPrintf(ctx,"0 1 %d %d rectstroke\n",x1-1,y1-1);
		DPSPrintf(ctx,"/_the_saved_vm_ save def\n");

		DPSWriteData(ctx, addr, len);

		DPSPrintf(ctx,"\ngrestoreall _the_saved_vm_ restore\n");

		NXCloseMemory(st, NX_FREEBUFFER);

		windows = 1;
		while (windows) 
		  {
		    DPSFlushContext(ctx);
		    DPSGetEvent(ctx,&event,-1,NX_FOREVER,0);
		    if (event.type == NX_MOUSEUP) 
		      {
			DPSPrintf(ctx,"%d termwindow\n"
				  "nulldevice\n",event.window);
			windows--;
			DPSFlushContext(ctx);
		      }
		    else if (event.type == NX_MOUSEDOWN)
		      {
			DPSPrintf(ctx,"1 0 %d orderwindow\n"
				  "{%d stilldown not {exit} if\n"
				  "workspaceWindow currentmouse %g sub exch %g sub exch\n"
				  "%d movewindow} loop\n",
				  event.window,event.data.mouse.eventNum,
				  event.location.y,event.location.x,event.window);
		      }
		  }
	      }
return 0;
}

/* (ff:defforeign 'nps :entry-point "_SendFileToPS" :arguments '(string fixnum fixnum fixnum fixnum) :return-type :integer) */
#endif
