;;; -*- syntax: common-lisp; package: cmn; base: 10; mode: lisp -*-
;;;
;;; this file taken from the MCL example scrolling-windows.lisp

(in-package :ccl)

(defclass scrolling-window (window) ((my-scroller :accessor my-scroller)))

(defmethod initialize-instance ((self scrolling-window) &rest rest &key
                                (scroller-class 'scroller)
                                scroll-bar-class h-scroll-class v-scroll-class
                                track-thumb-p field-size)
  (declare (dynamic-extent rest))
  ; We use the values of these keywords by modifying the rest parameter
  (declare (ignore scroll-bar-class h-scroll-class v-scroll-class
                   track-thumb-p field-size))
  (call-next-method)
  ; Leave, in rest, only the four keywords we want to pass to the
  ; make-instance for scroller-class. This allows them to default
  ; as desired by scroll-class.
  (let* ((handle (cons nil rest)))
    (declare (dynamic-extent handle) (type cons handle))
    (do ((tail handle))
        ((null (cdr tail)) (setq rest (cdr handle)))
      (declare (type cons tail))
      (if (memq (cadr tail) 
                '(:scroll-bar-class :h-scroll-class :v-scroll-class
                  :track-thumb-p :field-size))
        (setq tail (cddr tail))
        (setf (cdr tail) (cdr (cddr tail))))))
  (setf (my-scroller self) (apply #'make-instance
                                  scroller-class
                                  :view-container self
                                  :view-size (subtract-points
                                              (view-size self) #@(15 15))
                                  :view-position #@(0 0)
                                  :draw-scroller-outline nil
                                  rest)))

(defmethod set-view-size ((self scrolling-window) h &optional v)
  (declare (ignore h v))
  (without-interrupts
   (call-next-method)
   (let* ((new-size (subtract-points (view-size self) #@(15 15))))    
       (set-view-size (my-scroller self) new-size))))

(defmethod window-zoom-event-handler ((self scrolling-window) message)
  (declare (ignore message))
  (without-interrupts
   (call-next-method)
   (let* ((new-size (subtract-points (view-size self) #@(15 15))))
       (set-view-size (my-scroller self) new-size))))
