;;; -*- syntax: common-lisp; package: cmn; base: 10; mode: lisp -*-

(in-package :cmn)

#+mcl
(progn 

  (defvar numbers nil)
  (setf numbers (make-array 16 :element-type 'fixnum :initial-element 0))
  (defvar mcl-output nil)

  (defun mcl-initialize () (setf mcl-output (#_newptr 256)))

  (defmethod mcl-finalize () (setf mcl-output (#_disposeptr mcl-output)))

  (defun f2b (m buffer &optional (offset 0) space?)	; ds=2
    (let ((n (round (* (abs m) 100)))   ; 100=(expt 10 ds)
          (len 0)
	  pos strlen)
      (declare (integer len pos n) (optimize (speed 3) (safety 0)))
      (loop while (> n 9)
            for i from 1
            do
            (setf (svref numbers len)
                  (the integer
                    (+ 48
                       (the integer 
                         (min 9 (max 0 
                                     (the integer (- N (* 10 (floor n 10))))))))))
            (setf n (floor n 10))
            (incf len)
            (when (= (the integer i) 2)	     ; ds
              (setf (svref numbers len) 46)	     ; #\.
              (incf (the integer len))))
      (setf (svref numbers len) 
            (the integer (+ 48 (the integer (floor n)))))
      (let ((pad? (the integer (- 2 len)))) ; ds
        (declare (integer pad?))
        (when (> pad?  0)
          (setf (svref numbers (the integer (incf len))) 46)  ; #\.
          (loop repeat pad?
                do (setf (svref numbers (the integer (incf len))) 48))))
      (incf len)
      (if (minusp m) 
        (progn (setf pos (+ offset 1 )
                     strlen (1+ len))
               (ccl:%put-byte buffer 45 offset))          ; #\-
        (setf pos offset strlen len))
      (loop with j = len
            for i from pos repeat len
            do (ccl:%put-byte buffer (svref numbers (decf j)) i))
      (incf offset strlen)
      (when space?
        (ccl:%put-byte buffer 32 offset) ; #\space
        (incf offset)) 
      offset))
  
  (defun s2b (s buffer offset &optional newline? (length (length s)))
    (ccl:%put-cstring buffer s offset 255)
    (incf offset length)
    (when newline? 
      (ccl:%put-byte buffer 13 offset)
      (incf offset))
    offset)
  
  (defvar *cmniorefnum* )
  
  (defun mac-Write (ioRefNum ptr cnt)
    (ccl:rlet ((pb :ParamBlockRec))
        (ccl:rset pb ParamBlockRec.ioCompletion (ccl:%null-ptr))
        (ccl:rset pb ParamBlockRec.ioRefNum ioRefNum)
        (ccl:rset pb ParamBlockRec.ioBuffer ptr)
        (ccl:rset pb ParamBlockRec.ioReqCount cnt)
        (ccl:rset pb ParamBlockRec.ioPosMode 0)
        (#_Write pb)
        (ccl:rref pb ParamBlockRec.ioActCount)))
  
  (defun mac-write-string (ioRefNum string &optional length)
    (unless length (setf length (length string)))
    (ccl:with-cstrs ((ptr string 0 length))
      (mac-write ioRefNum ptr length)))

  (defun i2b (m buffer offset)
    (let ((sm (format nil "~D" m)))
      (s2b sm buffer offset nil (length sm))))
  
  (defun c-open (file)
    (ccl:rlet ((pb :ParamBlockRec))
      (ccl:with-pstrs ((filename file))
        (ccl:rset pb ParamBlockRec.ioCompletion (ccl:%null-ptr))
        (ccl:rset pb ParamBlockRec.ioNamePtr filename)
        (ccl:rset pb ParamBlockRec.ioVRefNum 0)
        (ccl:rset pb ParamBlockRec.ioVersNum 0)
        (ccl:rset pb ParamBlockRec.ioPermssn 4) ;ioPermssn=fsRdWrShPerm
        (ccl:rset pb ParamBlockRec.ioMisc (ccl:%null-ptr))
        (unless (probe-file file)
          (#_create pb)
          (ccl:set-mac-file-type file :TEXT)
          (ccl:set-mac-file-creator file :CCL2)
          )
        (#_Open pb)
        (setf *cmniorefnum*
              (ccl:rref pb ParamBlockRec.ioRefNum))
        ;(ccl:rset pb ParamBlockRec.ioMisc 0)                 ; set EOF to 0
	;; EOF code suggested by Tobias Kunze
        (let* ((err (#_SetEOF pb))
               (err? (case err
                       (0 nil)                               ; #$noErr
                       (-34 "The disk is full.")             ; #$dskFulErr
                       (-58 "External file system.")         ; #$extFsErr
                       (-45 "The file is locked.")           ; #$fLckdErr
                       (-38 "The file is not open.")         ; #$fnOpnErr
                       (-36 "I/O Error.")                    ; #$ioErr
                       (-51 "Bad file reference number.")    ; #$rfNumErr
                       (-46 "Software volume Lock.")         ; #$vLckdErr
                       (-44 "Hardware volume Lock.")         ; #$wPrErr
                       (-61 "Read/Write Permission doesn't allow writing."))))
                                                             ; #$wrPermErr
          (when err?
            (error "Couldn't initialize the file ~s:~%~a" file err?)))
        *cmniorefnum*)))
  
  (defun c-close (&optional (ioRefNum *cmniorefnum*))
    (ccl:rlet ((pb :ParamBlockRec))
      (ccl:rset pb ParamBlockRec.ioCompletion (ccl:%null-ptr))
      (ccl:rset pb ParamBlockRec.ioRefNum ioRefNum)
      (#_Close pb )))
  
  (defun c-print (string)
    ;; 9-Dec-93 bil: added #\newline
    (mac-write-string *cmnioRefNum* (format nil "~A~%" string) (1+ (length string))))
  
  (defun c-lineto (array)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (ccl:%put-byte mcl-output 32 len)       ; #\space
      (incf len)
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 1) mcl-output len nil))
      (setf len (s2b " lineto" mcl-output len t 7))
      (mac-write *cmniorefnum* mcl-output len)))
  
  (defun c-rlineto (array)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (ccl:%put-byte mcl-output 32 len)       ; #\space
      (incf len)
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 1) mcl-output len nil))
      (setf len (s2b " rlineto" mcl-output len t 8))
      (mac-write *cmniorefnum* mcl-output len))) 
  
  (defun c-moveto (array)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (ccl:%put-byte mcl-output 32 len)       ; #\space
      (incf len)
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 1) mcl-output len nil))
      (setf len (s2b " moveto" mcl-output len t 7))
      (mac-write *cmniorefnum* mcl-output len))) 
  
  (defun c-rmoveto (array)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (ccl:%put-byte mcl-output 32 len)       ; #\space
      (incf len)
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 1) mcl-output len nil))
      (setf len (s2b " rmoveto" mcl-output len t 8))
      (mac-write *cmniorefnum* mcl-output len))) 
  
  (defun c-curveto (array)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (ccl:%put-byte mcl-output 32 len)       ; #\space
      (incf len)
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 1) mcl-output len t))
      (setf len (f2b (aref array 2) mcl-output len t))
      (setf len (f2b (aref array 3) mcl-output len t))
      (setf len (f2b (aref array 4) mcl-output len t))
      (setf len (f2b (aref array 5) mcl-output len nil))
      (setf len (s2b " curveto" mcl-output len t 8))
      (mac-write *cmniorefnum* mcl-output len))) 
  
  (defun c-fill-in (array string)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (ccl:%put-byte mcl-output 32 len)       ; #\space
      (incf len)
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 1) mcl-output len t))
      (setf len (f2b (aref array 2) mcl-output len t))
      (setf len (f2b (aref array 3) mcl-output len t))
      (setf len (s2b string mcl-output len t))
      (mac-write *cmniorefnum* mcl-output len))) 
  
  (defun c-glyph (byte)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (ccl:%put-byte mcl-output 32 len)       ; #\space
      (incf len)
      (ccl:%put-byte mcl-output 40 len)       ; #\(
      (incf len)
      (ccl:%put-byte mcl-output 92 len)	; #\\
      (incf len)
      ;; 9-Dec-93 bil: this should be the ASCII representation of the integer, not the integer itself
      ;(ccl:%put-byte mcl-output byte len)     ; whatever
      ;(incf len)
      (setf len (i2b byte mcl-output len))
      (setf len (s2b ") show" mcl-output len t 6))
      (mac-write *cmniorefnum* mcl-output len)))
  
  (defun c-font-glyph (string int1 int2)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (setf len (s2b " gsave /" mcl-output len nil 8))
      (setf len (s2b string mcl-output len nil))
      (setf len (s2b " findfont " mcl-output len nil 10))
      (setf len (i2b int1 mcl-output len))	;see above
      (setf len (s2b " scalefont setfont (" mcl-output len nil 20))
      (ccl:%put-byte mcl-output 92 len)	; #\\
      (incf len)
      (setf len (i2b int2 mcl-output len))
      (setf len (s2b ") show grestore" mcl-output len t 15))
      (mac-write *cmniorefnum* mcl-output len)))
  
  (defun c-text (string1 int string2)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (setf len (s2b " gsave /" mcl-output len nil 8))
      (setf len (s2b string1 mcl-output len nil))
      (setf len (s2b " findfont " mcl-output len nil 10))
      (setf len (i2b int mcl-output len))
      (setf len (s2b " scalefont setfont (" mcl-output len nil 20))
      (setf len (s2b string2 mcl-output len nil))
      (setf len (s2b ") show grestore" mcl-output len t 15))
      (mac-write *cmniorefnum* mcl-output len)))
  
  (defun c-stem (array )
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (ccl:%put-byte mcl-output 32 len)       ; #\space
      (incf len)
      (setf len (f2b (aref array 3) mcl-output len nil))
      (setf len (s2b " setlinewidth " mcl-output len nil 14))
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 1) mcl-output len nil))
      (setf len (s2b " moveto " mcl-output len nil 8))
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 2) mcl-output len nil))
      (setf len (s2b " lineto stroke 0 setlinewidth" mcl-output len t 29))
      (mac-write *cmniorefnum* mcl-output len)))
  
  (defun c-just-stem (array)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (ccl:%put-byte mcl-output 32 len)       ; #\space
      (incf len)
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 1) mcl-output len nil))
      (setf len (s2b " moveto " mcl-output len nil 8))
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 2) mcl-output len nil))
      (setf len (s2b " lineto" mcl-output len t 7))
      (mac-write *cmniorefnum* mcl-output len)))
  
  (defun c-line (array)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (ccl:%put-byte mcl-output 32 len)       ; #\space
      (incf len)
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 1) mcl-output len nil))
      (setf len (s2b " moveto " mcl-output len nil 8))
      (setf len (f2b (aref array 2) mcl-output len t))
      (setf len (f2b (aref array 1) mcl-output len nil))
      (setf len (s2b " lineto" mcl-output len t 7))
      (mac-write *cmniorefnum* mcl-output len)))
  
  (defun c-slanted-line (array)
    (let ((len 0))
      (declare (integer len) (optimize (speed 3) (safety 0)))
      (ccl:%put-byte mcl-output 32 len)       ; #\space
      (incf len)
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (aref array 1) mcl-output len nil))
      (setf len (s2b " moveto "     mcl-output len nil 8))
      (setf len (f2b (aref array 0) mcl-output len t))
      (setf len (f2b (+ (aref array 1) (aref array 4)) 
                     mcl-output len nil))
      (setf len (s2b " lineto " mcl-output len nil 8))
      
      (setf len (f2b (aref array 2) mcl-output len t))
      (setf len (f2b (+ (aref array 3) (aref array 4))
                     mcl-output len nil))
      (setf len (s2b " lineto " mcl-output len nil 8))
      
      (setf len (f2b (aref array 2) mcl-output len t))
      (setf len (f2b (aref array 3) mcl-output len nil))
      (setf len (s2b " lineto closepath fill" mcl-output len t 22))
      (mac-write *cmniorefnum* mcl-output len)))

(defun mcl-get-string (num) (#_GetString num))
;;; this can't be in cmn0.lisp where it belongs because the #_ construct confuses other Lisps


  )

