;;;-*- Mode: Lisp; Package: CL-USER -*-
;;;
;;; File: cmn-utils.lisp
;;;
;;; (courtesy Tobias Kunze)

(in-package cl-user)

(export '(qd-cmn *force-new-preview-windows*) :cl-user)

;;; ___________________________________________________________________________
;;;
;;; New quickdraw previewer window handling: 
;;; -  *force-new-preview-windows* determines whether or not a new preview
;;;    window should be created. This should come in handy if multiple
;;;    pages are to be previewed.
;;; -  there is only one view-draw-contents method for qd-preview windows
;;;    left which funcalls the anonymous functions contained in the 
;;;    draw-contents-funs slot of whatever window needs to be refreshed.
;;; -  everything else moved into preview-score
;;; -  moved anything to the cl-user package, which is more secure than 
;;;    messing with ccl.
;;; -  wrapped everything in the file within a call to preview-score
;;; -  anonymous functions contained in the draw-contents-funs slot are
;;;    subject to gc after a window is closed.

(defparameter *force-new-preview-windows* t)

(defvar *cmn-scroller-counter* 1)
;(defvar *cmn-scrollers* nil)                           ; superfluous?

(defclass qd-previewer (ccl::scrolling-window)
  ((draw-contents-funs :initform nil :accessor draw-contents-funs 
                       :initarg :draw-contents-funs)))

(defmethod view-draw-contents ((*cmn-view* qd-previewer))
  (call-next-method)
  (with-focused-view *cmn-view*
    (map nil #'(lambda (fun) 
                 (funcall fun *cmn-view*)) 
         (draw-contents-funs *cmn-view*))))

(defun preview-score (funs &optional title force-new)
  (let ((win (find-if  #'(lambda (x) 
                           (typep x 'qd-previewer))
                       (windows :include-invisibles t)))
        (new-title (or title
                       (prog1
                         (format nil "cmn ~d" *cmn-scroller-counter*)
                         (incf *cmn-scroller-counter*)))))
    (flet ((make-new-previewer ()
             (make-instance 'qd-previewer
               :scroller-class 'ccl::scroller
               :window-type :document-with-zoom
               :view-size #@(300 300)
               :track-thumb-p t
               :draw-contents-funs funs
               :window-show t
               :window-title new-title)))
      (if (and win (not force-new))
        (progn
          (set-window-title win new-title)
          (setf (draw-contents-funs win) funs)
          (invalidate-view win t)       ; ?? need them both?
          (window-select win))          ; ??
        (make-new-previewer)))))

;(preview-score `(,#'(lambda (x) (print x))))


;;; ___________________________________________________________________________
;;;
;;; Easy QuickDraw previewing from outer packages
;;; Requires stella::cmn-eval (from cm/stella/cmn.lisp).
;;; Uses a force-new parameter until I have a better idea...

#+stella
(defmacro qd-cmn (force-new? &rest args)
  (let ((*force-new-preview-windows* force-new?))
    (stella::cmn-eval `(cmn (output-type :quickdraw) ,@args))))

;(qd-cmn t system brace staff treble c4 staff bass cf2 (onset 2))
