;;; -*- syntax: common-lisp; package: cmn; base: 10; mode: lisp -*-
;;;
;;; Traditional western music notation (CMN=Common Music Notation)
;;;
;;; (see font and PostScript level switches just under the package declarations)
;;;

#+excl (when (not (eq excl:*current-case-mode* :case-insensitive-upper))
	 (warn "changing case mode from ~(~A~) to case-insensitive-upper..." excl:*current-case-mode*)
	 (excl:set-case-mode :case-insensitive-upper))


#+KCL (in-package :cmn :use '(:lisp :pcl :loop))
#+KCL (shadow 'system)
#+KCL (shadow 'make-system)

#+(and excl (not cltl2)) 
  (progn
    (require :loop)
    (in-package :cmn :use '(:lisp :pcl :loop))
    (import '(pcl::defconstructor) :cmn))

#+(and Excl cltl2)
  (progn
    (defpackage :cmn (:use :common-lisp :clos) (:shadow "REST") (:import-from "EXCL" "RATIOP"))
    (in-package :cmn)
    #-(or Allegro-v4.2 Allegro-v4.1) (import '(clos::defconstructor) :cmn)
    )

#+clisp 
  (progn
    (defpackage :cmn 
      (:use :loop :pcl :lisp)
      (:shadow "REST")
      (:import-from :pcl "DEFCONSTRUCTOR"))
    (in-package :cmn)
    )

#+Lucid (in-package :cmn :use '(:lisp))	;on Sun, Lucid has CLOS and LOOP built-in
					;I don't know about Lucid's foreign function interface

#+MCL
(progn
  (defpackage :cmn 
    (:use :common-lisp) 
    (:shadow common-lisp:rest CCL:COPY CCL:CANCEL))
  (in-package :cmn)
)

#-(or clisp cltl2) (shadow 'rest)


;;; default font is the Sonata font -- to use Petrucci, put :Petrucci in *features* rather than :Sonata

#-(or Sonata Petrucci) (eval-when (compile load eval) (pushnew :Sonata *features*))
#+Petrucci (defparameter Music-Font "Petrucci-Medium")
#+Sonata (defparameter Music-Font "Sonata")

#-mcl (defvar PS-level 2)
#+mcl (defvar PS-level 1)

(pushnew :cmn *features*)


#+mcl
(progn 
  (setf ccl:*warn-if-redefine* nil)
  (setf ccl:*record-source-file* nil)
  (setf ccl:*save-local-symbols* nil)
  )

#+(and excl Allegro-v3.1) (setf pcl::*defclass-times* '(compile load eval))


;;; since PCL's make instance is about 10 times slower than it needs to be for our use of it,
;;; most of the make-instance calls are packaged up in functions with names like make-<class-name>
;;; and the actual code called is in cmn4.lisp at the very end of the file -- we need to compile
;;; and load the class definitions before calling PCL's defconstructor.
;;;
;;; Similarly, it speeds up slot access by about an order of magnitude if the slot has a unique name.
;;; Most functions with "%" in their name are internal optimizations of some sort -- these redundant
;;; names make our code ugly and hard to read, but it's the user's view that matters, I suppose.


#-Excl (defun ratiop (n) (and (not (integerp n)) (typep n 'ratio)))
#+(and excl (not cltl2)) (import '(excl:ratiop))



(defvar *cmn-version* "Common Music Notation 5-May-94")
(defvar *cmn-news* 
  " 
  5-May:  Clisp FFI support.
  28-Apr: Clisp support added.
  10-Mar: petruccci-medium -> petrucci.
  21-Feb: NeXT previewer -- set *cmn-preview* to t to get this window -- it is not a NeXTStep window,
          but just a DPS rectangle showing the PS output -- click anywhere in the window to close it
          and return to Lisp.  Do not go to some other application in the meantime!  
  13-Feb: Quickdraw output/previewer -- various changes to graphics methods to accomodate Quickdraw.
          simple-draw should be replaced everywhere with draw -- if the pattern keyword was used,
          move it to the immediately preceding lineto or rlineto.  Similarly, circle now accepts
          another argument, t=fill the circle.  New score field output-type, defaults to :postscript,
          if set to :quickdraw (via a message) you get a (lisp) quickdraw program as output.
          CMN ported to NeXtStep/Intel where it runs about 3 times as fast as on the 68040 NeXT.
  1-Feb:  changed PS-level from a compile-time switch to a variable, title spacing implemented
  24,28-Jan: minor bugfixes (wedge primarily)
  17-Jan: pmn.lisp (proportional notation), quarter tones (quarter.lisp)
  10-Jan-94: various minor bugs (line-breaks, mm store, etc)

  10-Dec: cmn-mcl bugfixes.
  3-Dec:  removed nps, cmned, fixed kcl-cmn.
  10-Nov: tablature
  4-Nov:  inverted-turn, 'I' skipped in rehearsal-letter, section c-open bug fixed, stem-marks smarter, :slash note-head
  5..11-Oct: appogiatura=>appoggiatura!, more kinds of repeat-bars
  1-Oct:  mac support improved, cmn0 split in 3 pieces, no-MPW switch removed
  20-Sep: note-head-size on individual notes
  17-Sep: transpose.lisp (score/part transposition)
  8-Sep:  ACL 4.1 changes
  1-Sep:  :new-style staff layout, lyrics.lisp, jimmy.cmn
  26-Aug: staff layout options, bar placement changes, `full' bars
  16-Aug: better regularize actions, first-measure-number, sections with tied staves, measure-rest placement
  10-Aug: tremolo across line-breaks, sections, beam and crescendo bugs, automatic-measure-numbers
  4-Aug:  mac fixups, beaming message to meters, various beaming bugs, *cmn-output-pathname*
  24-Jul: redundant-accidentals, page-hook, and line-hook score slots, more cmn-store work
  15-Jul: more cmn-store bugs, chord note-head placement niceties, a few page-break bugs
  5-Jul:  dy to staff-name, more rests (rests.lisp)
  30-Jun: compile-time switches redone for kcl, various justification nits
  21-Jun: rehearsal-frame-white-space, wedge-beam between staves, brace over more than 2 staves
  15-Jun: added tied-to for notes/chords across staves, crescendo dx0..dy1 and matrix, bracket-type
  7-Jun:  ring.lisp, ccarh.cmn, invisible, time-line regularizer, more dynamics, in-parentheses extended, circled
  20-Apr: Mac II and PS level 1 support
  6-Apr:  more accents, examples, multi-staff beams, line-hook, 1/2 pedal
  1-Apr:  pedal.lisp, accent.lisp, percussion.lisp, fancy meters
  17-Feb: auto-line-break section completely re-done
  3-Feb:  ACL 4.1 support, rest placement under beams, little-swell dynamic mark
  18-Jan: grace notes improved (slashes, chords), dy to note
  13-Jan-93: added minimum-length and stem-dy messages, fixed glissando across clef change

  26-Dec: repeat-measure re-implemented, matrix on most sundries
  23-Dec: in-parentheses on change-beat
  18-Dec: start-dynamic changed to begin-dynamic, added unmetered
  16-Dec: major changes to justification routine
  8-Dec:  wedged beam bugs, patterns
  25-Nov: added initial-onset
  19-Nov-92: added implicit-accidental-style/duration for better automatic-naturals control
")




;;; some timing info for later reference (these are best case "run times", not "real times" --
;;;    the "real times" can be more than twice as long in ACL and Clisp, but KCL and MCL appear
;;;    to have less overhead)

;;; (ACL 3.1 on 16MByte NeXT):  12-91, 1-92   5-92    1-93   2-93 (ACL 4.1)
;;; (time (load "fux.cmn")) ->    31     9      7      7       6
;;; (time (load "moz.cmn")) ->    46     9      7      8.5     6
;;; (time (load "gus.cmn")) ->    54     9      6.5    7.5     6.5
;;; (time (load "carl.cmn")) ->   41    10      7.5    8       7.5
;;; (time (load "joh.cmn")) ->   117    22     20      22     16
;;; (time (load "franz.cmn")) -> 136    28     27      29     22
;;; (time (load "fred.cmn")) ->   69    13     11      12.5   10
;;; (time (load "bucky.cmn")) -> 123    24     25      24     20
;;; (time (load "mir.cmn")) ->          14     13      14     11

;;; (KCL on same):                        3-92                   4-93   2-94 (NSI/Pentium)
;;; (time (load "fux.cmn"))->              14                      6     1.5
;;; (time (load "moz.cmn")) ->             12                      9     3
;;; (time (load "gus.cmn")) ->             27                      8     3
;;; (time (load "carl.cmn")) ->            20                      8     3
;;; (time (load "joh.cmn")) ->             49                     25     7.5
;;; (time (load "franz.cmn")) ->           78                     33    11
;;; (time (load "fred.cmn")) ->            44                     12.5   4.5
;;; (time (load "mir.cmn")) ->             47                     14     5.5

;;; (ACL 4.1 on (16 MB?) SGI Indigo):
;;; (time (load "fux.cmn")) ->           6
;;; (time (load "moz.cmn")) ->           4
;;; (time (load "gus.cmn")) ->           4
;;; (time (load "carl.cmn")) ->          5
;;; (time (load "joh.cmn")) ->          11
;;; (time (load "franz.cmn")) ->        16.5
;;; (time (load "fred.cmn")) ->          8.5
;;; (time (load "mir.cmn")) ->           7.5

;;; (MCL 2.0 on Mac IIfx (system 7) with 8Mbytes):                4-93   1-94 (16MByte 660av)
;;; (time (load "fux.cmn")) ->          50                         14      7   
;;; (time (load "moz.cmn")) ->          86                         16.5   10
;;; (time (load "gus.cmn")) ->         113                         15      9
;;; (time (load "carl.cmn")) ->         89                         18.5   11
;;; (time (load "joh.cmn")) ->        died                         55     29
;;; (time (load "franz.cmn")) ->                                   57.5   39
;;; (time (load "fred.cmn")) ->                                    40.5   17
;;; (time (load "mir.cmn")) ->                                     32.5   16.5

;;; (Clisp on NeXT):                                                         4-94 [ffi]
;;; (time (load "fux.cmn")) ->                                                43  [35]
;;; (time (load "moz.cmn")) ->                                                73  [50]
;;; (time (load "gus.cmn")) ->                                                69  [54]
;;; (time (load "carl.cmn")) ->                                               66  [52]
;;; (time (load "joh.cmn")) ->                                               188 [136]
;;; (time (load "franz.cmn")) ->                                             257 [189]
;;; (time (load "fred.cmn")) ->                                              100  [77]
;;; (time (load "mir.cmn")) ->                                               109  [85]
