;;; -*- Lisp -*-
;;;
;;; this is a load file for CMN.
;;;
;;; To get this file to compile/load everything, you'll need to fix up various pathnames,
;;; and probably set some of the *features* to tell CMN where the files are and what
;;; kind of system it's running on.  The pathnames are pcl-directory, loop-directory,
;;; and cmn-directory.  In MCL, there are also two MCL library files we need.  For explicit
;;; instructions, see README.cmn.

#|
Most of the setup possibilities are handled via identifiers on the *features* list.
The CMN *features* are 

    :sonata          Music font is Adobe's Sonata font.
    :petrucci        Music font is Finale's Petrucci font.

The *features* that CMN adds itself are:

     :cmn

The other *features* that CMN currently notices (leaving aside loop.lisp) are:

     :NeXT           NeXTStep OS.
     :Mac            Macintosh.
     :SGI            SGI.
     :kcl            Kyoto CL (akcl) (any version after 605)
     :excl           Franz Inc's Lisp (Allegro CL)
     :mcl            Macintosh CL
     :allegro-v3.1   ACL version 3.1.20, also :allegro-v4.1 :allegro-v4.2
     :clisp          Clisp
     :cltl2          Current lisp is a version 2 CL -- that is, it uses the later package syntax, etc
     :pcl            Current lisp uses pcl, not a built-in CLOS.
     :foreign        Current Clisp has a foreign function interface.
     :unix           Current Clisp is running under Unix.
     :Next-3.0       Current NeXTStep is version 3.0 or later.
|#


#+(or kcl Allegro-v3.1) 
  (progn
    (defvar pcl-directory "/dist/lisp/pcl2c/")
    (defvar loop-directory "/user/bil/cl/"))

#+(and clisp foreign unix) (ff:load-foreign "clispcmn.o")
#+clisp (defvar pcl-directory "/user/bil/clisp/pcl/")
#+clisp (pushnew :next *features*)

#+clisp (defvar loop-directory "/user/bil/clisp/cmn/")
#+clisp (handler-bind
	 ((t 
	   #'(lambda (c) ; a condition argument
	       (when (find-restart 'continue)
					; cerror is supposed to provide this restart
		     (invoke-restart 'continue)))))
	 (when (not (probe-file (concatenate 'string loop-directory "loop.fas")))
	   (compile-file (concatenate 'string loop-directory "loop.lisp")))
	 (load (concatenate 'string loop-directory "loop.fas")))

#+kcl (progn
	(when (not (probe-file (concatenate 'string loop-directory "loop.o")))
	  (load (concatenate 'string loop-directory "loop.lisp"))
	  (compile-file (concatenate 'string loop-directory "loop.lisp")))
	(load (concatenate 'string loop-directory "loop.o")))

#+(and excl Allegro-v3.1) 
     (progn
       (setf excl:*global-gc-behavior* nil) ;turn off the gc tenure message
       (require :foreign)
       #-loop (when (not (probe-file (concatenate 'string loop-directory "loop.fasl")))
		(compile-file (concatenate 'string loop-directory "loop.lisp")))
       #-loop (load (concatenate 'string loop-directory "loop.fasl")))

;;; if you need pcl, edit pathname and use:
#+(and (not pcl) (or kcl Allegro-v3.1))
  (progn
    (when (not (probe-file (concatenate 'string pcl-directory "defsys" #+kcl ".o" #+excl ".fasl")))
      (compile-file (concatenate 'string pcl-directory "defsys.lisp"))
      (load (concatenate 'string pcl-directory "defsys" #+kcl ".o" #+excl ".fasl"))
      (funcall (find-symbol "COMPILE-PCL" :pcl)))
    (load (concatenate 'string pcl-directory "defsys" #+kcl ".o" #+excl ".fasl"))
    (funcall (find-symbol "LOAD-PCL" :pcl)))

#+(and (not pcl) clisp)
  (handler-bind
      ((t 
	#'(lambda (c)			; a condition argument
	    (when (find-restart 'continue)
					; cerror is supposed to provide this restart
	      (invoke-restart 'continue)))))
    (progn
      (shadow 'ITERATE)
      (when (not (probe-file (concatenate 'string pcl-directory "defsys.fas")))
	(compile-file (concatenate 'string pcl-directory "defsys.lsp"))
	(load (concatenate 'string pcl-directory "defsys.fas"))
	(funcall (find-symbol "COMPILE-PCL" :pcl)))
      (load (concatenate 'string pcl-directory "defsys.fas"))
      (funcall (find-symbol "LOAD-PCL" :pcl))))

;;; if you're using the Sonata font, use:
(pushnew :sonata *features*)

;;; otherwise:
;;; (pushnew :petrucci *features*)

;;; If you are running in NeXT-3.0 or any later version, use:
#+NeXT (pushnew :NEXT-3.0 *features*)

#+mcl (progn
	;; we need the MCL library files quickdraw and scrollers
	(load "Macintosh HD:MCL 2.0:library:quickdraw")
	(load "Macintosh HD:MCL 2.0:library:scrollers")
	)

;;;
;;; fix cmn-directory for your machine. you can add other cmn implementation 
;;; files after the "cmn4" entry in the list below.
;;;

(let ((cmn-dir (if (boundp 'cmn-directory)
		   cmn-directory
		 #+NeXT "/user/bil/cl/"
		 #+Mcl "Macintosh HD:bil:cmn:"
		 #-(or NeXT Mcl) ""
		 )))

  #+kcl (if (not (probe-file (concatenate 'string cmn-dir "cmn0.o")))
	    (progn
	      (system:allocate 'SYMBOL 400)
	      (system:allocate 'CONS 4000))
	  (progn
	    (setf pcl::*defmethod-times* '(compile load eval))
	    (setf pcl::*defclass-times* '(compile load eval))
	    (setf pcl::*defgeneric-times* '(compile load eval))))
  ;; (system:allocate-contiguous-pages 1000) -- no longer necessary in kcl?

  (flet ((compile-and-load (dir name)
           (let ((cname (concatenate 'string dir name ".lisp"))
                 (lname (concatenate 'string dir name 
				     #-(or clisp kcl) ".fasl"
				     #+clisp ".fas"
				     #+kcl ".o"
				     ))
		 (load-it t))
             (if (probe-file cname)
               (if (or (not (probe-file lname))
                       (> (file-write-date cname) (file-write-date lname)))
                 #+mcl(compile-file cname :verbose t)
		 #-mcl (progn
			 #+kcl (setf load-it nil)
			 (compile-file cname))))
             (if load-it (load lname :verbose t)))))
    (dolist (file '(#+mcl "cmn-scroll"
		    "cmn-init" 
		    #+kcl "cmn-kcl"
		    #+mcl "cmn-mcl"
		    #+mcl "cmn-mcl-utils"
		    #+excl "cmn-excl"
		    #+(and clisp foreign unix) "cmn-clisp"
		    "cmn0" "cmn-grfx" "cmn1" "cmn2" "cmn3" "cmn4" 
                    ;; others that are sometimes useful are:
		    "wedge" "accent" "pedal" "percussion" "ring" "rests" "lyrics" "transpose" "pmn" "quarter"
		    ;; all of these are optional -- cmn will work correctly without any of them
                    ))
      (compile-and-load cmn-dir file)))
  )




#|
;;; in excl you can save cmn with
(gc t)
(in-package :cmn)
(excl:dumplisp :name "/zap/cmn" 
	       :restart-function #'(lambda (&rest args)
				     (declare (ignore args))
				     (tpl:setq-default *package*
						       (find-package :cmn))))
|#
