/* support for format statements -- called from cmn0.lisp */

#include <stdio.h>

static FILE *fp;

int OpenCMNFile (char *fileName)
{
  fp = fopen(fileName,"w");
  if (fp == NULL) 
    {
      printf("Cannot open %s.\n",fileName);
      fflush(stdout);
      return 1;
    }
return 0;
}

CloseCMNFile (int useless) /* small Clisp FFI bug */
{
  if (fp != NULL) fclose(fp);
  fp = NULL;
}


PrintCMNFile (char *arr)
{
    fprintf(fp,"%s\n",arr);
}

LinetoCMNFile (float arg0, float arg1)
{
    fprintf(fp," %.2f %.2f lineto\n",arg0,arg1);
}

RLinetoCMNFile (float arg0, float arg1)
{
    fprintf(fp," %.2f %.2f rlineto\n",arg0,arg1);
}

MovetoCMNFile (float arg0, float arg1)
{
    fprintf(fp," %.2f %.2f moveto\n",arg0,arg1);
}

RMovetoCMNFile (float arg0, float arg1)
{
    if (arg1 == 8388608.0) arg1 = 0.0; /* small Clisp FFI bug */
    fprintf(fp," %.2f %.2f rmoveto\n",arg0,arg1);
}

CurvetoCMNFile (float arg0, float arg1, float arg2, float arg3, float arg4, float arg5)
{
    fprintf(fp," %.2f %.2f %.2f %.2f %.2f %.2f curveto\n",arg0,arg1,arg2,arg3,arg4,arg5);
}

FillinCMNFile (float arg0, float arg1, float arg2, float arg3, char *cmd)
{
  fprintf(fp," %.2f %.2f %.2f %.2f %s\n",arg0,arg1,arg2,arg3,cmd);
}

GlyphCMNFile (int glf)
{
  fprintf(fp," (\\%d) show\n",glf);
}

FontGlyphCMNFile (char *font, int size, int glf)
{
  fprintf(fp," gsave /%s findfont %d scalefont setfont (\\%d) show grestore\n",font,size,glf);
}

FontTextCMNFile (char *font, int size, char *str)
{
  fprintf(fp," gsave /%s findfont %d scalefont setfont (%s) show grestore\n",font,size,str);
}

StemCMNFile (float arg0, float arg1, float arg2, float arg3)
{
  fprintf(fp," %.2f setlinewidth %.2f %.2f moveto %.2f %.2f lineto stroke 0 setlinewidth\n",arg3,arg0,arg1,arg0,arg2);
}

VerticalLineCMNFile (float arg0, float arg1, float arg2)
{
  fprintf(fp," %.2f %.2f moveto %.2f %.2f lineto\n",arg0,arg1,arg0,arg2);
}

HorizontalLineCMNFile (float arg0, float arg1, float arg2)
{
  fprintf(fp," %.2f %.2f moveto %.2f %.2f lineto\n",arg0,arg1,arg2,arg1);
}

SlantedLineCMNFile (float arg0, float arg1, float arg2, float arg3, float arg4)
{
  fprintf(fp," %.2f %.2f moveto %.2f %.2f lineto %.2f %.2f lineto %.2f %.2f lineto closepath fill\n",
	   arg0,arg1,arg0,arg1+arg4,arg2,arg3+arg4,arg2,arg3);
}
