This file describes three paths from NeXT 2.0 or 2.1 to either 3.0
or 3.2.  The first goes from 2.1 to 3.0:

------------------------------------------------------------------------
Thanks to Bill Vrotney, clm does run in ACL on the NeXT 3.0 -- I'll
append the instructions; First the note from Vrotney, then the further
changes to get the library names fixed, and get the dsp functions
loaded:


In comp.sys.next.programmer article <1992Oct9.042738.22990@ads.com> Bill Vrotney wrote:
> 
> I thought it was going to take me longer to get a method out for doing this
> but the ucl.o file that I had was not the Franz patched file, so it is
> actually pretty simple as long as you update to the Franz patched ucl.o.
> 
> The following is a procedure for fixing Allegro CL 3.1.20 so that it works
> under NeXTstep 3.0. I don't have 3.0 so I need someone to try this out and
> report back to this news group.
> 
>   Warning!!! (from Franz) This procedure results in creating a new ucl.o
>   binary file. You may distribute this method but not the resulting ucl.o
>   file. 
> 
>   You should find all of the files mentioned here on your ACL distribution
>   floppies. If you do not have the Franz patch mentioned below you will
>   have to ask Franz for it.
> 
>         1. You need to patch your existing ucl.o file, if it is not
>            already patched, with an existing patch from Franz. This is
>            done with an existing shell script called
> 
>                 install_patch.sh
> 
>            and an existing patch file called
> 
>                 patch.uu
> 
>            To verify that you have done the right thing, after this patch
>            is installed the ucl.o file should be 612364 bytes.
> 
>         2. Then you edit the binary file in emacs and save the results.
>            You are going to edit your existing ucl.o file so that you might
>            want to save the existing ucl.o to ucl.orig.o. Then run emacs
>            and do:
> 
>                 find-file ucl.o
>                 replace-string _rld _jld
>                 replace-string __bcopy _bcopy^@
>                 save-buffer
{my comment -- notice that the first __bcopy has 2 underbars}
> 
>            The ^@ above is the null character (000 byte) and can be
>            entered in emacs using
> 
>                 C-q C-<space>
> 
>            and will look in an emacs buffer as a single character ^@
>            and NOT two characters.
> 
> 
>         3. You then reinstall ACL as usual.
{my comment -- see below}
> 
> --
> Bill Vrotney
> BAH/Advanced Decision Systems




This works on a 3.0 system, if you make the following
changes to the ACL build/config file:

In the LIBRARIES statement, change -ldsp_s to -ldsp
and change the USYMS statement to:

USYMS = -u _SNDReadSoundfile -u _SNDStartPlaying -u _SNDWait -u _SNDFree -u _SNDStop -u _SNDSetHost -u _SNDAcquire -u _snddriver_get_device_parms -u _SNDRelease -u _snddriver_set_device_parms -u _snddriver_get_volume -u _snddriver_set_volume -u _snddriver_set_ramp -u _DSPOpenNoBoot -u _DSPClose -u _valloc -u libsys_s -u libNeXT_s


If you want to run Rick Taube's Common Music, use these lines:

LIBRARIES = -lNeXT_s -ldsp -lsys_s
USYMS = -u _SNDReadSoundfile -u _SNDStartPlaying -u _SNDWait -u _SNDFree -u _SNDStop -u _SNDSetHost -u _SNDAcquire -u _snddriver_get_device_parms -u _SNDRelease -u _snddriver_set_device_parms -u _snddriver_get_volume -u _snddriver_set_volume -u _snddriver_set_ramp -u _DSPOpenNoBoot -u _DSPClose -u _valloc -u _mutex_try_lock -u _mutex_wait_lock -u _MIDIBecomeOwner -u _MIDIClaimUnit -u _MIDISetClockMode -u _MIDISetClockQuantum -u _MIDISetSystemIgnores -u _MIDIRequestExceptions -u _MIDIGetAvailableQueueSize -u _MIDISetClockTime -u _MIDIStartClock -u _MIDIReleaseOwnership -u _MIDIStopClock -u _MIDIGetClockTime -u _MIDISendData -u _MIDIRequestData -u _MIDIHandleReply -u _MIDIClearQueue -u _cthread_detach -u _port_set_allocate -u _port_set_add -u _port_set_deallocate -u _name_server_port -u libsys_s -u libNeXT_s


Next, go to the file build/custom.cl and add the line:

(pushnew ':NeXT-3.0 *features*)


You'll need to get libdsp.a from the ccrma-ftp.stanford.edu server, 
or from the MusicKit also distributed at ccrma-ftp.  
It should be placed on /usr/lib or /usr/local/lib.


Finally go to a terminal and sh config.  If the config
process dies with 

    /bin/ld: table of contents for archive: /usr/lib/libdsp.a 
    is out of date; rerun ranlib(1) (can't load from it)

you need to 

    ranlib -t /usr/lib/libdsp.a

and sh config again.  CLM and CMN assume that
you built lisp with case-mode set to case-insensitive-upper.


If you're using the MusicKit with Common Music
you'll also need the following files:

/usr/local/bin/playscore

/usr/local/lib/dsp/monitor/mkmon_8k.dsp

/usr/local/lib/MusicKit/fixedpolicy

In the 3.0 NeXT release, there's a version of these files 
in the standard release (on /usr/bin and /usr/lib) but this 
will go away in future NeXT releases. 




------------------------------------------------------------------------
Now to go from that version to 3.1 or 3.2, change the
LIBRARIES statement to

LIBRARIES = -lNeXT_s -ldsp -lsys_s -lsys_p

and rebuild lisp.

(Thanks to Charlie Baker).

------------------------------------------------------------------------
And, to go from 2.1 to 3.1 (I haven't done this myself):

Newsgroups: comp.sys.next.programmer
Path: nntp.Stanford.EDU!headwall.Stanford.EDU!agate!howland.reston.ans.net!math.ohio-state.edu!caen!batcomputer!cornell!freimer
From: freimer@cs.cornell.edu (Robert Freimer)
Subject: Using Allegro Common Lisp 3.1.20 under NeXTSTEP 3.1
Message-ID: <1993Jul20.140859.25540@cs.cornell.edu>
Organization: Cornell Univ. CS Dept, Ithaca NY 14853
Date: Tue, 20 Jul 1993 14:08:59 GMT
Lines: 87

When I upgraded my cube to 3.1, I discovered that ACL no longer
worked.  I tried rebuilding and received an error that _alloca was
undefined.  This is caused by the switch from GNU C 1.93 to 2.2.2.
alloca() is no longer in the system library and now is an internal
function to the C compiler.  The fix is to rebuild with the non-shared
versions of the 3.0 libraries.

The following procedure for fixing a virgin Allegro Common Lisp is
modified from a comp.sys.next.programmer article by Bill Vrotney.  You
should find all of the files mentioned here on your ACL distribution.
I refer to the top level directory of this distribution as ACL/ and
the build directory ACL/build.  For upgrading from a system that
worked with 3.0, follow steps 3, 4, and 6.

Warning!!! (from Franz Inc.) This procedure results in creating a new
ucl.o binary file. You may distribute this method but not the
resulting ucl.o file.

1. Install the MusicKit_3.1.pkg available by anonymous ftp from
ccrma-ftp.stanford.edu.  The Music and DSP libraries are no longer
supported by NeXT.  This package includes the 3.1 version of libdsp.
The other option is to drop -ldsp from the LIBRARIES statement in step
4 below.

2. First look at the byte size of the file ACL/build/ucl.o, if the
size is 612364 bytes then skip to step 3.  Otherwise look at the file
ACL/dumplispPatch. This is a shell archive that will patch ucl.o with
the "dump lisp" patch.  More precisely

cd ACL
cp dumplispPatch build
cd build
/bin/sh dumplispPatch
/bin/sh install_patch.sh

Now ucl.o should be 612364 bytes long. Tthe original ucl.o will be
saved in a file called ucl_orig.o.

3. Create symbolic links from the 3.0 non-shared libraries on CDROM.
This saves space on your hard disk, since the libraries should not be
needed, except when rebuilding ACL.  Another option is to copy the
libraries.

ln -s /NeXTSTEP_3.0/lib/libsys_p.a /lib/libsys3.0_p.a
ln -s /NeXTSTEP_3.0/usr/lib/libNeXT_p.a /usr/lib/libNeXT3.0_p.a

4. Edit the file ACL/build/config.  You might want to save the orginal
<config file.  Replace the following lines

LIBRARIES = -lNeXT_s -ldsp_s -lsys_s
USYMS = -u libsys_s -u libNeXT_s -u libdsp_s

with:

LIBRARIES = -lNeXT3.0_p -ldsp -lsys3.0_p
USYMS =

5. Edit the new binary file ACL/build/ucl.o in emacs and save the
results. Go to ACL/build directory, run emacs and

find-file ucl.o
replace-string _rld _jld
replace-string __bcopy _bcopy^@
save-buffer

The ^@ above is the null character (000 byte) and can be entered in
emacs using

C-q C-<space>

and will look in an emacs buffer as a single character ^@ and NOT two
characters.

6. Finally reinstall ACL as usual. You do this by going to the
ACL/build directory and

/bin/sh config

7. The online version of the manual (cl-manual.tar.Z) is available by
anonymous ftp from sonata.cc.purdue.edu, under /pub/next/docs.  Also
grab fi-gnu-clman.tar.Z, which contain the emacs lisp code to index
the manual.



