
(definstrument ztap-example (start duration frequency amplitude
			     &key
			     (aphase 0.0)
			     (bphase 0.0)
			     (cphase 0.0)
			     (dphase 0.0)
			     (index-func '(0 0 0.1 1.5 0.5 2.0 0.9 0.8 1 0))
			     (amp-func '(0 0 0.1 1 0.9 1 1 0))
			     (reverb-amount 0.05))
  (let* ((sinewave (make-oscil :frequency frequency))
	 (modulator (make-oscil :frequency (* 2.5 frequency)))
	 (envelope (make-env :envelope amp-func
			     :scaler amplitude
			     :start-time start
			     :duration duration))
	 (index (make-env :envelope index-func
			  :scaler 0.5
			  :start-time start
			  :duration duration))
	 (z (make-zdelay 300 :true-length 8600))
	 (sample 0.0)
	 (beg (floor (* start sampling-rate)))
	 (end (+ beg (floor (* duration sampling-rate)))))
      (Run
       (loop for i from beg to end do
	 (setf sample (* (env envelope)(oscil sinewave (* (env index)
							  (oscil modulator)))))
	 (if (or (quad)(stereo))(outb i (ztap z bphase)))
	 (if (quad)(progn (outc i (ztap z cphase))
			  (outd i (ztap z dphase))))
	 (outa i (zdelay z sample aphase))))))


