;;; -*- syntax: common-lisp; package: clm; base: 10; mode: lisp -*-
;;;
(in-package :clm)
;;;
;;; languages currently are :56k and :c
;;;
;;; I tried to handle this through lisp's package mechanism, but ran into too many dumb problems.
;;; So, for the forseeable future, the :c56 package is the code generator, independent of the 56000.
;;; There are the following basic groups of macros:
;;;   start and end -- these provide a handle for initialization and cleanup actions
;;;   CLM supported lisp functions
;;;   i-code linearization ops (i.e. test, goto, and label in various forms)
;;;   built-in unit-generators
;;;   built-in unit-generator structure fields


;;; start and end wrappers

(defmacro <start> (beg end) 
  (case *clm-language*
    (:c   `(<start_c> ,beg ,end))
    (:56k `(<start_56> ,beg ,end))))

(defmacro <end> (&optional no-output-here) 
  (case *clm-language*
    (:c   `(<end_c> ,no-output-here))
    (:56k `(<end_56> ,no-output-here))))


;;; special sample loop exit
(defmacro <loop-finish> ()
  (case *clm-language*
    (:c   `(<loop-finish_c>))
    (:56k `(<loop-finish_56>))))


;;; built-in lisp functions
(defmacro <setf> (result-name arg) 
  (case *clm-language*
    (:c   `(<setf_c> ,result-name ,arg))
    (:56k `(<setf_56> ,result-name ,arg))))

(defmacro <negate> (result-name arg) 
  (case *clm-language*
    (:c   `(<negate_c> ,result-name ,arg))
    (:56k `(<negate_56> ,result-name ,arg))))

(defmacro <abs> (result-name arg)  
  (case *clm-language*
    (:c   `(<abs_c> ,result-name ,arg))
    (:56k `(<abs_56> ,result-name ,arg))))

(defmacro <add> (result-name &rest args) 
  (case *clm-language*
    (:c   `(<add_c> ,result-name ,@args))
    (:56k `(<add_56> ,result-name ,@args))))

(defmacro <subtract> (result-name val &rest args) 
  (case *clm-language*
    (:c   `(<subtract_c> ,result-name ,val ,@args))
    (:56k `(<subtract_56> ,result-name ,val ,@args))))

(defmacro <add-1> (result-name arg1)
  (case *clm-language*
    (:c   `(<add-1_c> ,result-name ,arg1))
    (:56k `(<add-1_56> ,result-name ,arg1))))

(defmacro <subtract-1> (result-name arg1)
  (case *clm-language*
    (:c   `(<subtract-1_c> ,result-name ,arg1))
    (:56k `(<subtract-1_56> ,result-name ,arg1))))

(defmacro <multiply> (result-name &rest args) 
  (case *clm-language*
    (:c   `(<multiply_c> ,result-name ,@args))
    (:56k `(<multiply_56> ,result-name ,@args))))

(defmacro <divide> (result-name val &rest args) 
  (case *clm-language*
    (:c   `(<divide_c> ,result-name ,val ,@args))
    (:56k `(<divide_56> ,result-name ,val ,@args))))

(defmacro <incf> (result-name arg1 &optional (arg2 1)) 
  (case *clm-language*
    (:c   `(<incf_c> ,result-name ,arg1 ,arg2))
    (:56k `(<incf_56> ,result-name ,arg1 ,arg2))))

(defmacro <decf> (result-name arg1 &optional (arg2 1)) 
  (case *clm-language*
    (:c   `(<decf_c> ,result-name ,arg1 ,arg2))
    (:56k `(<decf_56> ,result-name ,arg1 ,arg2))))

(defmacro <max> (result-name &rest args)  
  (case *clm-language*
    (:c   `(<max_c> ,result-name ,@args))
    (:56k `(<max_56> ,result-name ,@args))))

(defmacro <min> (result-name &rest args) 
  (case *clm-language*
    (:c   `(<min_c> ,result-name ,@args))
    (:56k `(<min_56> ,result-name ,@args))))

(defmacro <log> (result-name arg &optional base)    
  (case *clm-language*
    (:c   `(<log_c> ,result-name ,arg ,base))
    (:56k `(<log_56> ,result-name ,arg ,base))))

(defmacro <sin> (result-name arg)  
  (case *clm-language*
    (:c   `(<sin_c> ,result-name ,arg))
    (:56k `(<sin_56> ,result-name ,arg))))

(defmacro <cos> (result-name arg)  
  (case *clm-language*
    (:c   `(<cos_c> ,result-name ,arg))
    (:56k `(<cos_56> ,result-name ,arg))))

(defmacro <tan> (result-name arg)  
  (case *clm-language*
    (:c   `(<tan_c> ,result-name ,arg))
    (:56k `(<tan_56> ,result-name ,arg))))

(defmacro <asin> (result-name arg) 
  (case *clm-language*
    (:c   `(<asin_c> ,result-name ,arg))
    (:56k `(<asin_56> ,result-name ,arg))))

(defmacro <acos> (result-name arg) 
  (case *clm-language*
    (:c   `(<acos_c> ,result-name ,arg))
    (:56k `(<acos_56> ,result-name ,arg))))

(defmacro <atan> (result-name arg &optional arg2)   
  (case *clm-language*
    (:c   `(<atan_c> ,result-name ,arg ,arg2))
    (:56k `(<atan_56> ,result-name ,arg ,arg2))))

(defmacro <sinh> (result-name arg) 
  (case *clm-language*
    (:c   `(<sinh_c> ,result-name ,arg))
    (:56k `(<sinh_56> ,result-name ,arg))))

(defmacro <cosh> (result-name arg) 
  (case *clm-language*
    (:c   `(<cosh_c> ,result-name ,arg))
    (:56k `(<cosh_56> ,result-name ,arg))))

(defmacro <tanh> (result-name arg) 
  (case *clm-language*
    (:c   `(<tanh_c> ,result-name ,arg))
    (:56k `(<tanh_56> ,result-name ,arg))))

(defmacro <asinh> (result-name arg)  
  (case *clm-language*
    (:c   `(<asinh_c> ,result-name ,arg))
    (:56k `(<asinh_56> ,result-name ,arg))))

(defmacro <acosh> (result-name arg)  
  (case *clm-language*
    (:c   `(<acosh_c> ,result-name ,arg))
    (:56k `(<acosh_56> ,result-name ,arg))))

(defmacro <atanh> (result-name arg)  
  (case *clm-language*
    (:c   `(<atanh_c> ,result-name ,arg))
    (:56k `(<atanh_56> ,result-name ,arg))))

(defmacro <atan2> (result-name argy argx) 
  (case *clm-language*
    (:c   `(<atan2_c> ,result-name ,argy ,argx))
    (:56k `(<atan2_56> ,result-name ,argy ,argx))))

(defmacro <signum> (result-name arg) 
  (case *clm-language*
    (:c   `(<signum_c> ,result-name ,arg))
    (:56k `(<signum_56> ,result-name ,arg))))

(defmacro <random> (result-name argl) 
  (case *clm-language*
    (:c   `(<random_c> ,result-name ,argl))
    (:56k `(<random_56> ,result-name ,argl))))

(defmacro <expt> (result-name base arg)  
  (case *clm-language*
    (:c   `(<expt_c> ,result-name ,base ,arg))
    (:56k `(<expt_56> ,result-name ,base ,arg))))

(defmacro <exp> (result-name arg) 
  (case *clm-language*
    (:c   `(<exp_c> ,result-name ,arg))
    (:56k `(<exp_56> ,result-name ,arg))))

(defmacro <float> (result-name arg)  
  (case *clm-language*
    (:c   `(<float_c> ,result-name ,arg))
    (:56k `(<float_56> ,result-name ,arg))))

(defmacro <floor> (result-name arg &optional div-1)  
  (case *clm-language*
    (:c   `(<floor_c> ,result-name ,arg ,div-1))
    (:56k `(<floor_56> ,result-name ,arg ,div-1))))

(defmacro <ceiling> (result-name argl &optional div-1) 
  (case *clm-language*
    (:c   `(<ceiling_c> ,result-name ,argl ,div-1))
    (:56k `(<ceiling_56> ,result-name ,argl ,div-1))))

(defmacro <round> (result-name argl &optional div-1) 
  (case *clm-language*
    (:c   `(<round_c> ,result-name ,argl ,div-1))
    (:56k `(<round_56> ,result-name ,argl ,div-1))))

(defmacro <truncate> (result-name argl &optional div-1) 
  (case *clm-language*
    (:c   `(<truncate_c> ,result-name ,argl ,div-1))
    (:56k `(<truncate_56> ,result-name ,argl ,div-1))))

(defmacro <numerator> (result-name arg) 
  (case *clm-language*
    (:c   `(<numerator_c> ,result-name ,arg))
    (:56k `(<numerator_56> ,result-name ,arg))))

(defmacro <denominator> (result-name arg) 
  (case *clm-language*
    (:c   `(<denominator_c> ,result-name ,arg))
    (:56k `(<denominator_56> ,result-name ,arg))))

(defmacro <sqrt> (result-name arg)  
  (case *clm-language*
    (:c   `(<sqrt_c> ,result-name ,arg))
    (:56k `(<sqrt_56> ,result-name ,arg))))

(defmacro <ash> (result-name arg1 arg2) 
  (case *clm-language*
    (:c   `(<ash_c> ,result-name ,arg1 ,arg2))
    (:56k `(<ash_56> ,result-name ,arg1 ,arg2))))

(defmacro <mod> (result-name arg1 arg2 &optional rem-time) 
  (case *clm-language*
    (:c   `(<mod_c> ,result-name ,arg1 ,arg2 ,rem-time))
    (:56k `(<mod_56> ,result-name ,arg1 ,arg2 ,rem-time))))

(defmacro <rem> (result-name arg1 arg2) 
  (case *clm-language*
    (:c   `(<rem_c> ,result-name ,arg1 ,arg2))
    (:56k `(<rem_56> ,result-name ,arg1 ,arg2))))

(defmacro <gcd> (result-name &rest args) 
  (case *clm-language*
    (:c   `(<gcd_c> ,result-name ,@args))
    (:56k `(<gcd_56> ,result-name ,@args))))

(defmacro <lcm> (result-name &rest args) 
  (case *clm-language*
    (:c   `(<lcm_c> ,result-name ,@args))
    (:56k `(<lcm_56> ,result-name ,@args))))

(defmacro <lognot> (result-name arg) 
  (case *clm-language*
    (:c   `(<lognot_c> ,result-name ,arg))
    (:56k `(<lognot_56> ,result-name ,arg))))

(defmacro <logand> (result-name &rest args) 
  (case *clm-language*
    (:c   `(<logand_c> ,result-name ,@args))
    (:56k `(<logand_56> ,result-name ,@args))))

(defmacro <logior> (result-name &rest args) 
  (case *clm-language*
    (:c   `(<logior_c> ,result-name ,@args))
    (:56k `(<logior_56> ,result-name ,@args))))

(defmacro <logxor> (result-name &rest args) 
  (case *clm-language*
    (:c   `(<logxor_c> ,result-name ,@args))
    (:56k `(<logxor_56> ,result-name ,@args))))

(defmacro <logeqv> (result-name &rest args) 
  (case *clm-language*
    (:c   `(<logeqv_c> ,result-name ,@args))
    (:56k `(<logeqv_56> ,result-name ,@args))))

(defmacro <lognand> (result-name i1 i2) 
  (case *clm-language*
    (:c   `(<lognand_c> ,result-name ,i1 ,i2))
    (:56k `(<lognand_56> ,result-name ,i1 ,i2))))

(defmacro <lognor> (result-name i1 i2) 
  (case *clm-language*
    (:c   `(<lognor_c> ,result-name ,i1 ,i2))
    (:56k `(<lognor_56> ,result-name ,i1 ,i2))))

(defmacro <logandc1> (result-name i1 i2) 
  (case *clm-language*
    (:c   `(<logandc1_c> ,result-name ,i1 ,i2))
    (:56k `(<logandc1_56> ,result-name ,i1 ,i2))))

(defmacro <logandc2> (result-name i1 i2) 
  (case *clm-language*
    (:c   `(<logandc2_c> ,result-name ,i1 ,i2))
    (:56k `(<logandc2_56> ,result-name ,i1 ,i2))))

(defmacro <logorc1> (result-name i1 i2) 
  (case *clm-language*
    (:c   `(<logorc1_c> ,result-name ,i1 ,i2))
    (:56k `(<logorc1_56> ,result-name ,i1 ,i2))))

(defmacro <logorc2> (result-name i1 i2) 
  (case *clm-language*
    (:c   `(<logorc2_c> ,result-name ,i1 ,i2))
    (:56k `(<logorc2_56> ,result-name ,i1 ,i2))))

(defmacro <break> (result-name &optional fstr &rest args) 
  (case *clm-language*
    (:c   `(<break_c> ,result-name ,fstr ,@args))
    (:56k `(<break_56> ,result-name ,fstr ,@args))))

(defmacro <warn> (result-name &optional fstr &rest args) 
  (case *clm-language*
    (:c   `(<warn_c> ,result-name ,fstr ,@args))
    (:56k `(<warn_56> ,result-name ,fstr ,@args))))

(defmacro <error> (result-name &optional fstr &rest args) 
  (case *clm-language*
    (:c   `(<error_c> ,result-name ,fstr ,@args))
    (:56k `(<error_56> ,result-name ,fstr ,@args))))

(defmacro <print> (result-name fstr) 
  (case *clm-language*
    (:c   `(<print_c> ,result-name ,fstr))
    (:56k `(<print_56> ,result-name ,fstr))))

(defmacro <clm-print> (result-name fstr &rest args) 
  (case *clm-language*
    (:c   `(<clm-print_c> ,result-name ,fstr ,@args))
    (:56k `(<clm-print_56> ,result-name ,fstr ,@args))))

(defmacro <princ> (result-name fstr) 
  (case *clm-language*
    (:c   `(<princ_c> ,result-name ,fstr))
    (:56k `(<princ_56> ,result-name ,fstr))))

(defmacro <y-or-n-p> (result-name &optional fstr &rest args) 
  (case *clm-language*
    (:c   `(<y-or-n-p_c> ,result-name ,fstr ,@args))
    (:56k `(<y-or-n-p_56> ,result-name ,fstr ,@args))))

(defmacro <yes-or-no-p> (result-name &optional fstr &rest args) 
  (case *clm-language*
    (:c   `(<yes-or-no-p_c> ,result-name ,fstr ,@args))
    (:56k `(<yes-or-no-p_56> ,result-name ,fstr ,@args))))

(defmacro <terpri> (result-name) 
  (case *clm-language*
    (:c   `(<terpri_c> ,result-name))
    (:56k `(<terpri_56> ,result-name))))

(defmacro <apply> (result-name function-name &rest args) 
  (case *clm-language*
    (:c   `(<apply_c> ,result-name ,function-name ,@args))
    (:56k `(<apply_56> ,result-name ,function-name ,@args))))

(defmacro <funcall> (result-name function-name &rest args) 
  (case *clm-language*
    (:c   `(<funcall_c> ,result-name ,function-name ,@args))
    (:56k `(<funcall_56> ,result-name ,function-name ,@args))))



;;; linearization jumps 

(defmacro <label> (arg)       
  (case *clm-language*
    (:c   `(<label_c> ,arg))
    (:56k `(<label_56> ,arg))))

(defmacro <hide> (&rest args) 
  (case *clm-language*
    (:c   `(<hide_c> ,@args))
    (:56k `(<hide_56> ,@args))))

(defmacro <jump> (arg)        
  (case *clm-language*
    (:c   `(<jump_c> ,arg))
    (:56k `(<jump_56> ,arg))))

(defmacro <jump-true> (arg)   
  (case *clm-language*
    (:c   `(<jump-true_c> ,arg))
    (:56k `(<jump-true_56> ,arg))))

(defmacro <jump-false> (arg)  
  (case *clm-language*
    (:c   `(<jump-false_c> ,arg))
    (:56k `(<jump-false_56> ,arg))))

(defmacro <jump-l> (arg)    
  (case *clm-language*
    (:c   `(<jump-l_c> ,arg))
    (:56k `(<jump-l_56> ,arg))))

(defmacro <jump-leq> (arg)  
  (case *clm-language*
    (:c   `(<jump-leq_c> ,arg))
    (:56k `(<jump-leq_56> ,arg))))

(defmacro <jump-neq> (arg)  
  (case *clm-language*
    (:c   `(<jump-neq_c> ,arg))
    (:56k `(<jump-neq_56> ,arg))))

(defmacro <jump-eq> (arg)   
  (case *clm-language*
    (:c   `(<jump-eq_c> ,arg))
    (:56k `(<jump-eq_56> ,arg))))

(defmacro <jump-geq> (arg)  
  (case *clm-language*
    (:c   `(<jump-geq_c> ,arg))
    (:56k `(<jump-geq_56> ,arg))))

(defmacro <jump-g> (arg)    
  (case *clm-language*
    (:c   `(<jump-g_c> ,arg))
    (:56k `(<jump-g_56> ,arg))))

(defmacro <jump-mi> (arg)   
  (case *clm-language*
    (:c   `(<jump-mi_c> ,arg))
    (:56k `(<jump-mi_56> ,arg))))

(defmacro <jump-pl> (arg)   
  (case *clm-language*
    (:c   `(<jump-pl_c> ,arg))
    (:56k `(<jump-pl_56> ,arg))))

(defmacro <local-label> (arg) 
  (case *clm-language*
    (:c   `(<local-label_c> ,arg))
    (:56k `(<local-label_56> ,arg))))

(defmacro <undefine> (&rest args) 
  (case *clm-language*
    (:c   `(<undefine_c> ,@args))
    (:56k `(<undefine_56> ,@args))))

#|
;;; not currently used
(defmacro <push> (result-name argl) 
  (case *clm-language*
    (:c   `(<push_c> ,result-name ,argl))
    (:56k `(<push_56> ,result-name ,argl))))

(defmacro <pop> (argl) 
  (case *clm-language*
    (:c   `(<pop_c> ,argl))
    (:56k `(<pop_56> ,argl))))

(defmacro <pop-and-toss> () 
  (case *clm-language*
    (:c   `(<pop-and-toss_c>))
    (:56k `(<pop-and-toss_56>))))
|#

(defmacro <case> (index name-list label-list) 
  (case *clm-language*
    (:c   `(<case_c> ,index ,name-list ,label-list))
    (:56k `(<case_56> ,index ,name-list ,label-list))))

(defmacro <logtest> (result-name a-i1 a-i2) 
  (case *clm-language*
    (:c   `(<logtest_c> ,result-name ,a-i1 ,a-i2))
    (:56k `(<logtest_56> ,result-name ,a-i1 ,a-i2))))

(defmacro <test> (result-name argl) 
  (case *clm-language*
    (:c   `(<test_c> ,result-name ,argl))
    (:56k `(<test_56> ,result-name ,argl))))

(defmacro <not-null> (argl) 
  (case *clm-language*
    (:c   `(<not-null_c> ,argl))
    (:56k `(<not-null_56> ,argl))))

(defmacro <logbitp> (result-name indl argl) 
  (case *clm-language*
    (:c   `(<logbitp_c> ,result-name ,indl ,argl))
    (:56k `(<logbitp_56> ,result-name ,indl ,argl))))

(defmacro <test-bit-0> (result-name arg) 
  (case *clm-language*
    (:c   `(<test-bit-0_c> ,result-name ,arg))
    (:56k `(<test-bit-0_56> ,result-name ,arg))))

(defmacro <compare> (argl1 argl2 &optional dont-need-C)	;that is, arg1 - arg2 -- opposite from 56000
  (case *clm-language*
    (:c   `(<compare_c> ,argl1 ,argl2 ,dont-need-C))
    (:56k `(<compare_56> ,argl1 ,argl2))))



;;; built-in unit-generators and associated bookkeeping macros

(defmacro <oscil> (result-name s &optional fm-1 pm-1) 
  (case *clm-language*
    (:c   `(<oscil_c> ,result-name ,s ,fm-1 ,pm-1))
    (:56k `(<oscil_56> ,result-name ,s ,fm-1 ,pm-1))))

(defmacro <simple-wave> (result-name s fm-1 lib-op typ offset) 
  (case *clm-language*
    (:c   `(<simple-wave_c> ,result-name ,s ,fm-1 ,lib-op ,typ ,offset))
    (:56k `(<simple-wave_56> ,result-name ,s ,fm-1 ,lib-op ,typ ,offset))))

(defmacro <square-wave> (result-name s &optional fm) 
  (case *clm-language*
    (:c   `(<square-wave_c> ,result-name ,s ,fm))
    (:56k `(<square-wave_56> ,result-name ,s ,fm))))

(defmacro <pulse-train> (result-name s &optional fm) 
  (case *clm-language*
    (:c   `(<pulse-train_c> ,result-name ,s ,fm))
    (:56k `(<pulse-train_56> ,result-name ,s ,fm))))

(defmacro <triangle-wave> (result-name s &optional fm) 
  (case *clm-language*
    (:c   `(<triangle-wave_c> ,result-name ,s ,fm))
    (:56k `(<triangle-wave_56> ,result-name ,s ,fm))))

(defmacro <sawtooth-wave> (result-name s &optional fm) 
  (case *clm-language*
    (:c   `(<sawtooth-wave_c> ,result-name ,s ,fm))
    (:56k `(<sawtooth-wave_56> ,result-name ,s ,fm))))

(defmacro <sum-of-cosines> (result-name s &optional fm) 
  (case *clm-language*
    (:c   `(<sum-of-cosines_c> ,result-name ,s ,fm))
    (:56k `(<sum-of-cosines_56> ,result-name ,s ,fm))))

(defmacro <ur-table-lookup> (result-name s &optional fm-1) 
  (case *clm-language*
    (:c   `(<ur-table-lookup_c> ,result-name ,s ,fm-1))
    (:56k `(<ur-table-lookup_56> ,result-name ,s ,fm-1))))

(defmacro <randh> (result-name s &optional fm) 
  (case *clm-language*
    (:c   `(<randh_c> ,result-name ,s ,fm))
    (:56k `(<randh_56> ,result-name ,s ,fm))))

(defmacro <randi> (result-name s &optional fm) 
  (case *clm-language*
    (:c   `(<randi_c> ,result-name ,s ,fm))
    (:56k `(<randi_56> ,result-name ,s ,fm))))

(defmacro <amplitude-modulate> (result-name cr-1 s1-1 s2-1) 
  (case *clm-language*
    (:c   `(<amplitude-modulate_c> ,result-name ,cr-1 ,s1-1 ,s2-1))
    (:56k `(<amplitude-modulate_56> ,result-name ,cr-1 ,s1-1 ,s2-1))))

(defmacro <polynomial> (result-name tab x) 
  (case *clm-language*
    (:c   `(<polynomial_c> ,result-name ,tab ,x))
    (:56k `(<polynomial_56> ,result-name ,tab ,x))))

(defmacro <dot-product> (result-name s1 s2) 
  (case *clm-language*
    (:c   `(<dot-product_c> ,result-name ,s1 ,s2))
    (:56k `(<dot-product_56> ,result-name ,s1 ,s2))))

(defmacro <table-interp> (result-name s index) 
  (case *clm-language*
    (:c   `(<table-interp_c> ,result-name ,s ,index))
    (:56k `(<table-interp_56> ,result-name ,s ,index))))

(defmacro <array-interp> (result-name s index) 
  (case *clm-language*
    (:c   `(<array-interp_c> ,result-name ,s ,index))
    (:56k `(<array-interp_56> ,result-name ,s ,index))))

(defmacro <one-pole> (result-name filt in-argl) 
  (case *clm-language*
    (:c   `(<one-pole_c> ,result-name ,filt ,in-argl))
    (:56k `(<one-pole_56> ,result-name ,filt ,in-argl))))

(defmacro <one-zero> (result-name filt in-argl) 
  (case *clm-language*
    (:c   `(<one-zero_c> ,result-name ,filt ,in-argl))
    (:56k `(<one-zero_56> ,result-name ,filt ,in-argl))))

(defmacro <two-pole> (result-name filt in-argl) 
  (case *clm-language*
    (:c   `(<two-pole_c> ,result-name ,filt ,in-argl))
    (:56k `(<two-pole_56> ,result-name ,filt ,in-argl))))

(defmacro <two-zero> (result-name filt in-argl) 
  (case *clm-language*
    (:c   `(<two-zero_c> ,result-name ,filt ,in-argl))
    (:56k `(<two-zero_56> ,result-name ,filt ,in-argl))))

(defmacro <filter> (result-name s in-argl) 
  (case *clm-language*
    (:c   `(<filter_c> ,result-name ,s ,in-argl))
    (:56k `(<filter_56> ,result-name ,s ,in-argl))))

(defmacro <direct-filter> (result-name s in-argl) 
  (case *clm-language*
    (:c   `(<direct-filter_c> ,result-name ,s ,in-argl))
    (:56k `(<direct-filter_56> ,result-name ,s ,in-argl))))

(defmacro <lattice-filter> (result-name s in-argl) 
  (case *clm-language*
    (:c   `(<lattice-filter_c> ,result-name ,s ,in-argl))
    (:56k `(<lattice-filter_56> ,result-name ,s ,in-argl))))

(defmacro <ladder-filter> (result-name s in-argl) 
  (case *clm-language*
    (:c   `(<ladder-filter_c> ,result-name ,s ,in-argl))
    (:56k `(<ladder-filter_56> ,result-name ,s ,in-argl))))

(defmacro <check> (ref &optional (id 2)) 
  (case *clm-language*
    (:c   `(<check_c> ,ref ,id))
    (:56k `(<check_56> ,ref ,id))))

(defmacro <delay> (result-name del in-argl) 
  (case *clm-language*
    (:c   `(<delay_c> ,result-name ,del ,in-argl))
    (:56k `(<delay_56> ,result-name ,del ,in-argl))))

(defmacro <tap> (result-name del &optional offset)
  (case *clm-language*
    (:c   `(<tap_c> ,result-name ,del ,offset))
    (:56k `(<tap_56> ,result-name ,del ,offset))))

(defmacro <zdelay> (result-name del in-argl &optional pm) 
  (case *clm-language*
    (:c   `(<zdelay_c> ,result-name ,del ,in-argl ,pm))
    (:56k `(<zdelay_56> ,result-name ,del ,in-argl ,pm))))

(defmacro <ztap> (result-name del &optional pm) 
  (case *clm-language*
    (:c   `(<ztap_c> ,result-name ,del ,pm))
    (:56k `(<ztap_56> ,result-name ,del ,pm))))

(defmacro <comb> (result-name cmbf in-arg) 
  (case *clm-language*
    (:c   `(<comb_c> ,result-name ,cmbf ,in-arg))
    (:56k `(<comb_56> ,result-name ,cmbf ,in-arg))))

(defmacro <all-pass> (result-name filt in-arg) 
  (case *clm-language*
    (:c   `(<all-pass_c> ,result-name ,filt ,in-arg))
    (:56k `(<all-pass_56> ,result-name ,filt ,in-arg))))

(defmacro <env> (result-name e &optional restart) 
  (case *clm-language*
    (:c   `(<env_c> ,result-name ,e))
    (:56k `(<env_56> ,result-name ,e ,restart))))

(defmacro <restart-env> (result-name e) 
  (case *clm-language*
    (:c   `(<restart-env_c> ,result-name ,e))
    (:56k `(<restart-env_56> ,result-name ,e))))

(defmacro <aref> (result-name arr arr-type &rest indices) 
  (case *clm-language*
    (:c   `(<aref_c> ,result-name ,arr ,arr-type ,@indices))
    (:56k `(<aref_56> ,result-name ,arr ,arr-type ,@indices))))

(defmacro <tref> (result-name tab tab-type ind &optional (store nil)) 
  (case *clm-language*
    (:c   `(<tref_c> ,result-name ,tab ,tab-type ,ind ,store))
    (:56k `(<tref_56> ,result-name ,tab ,tab-type ,ind ,store))))

(defmacro <setf-tref> (result-name tab tab-type ind) 
  (case *clm-language*
    (:c   `(<setf-tref_c> ,result-name ,tab ,tab-type ,ind))
    (:56k `(<setf-tref_56> ,result-name ,tab ,tab-type ,ind))))

(defmacro <outa> (result-name pass val &optional o-stream) 
  (case *clm-language*
    (:c   `(<outa_c> ,result-name ,pass ,val ,o-stream))
    (:56k `(<outa_56> ,result-name ,pass ,val ,o-stream))))

(defmacro <outb> (result-name pass val &optional o-stream) 
  (case *clm-language*
    (:c   `(<outb_c> ,result-name ,pass ,val ,o-stream))
    (:56k `(<outb_56> ,result-name ,pass ,val ,o-stream))))

(defmacro <outc> (result-name pass val &optional o-stream) 
  (case *clm-language*
    (:c   `(<outc_c> ,result-name ,pass ,val ,o-stream))
    (:56k `(<outc_56> ,result-name ,pass ,val ,o-stream))))

(defmacro <outd> (result-name pass val &optional o-stream) 
  (case *clm-language*
    (:c   `(<outd_c> ,result-name ,pass ,val ,o-stream))
    (:56k `(<outd_56> ,result-name ,pass ,val ,o-stream))))

(defmacro <locsig> (result-name loc-1 pass val-1) 
  (case *clm-language*
    (:c   `(<locsig_c> ,result-name ,loc-1 ,pass ,val-1))
    (:56k `(<locsig_56> ,result-name ,loc-1 ,pass ,val-1))))

(defmacro <in-a> (result-name pass &optional (o-stream nil)) 
  (case *clm-language*
    (:c   `(<in-a_c> ,result-name ,pass ,o-stream)) 
    (:56k `(<in-a_56> ,result-name ,pass ,o-stream)) ))

(defmacro <in-b> (result-name pass &optional (o-stream nil)) 
  (case *clm-language*
    (:c   `(<in-b_c> ,result-name ,pass ,o-stream))
    (:56k `(<in-b_56> ,result-name ,pass ,o-stream))))

(defmacro <in-c> (result-name pass &optional (o-stream nil)) 
  (case *clm-language*
    (:c   `(<in-c_c> ,result-name ,pass ,o-stream))
    (:56k `(<in-c_56> ,result-name ,pass ,o-stream))))

(defmacro <in-d> (result-name pass &optional (o-stream nil)) 
  (case *clm-language*
    (:c   `(<in-d_c> ,result-name ,pass ,o-stream))
    (:56k `(<in-d_56> ,result-name ,pass ,o-stream))))

(defmacro <quad> (result-name &optional fil) 
  (case *clm-language*
    (:c   `(<quad_c> ,result-name ,fil))
    (:56k `(<quad_56> ,result-name ,fil))))

(defmacro <stereo> (result-name &optional fil) 
  (case *clm-language*
    (:c   `(<stereo_c> ,result-name ,fil))
    (:56k `(<stereo_56> ,result-name ,fil))))

(defmacro <mono> (result-name &optional fil) 
  (case *clm-language*
    (:c   `(<mono_c> ,result-name ,fil))
    (:56k `(<mono_56> ,result-name ,fil))))

(defmacro <resample> (result-name s &optional (sr nil))	 
  (case *clm-language*
    (:c   `(<resample_c> ,result-name ,s ,sr))
    (:56k `(<resample_56> ,result-name ,s ,sr))))

(defmacro <src> (result-name s &optional fm-1) 
  (case *clm-language*
    (:c   `(<src_c> ,result-name ,s ,fm-1))
    (:56k `(<src_56> ,result-name ,s ,fm-1))))

(defmacro <read-position> (result-name rd) 
  (case *clm-language*
    (:c   `(<read-position_c> ,result-name ,rd))
    (:56k `(<read-position_56> ,result-name ,rd))))

(defmacro <read-forward> (result-name rd) 
  (case *clm-language*
    (:c   `(<read-forward_c> ,result-name ,rd))
    (:56k `(<read-forward_56> ,result-name ,rd))))

(defmacro <read-backward> (result-name rd) 
  (case *clm-language*
    (:c   `(<read-backward_c> ,result-name ,rd))
    (:56k `(<read-backward_56> ,result-name ,rd))))

(defmacro <readin> (result-name rd) 
  (case *clm-language*
    (:c   `(<readin_c> ,result-name ,rd))
    (:56k `(<readin_56> ,result-name ,rd))))

(defmacro <check-readin> (rd)	 
  (case *clm-language*
    (:c   `(<check-readin_c> ,rd))
    (:56k `(<check-readin_56> ,rd))))

(defmacro <check-locsig> (rd)	 
  (case *clm-language*
    (:c   `(<check-locsig_c> ,rd))
    (:56k nil)))

(defmacro <check-expand> (rd)	 
  (case *clm-language*
    (:c   `(<check-expand_c> ,rd))
    (:56k `(<check-expand_56> ,rd))))

(defmacro <check-resample> (rd)	 
  (case *clm-language*
    (:c   `(<check-resample_c> ,rd))
    (:56k `(<check-resample_56> ,rd))))

(defmacro <check-src> (rd)	 
  (case *clm-language*
    (:c   `(<check-src_c> ,rd))
    (:56k `(<check-src_56> ,rd))))

(defmacro <check-fftflt> (rd)	 
  (case *clm-language*
    (:c   `(<check-fftflt_c> ,rd))
    (:56k `(<check-fftflt_56> ,rd))))

(defmacro <check-convolve> (rd)	 
  (case *clm-language*
    (:c   `(<check-convolve_c> ,rd))
    (:56k `(<check-convolve_56> ,rd))))

(defmacro <expand> (result-name e) 
  (case *clm-language*
    (:c   `(<expand_c> ,result-name ,e))
    (:56k `(<expand_56> ,result-name ,e))))

(defmacro <run-block> (result-name e) 
  (case *clm-language*
    (:c   `(<run-block_c> ,result-name ,e))
    (:56k `(<run-block_56> ,result-name ,e))))

(defmacro <fft> (result-name data &optional (fft-dir 1)) 
  (case *clm-language*
    (:c   `(<fft_c> ,result-name ,data ,fft-dir))
    (:56k `(<fft_56> ,result-name ,data ,fft-dir))))

(defmacro <inverse-fft> (result-name data) 
  (case *clm-language*
    (:c   `(<inverse-fft_c> ,result-name ,data))
    (:56k `(<inverse-fft_56> ,result-name ,data))))

(defmacro <clear-block> (result-name data) 
  (case *clm-language*
    (:c   `(<clear-block_c> ,result-name ,data))
    (:56k `(<clear-block_56> ,result-name ,data))))

(defmacro <spectrum> (result-name freq phase size &optional (normalized t)) 
  (case *clm-language*
    (:c   `(<spectrum_c> ,result-name ,freq ,phase ,size ,normalized))
    (:56k `(<spectrum_56> ,result-name ,freq ,phase ,size ,normalized))))

(defmacro <fft-window> (result-name data window) 
  (case *clm-language*
    (:c   `(<fft-window_c> ,result-name ,data ,window))
    (:56k `(<fft-window_56> ,result-name ,data ,window))))

(defmacro <fft-filter> (result-name ff) 
  (case *clm-language*
    (:c   `(<fft-filter_c> ,result-name ,ff))
    (:56k `(<fft-filter_56> ,result-name ,ff))))

(defmacro <convolve> (result-name ff) 
  (case *clm-language*
    (:c   `(<convolve_c> ,result-name ,ff))
    (:56k `(<convolve_56> ,result-name ,ff))))

(defmacro <wave-train> (result-name e &optional in-argl) 
  (case *clm-language*
    (:c   `(<wave-train_c> ,result-name ,e ,in-argl))
    (:56k `(<wave-train_56> ,result-name ,e ,in-argl))))



;;; now all the built-in unit-generator structure field accessors (can be highly optimized in many cases)

(defmacro <sw-current-value> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sw-current-value_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <sw-phase> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sw-phase_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 1 ,typ 1 ,in-setf))))

(defmacro <sw-freq> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sw-freq_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 2 ,typ 1 ,in-setf))))

(defmacro <sw-base> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sw-base_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 4 ,typ 1 ,in-setf))))

(defmacro <osc-phase> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<osc-phase_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <osc-freq> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<osc-freq_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 1 ,typ 1 ,in-setf))))

(defmacro <noi-phase> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<noi-phase_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <noi-freq> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<noi-freq_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 1 ,typ 1 ,in-setf))))

(defmacro <noi-output> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<noi-output_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 3 ,typ 1 ,in-setf))))

(defmacro <noi-base> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<noi-base_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 4 ,typ 1 ,in-setf))))

(defmacro <noi-incr> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<noi-incr_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 5 ,typ 1 ,in-setf))))

(defmacro <dly-size> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<dly-size_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 2 ,typ 1 ,in-setf))))

(defmacro <dly-pline> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<dly-pline_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 0 ,typ 1 ,in-setf))))

(defmacro <dly-loc> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<dly-loc_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 1 ,typ 1 ,in-setf))))

(defmacro <tbl-phase> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<tbl-phase_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <tbl-freq> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<tbl-freq_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 1 ,typ 1 ,in-setf))))

(defmacro <tbl-table> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<tbl-table_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 3 ,typ 1 ,in-setf))))

(defmacro <tbl-table-size> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<tbl-table-size_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 3 ,typ 1 ,in-setf))))

(defmacro <tbl-internal-mag> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<tbl-internal-mag_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 4 ,typ 1 ,in-setf))))

(defmacro <cmbflt-scaler> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<cmbflt-scaler_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 3 ,typ 1 ,in-setf))))

(defmacro <cmbflt-dly-unit> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<cmbflt-dly-unit_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <allpassflt-feedback> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<allpassflt-feedback_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 3 ,typ 1 ,in-setf))))

(defmacro <allpassflt-feedforward> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<allpassflt-feedforward_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 3 ,typ 1 ,in-setf))))

(defmacro <allpassflt-dly-unit> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<allpassflt-dly-unit_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <smpflt-a0> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smpflt-a0_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 0 ,typ 2 ,in-setf))))

(defmacro <smpflt-a1> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smpflt-a1_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 1 ,typ 2 ,in-setf))))

(defmacro <smpflt-a2> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smpflt-a2_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 2 ,typ 2 ,in-setf))))

(defmacro <smpflt-b1> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smpflt-b1_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 0 ,typ 2 ,in-setf))))

(defmacro <smpflt-b2> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smpflt-b2_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 1 ,typ 2 ,in-setf))))

(defmacro <smpflt-x1> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smpflt-x1_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 0 ,typ 1 ,in-setf))))

(defmacro <smpflt-x2> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smpflt-x2_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 2 ,typ 1 ,in-setf))))

(defmacro <smpflt-y1> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smpflt-y1_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 1 ,typ 1 ,in-setf))))

(defmacro <smpflt-y2> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smpflt-y2_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 2 ,typ 1 ,in-setf))))

(defmacro <frmnt-g> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<frmnt-g_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <frmnt-tz> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<frmnt-tz_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 1 ,typ 1 ,in-setf))))

(defmacro <frmnt-tp> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<frmnt-tp_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 4 ,typ 1 ,in-setf))))

(defmacro <rdin-i> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<rdin-i_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <rdin-inc> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<rdin-inc_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 1 ,typ 1 ,in-setf))))

(defmacro <rdin-chn> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<rdin-chn_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(rdin-chan ,nvar)))))

(defmacro <rdin-fil> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<rdin-fil_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(rdin-fil ,nvar)))))

(defmacro <wt-wave> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<wt-wave_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 4 ,typ 1 ,in-setf))))

(defmacro <wt-wsiz> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<wt-wsiz_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 5 ,typ 1 ,in-setf))))

(defmacro <wt-freq> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<wt-freq_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 7 ,typ 1 ,in-setf))))

(defmacro <wt-b> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<wt-b_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <wt-internal-mag> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<wt-internal-mag_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 11 ,typ 1 ,in-setf))))

(defmacro <wt-phase> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<wt-phase_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 6 ,typ 1 ,in-setf))))

(defmacro <rblk-siz> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<rblk-siz_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 2 ,typ 1 ,in-setf))))

(defmacro <rblk-buf> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<rblk-buf_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 2 ,typ 1 ,in-setf))))

(defmacro <rblk-loc> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<rblk-loc_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <rblk-ctr> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<rblk-ctr_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 1 ,typ 1 ,in-setf))))

(defmacro <fftflt-env> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<fftflt-env_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 15 ,typ 1 ,in-setf))))

(defmacro <fftflt-siz> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<fftflt-siz_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 4 ,typ 1 ,in-setf))))

(defmacro <fftflt-hop> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<fftflt-hop_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 4 ,typ 1 ,in-setf))))

(defmacro <fftflt-rd> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<fftflt-rd_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 8 ,typ 1 ,in-setf))))

(defmacro <fftflt-b> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<fftflt-b_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <fftflt-datar> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<fftflt-datar_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 6 ,typ 1 ,in-setf))))

(defmacro <fftflt-datai> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<fftflt-datai_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 6 ,typ 1 ,in-setf))))

(defmacro <fftflt-half-siz> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<fftflt-half-siz_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 5 ,typ 1 ,in-setf))))

(defmacro <fft-data-real> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<fft-data-real_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <fft-data-imaginary> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<fft-data-imaginary_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 2 ,typ 1 ,in-setf))))

(defmacro <fft-data-size> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<fft-data-size_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 0 ,typ 1 ,in-setf))))

(defmacro <flt-m> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<flt-m_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 0 ,typ 1 ,in-setf))))

(defmacro <flt-typ> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<flt-typ_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 0 ,typ 1 ,in-setf))))

(defmacro <flt-so> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<flt-so_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 3 ,typ 1 ,in-setf))))

(defmacro <flt-a> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<flt-a_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 4 ,typ 1 ,in-setf))))

(defmacro <flt-b> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<flt-b_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 6 ,typ 1 ,in-setf))))

(defmacro <flt-c> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<flt-c_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 8 ,typ 1 ,in-setf))))

(defmacro <flt-d> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<flt-d_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 10 ,typ 1 ,in-setf))))

(defmacro <smp-sr> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smp-sr_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 2 ,typ 1 ,in-setf))))

(defmacro <smp-lst> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smp-lst_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 0 ,typ 1 ,in-setf))))

(defmacro <smp-nxt> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smp-nxt_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 0 ,typ 1 ,in-setf))))

(defmacro <smp-i> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<smp-i_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 3 ,typ 1 ,in-setf))))

(defmacro <sr-incr> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sr-incr_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 3 ,typ 1 ,in-setf))))

(defmacro <sr-rd> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sr-rd_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 6 ,typ 1 ,in-setf))))

(defmacro <sr-x> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sr-x_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 2 ,typ 1 ,in-setf))))

(defmacro <sr-data> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sr-data_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 4 ,typ 1 ,in-setf))))

(defmacro <sr-filt> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sr-filt_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 13 ,typ 1 ,in-setf))))

(defmacro <sr-left> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sr-left_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 0 ,typ 1 ,in-setf))))

(defmacro <sr-right> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sr-right_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 0 ,typ 1 ,in-setf))))

(defmacro <sr-width> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<sr-width_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 1 ,typ 1 ,in-setf))))

(defmacro <ws-tab> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<ws-tab_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <ws-os> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<ws-os_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 3 ,typ 1 ,in-setf))))

(defmacro <ws-offset> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<ws-offset_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 2 ,typ 1 ,in-setf))))

(defmacro <zdly-phase> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<zdly-phase_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 4 ,typ 1 ,in-setf))))

(defmacro <zdly-del> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<zdly-del_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 5 ,typ 1 ,in-setf))))

(defmacro <cosp-phase> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<cosp-phase_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 0 ,typ 1 ,in-setf))))

(defmacro <cosp-freq> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<cosp-freq_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 1 ,typ 1 ,in-setf))))

(defmacro <cosp-scaler> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<cosp-scaler_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(cosp-scaler ,nvar)))))

(defmacro <cosp-cosines> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<cosp-cosines_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(cosp-cosines ,nvar)))))

(defmacro <locs-ascl> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<locs-ascl_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 0 ,typ 1 ,in-setf))))

(defmacro <locs-bscl> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<locs-bscl_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 0 ,typ 1 ,in-setf))))

(defmacro <locs-cscl> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<locs-cscl_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 2 ,typ 1 ,in-setf))))

(defmacro <locs-dscl> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<locs-dscl_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 2 ,typ 1 ,in-setf))))

(defmacro <locs-rscl> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<locs-rscl_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 1 ,typ 1 ,in-setf))))

(defmacro <locs-deg> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<locs-deg_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(locs-deg ,var ,nvar)))))

(defmacro <locs-dis> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<locs-dis_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(locs-dis ,var ,nvar)))))

(defmacro <locs-pc-rev> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<locs-pc-rev_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(locs-pc-rev ,var ,nvar)))))

(defmacro <locs-revname> (var nvar typ in-setf)
  (case *clm-language*
	(:c `(<locs-revname> ,var ,nvar ,in-setf))
	(:56k (let ((new-addr (new-signal)))
		`(<dsp-address_56 ,new-addr ,nvar Y 1 ,typ ,in-setf)
		`(<logbitp> ,var 2 ,new-addr)))))

(defmacro <spd-rd> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<spd-rd_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 5 ,typ 1 ,in-setf))))

(defmacro <spd-len> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<spd-len_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 2 ,typ 1 ,in-setf))))

(defmacro <spd-rmp> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<spd-rmp_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 3 ,typ 1 ,in-setf))))

(defmacro <spd-amp> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<spd-amp_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 4 ,typ 1 ,in-setf))))

(defmacro <spd-in-spd> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<spd-in-spd_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 14 ,typ 1 ,in-setf))))

(defmacro <spd-out-spd> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<spd-out-spd_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 12 ,typ 1 ,in-setf))))

(defmacro <spd-cur-in> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<spd-cur-in_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar L 13 ,typ 1 ,in-setf))))

(defmacro <spd-cur-out> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<spd-cur-out_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 2 ,typ 1 ,in-setf))))

(defmacro <spd-s20> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<spd-s20_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 14 ,typ 1 ,in-setf))))

(defmacro <spd-s50> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<spd-s50_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar Y 12 ,typ 1 ,in-setf))))

(defmacro <spd-ctr> (var nvar typ in-setf)
  (case *clm-language*
    (:c `(<spd-ctr_c> ,var ,nvar ,in-setf))
    (:56k `(<dsp-address_56> ,var ,nvar X 1 ,typ 1 ,in-setf))))

(defmacro <io-fil> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-fil_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-fil ,nvar)))))

(defmacro <io-beg> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-beg_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-beg ,nvar)))))

(defmacro <io-end> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-end_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-end ,nvar)))))

(defmacro <io-data-end> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-data-end_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-data-end ,nvar)))))

(defmacro <io-data-start> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-data-start_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-data-start ,nvar)))))

(defmacro <io-bufsiz> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-bufsiz_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-bufsiz ,nvar)))))

(defmacro <io-dir> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-dir_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-dir ,nvar)))))

(defmacro <io-dat-a> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-dat-a_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-dat-a ,nvar)))))

(defmacro <io-dat-b> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-dat-b_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-dat-b ,nvar)))))

(defmacro <io-dat-c> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-dat-c_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-dat-c ,nvar)))))

(defmacro <io-dat-d> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-dat-d_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-dat-d ,nvar)))))

(defmacro <io-open-index> (var nvar typ in-setf)
  (declare (ignore typ))
  (case *clm-language*
    (:c `(<io-open-index_c> ,var ,nvar ,in-setf))
    (:56k (give-up `(io-open-index ,nvar)))))
