/* DAC and sound-file header support for clm on the SGI Indigo */

#include <audio.h>
#include <stdio.h>
#include <fcntl.h>

/* from headers.c */
extern int c_read_header_with_fd (int chan);
extern int c_snd_header_data_size (void);
extern int c_snd_header_data_location (void);
extern int c_snd_header_chans (void);
extern int c_snd_header_type (void);
extern int c_snd_header_srate (void);
extern int c_snd_header_format (void);
extern void c_update_header_with_fd(int chan, int type, int siz);


int volume = 100;               /* "gain" in SGI */

int setvolume (int g)
{
  volume = g;
  return 0;
}

int getvolume (void)
{
  return volume;
}

int urdac (char* arg)
{
  long fil, audio, datasize, srate, dataloc, 
       channels, snd_magic_number, format;
  long amp[4], sr[2];
  int bytes_read, samps_read;
  short* buffer;
  unsigned size = 100000;  /* default dac buffer size in samples */
  ALconfig config;
  ALport audio_p;

  fil = open(arg,O_RDONLY); 

  /* get header info */
  c_read_header_with_fd(fil);
  dataloc = c_snd_header_data_location();
  datasize = c_snd_header_data_size();
  format = c_snd_header_format();
  if (format != 1) /* 16-bit linear */
    {
      printf("%s is not a 16-bit integer sound file.",arg);
      fflush(stdout);
      return 0;
    }
  srate = c_snd_header_srate();
  channels = c_snd_header_chans();

  /* initialize audio */
  
  amp[0]=AL_LEFT_SPEAKER_GAIN;  
  amp[1]=volume;
  amp[2]=AL_RIGHT_SPEAKER_GAIN; 
  amp[3]=volume;
  ALsetparams(AL_DEFAULT_DEVICE,amp,4);

  sr[0]=AL_OUTPUT_RATE;
  sr[1]=srate;
  ALsetparams(AL_DEFAULT_DEVICE,sr,2);

  config = ALnewconfig(); 
  ALsetwidth(config,AL_SAMPLE_16);
  ALsetchannels(config,channels);
  audio_p = ALopenport("dac","w",config);

  /* read samples */

  buffer=(short *)calloc(size,sizeof(short));
  lseek(fil,dataloc,SEEK_SET);

  while ((bytes_read = read(fil,buffer,size)) != 0)
    {
      samps_read=bytes_read/2;
      ALwritesamps(audio_p,buffer,samps_read);
      while (ALgetfilled(audio_p) > 0) sginap(1);
    }

  /* cleanup */

  close(fil);
  ALcloseport(audio_p);
  ALfreeconfig(config);
  free(buffer);

  return 0;
}


/*
main(int argc, char **argv)
{
  char *filename;
  filename = argv[1];
  urdac(filename);
  exit(0);
}

*/
