;;; -*- syntax: common-lisp; package: clm; base: 10; mode: lisp -*-

(in-package :clm)

(defun hi-ok ()
  (and (or (/= 0 (dsp-is-open))
	   #+QP (/= 0 (qp-is-open))
	   )
       (/= -1 (dsp-check-host-interface))))

  ;; for real-time controls (this in monitor in lib56.lisp, loaded in <end> in ins56.lisp)
  ;; (emit '(ORG #x26)
  ;; (emit '(JSR .R-T))

  ;; then the actual code (executed by the HC interrupt):
(defun R-T-load ()
  (emit '(.R-T))
#|
  (emit `(DEFINE rt-addr ,(get-X-memory)))
  (emit '(STORE R0 X rt-addr))
  (emit '(rt-loop))
  (emit '(JCLR M-HRDF X-IO M-HSR rt-loop))
  (emit '(HIDE rt-loop))
  (emit '(LOAD R0 X-IO M-HRX))
  (emit '(JCLR M-HF0 X-IO M-HSR get-it))
  (emit '(rt-loop-1))
  (emit '(JCLR M-HRDF X-IO M-HSR rt-loop-1))
  (emit '(HIDE rt-loop-1))
  (emit '(JCLR M-HF1 X-IO M-HSR set-x-mem))
  (emit '(MOVE X-IO M-HRX Y R0 R))
  (emit '(JMP done))
  (emit '(set-x-mem LOCAL))
  (emit '(MOVE X-IO M-HRX X R0 R))
  (emit '(JMP done))
  (emit '(get-it LOCAL))
  (emit '(JCLR M-HF1 X-IO M-HSR get-x-mem))
  (emit '(MOVE Y R0 R X-IO M-HTX))
  (emit '(JMP done))
  (emit '(get-x-mem LOCAL))
  (emit '(MOVE X R0 R X-IO M-HTX))
  (emit '(done LOCAL))
  (emit '(LOAD R0 X rt-addr))
|#
  (emit '(RTI)))

 
(defconstant HF1 #b10000)
(defconstant HF0 #b1000)

(defun get-X (addr) 
  (dsp-write-ICR 0)
  (dsp-write-CVR #x93)
  (lsp-put-one-word addr)
  (lsp-get-one-word))

(defun get-Y (addr) 
  (dsp-write-ICR HF1)
  (dsp-write-CVR #x93)
  (lsp-put-one-word addr)
  (lsp-get-one-word))

(defun get-L (addr) 
  (+ (get-y addr) (ash (get-x addr) 24)))

(defun set-X (addr val) 
  (dsp-write-ICR HF0)
  (dsp-write-CVR #x93)
  (lsp-put-one-word addr)
  (lsp-put-one-word val))

(defun set-Y (addr val) 
  (dsp-write-ICR (+ HF0 HF1))
  (dsp-write-CVR #x93)
  (lsp-put-one-word addr)
  (lsp-put-one-word val))

(defun set-L (addr valx valy) 
  (set-y addr valy) 
  (set-x addr valx))

(defun instrument-value (ins var)
  (let ((val (gethash var (get (dsp-data-ins-name ins) :ins-vars))))
    ;; val = '((mem addr) type el-type-if-array)
    (dsp-set (dsp-data-slot ins) (dsp-data-dsp ins))
    (if (hi-ok)
	(let ((addr (second (first val)))
	      (mem (first (first val))))
	  (if (eq 'X mem) 
	      (get-X addr)		;has to be integer
	    (if (eq 'Y mem)
		(frac24 (get-Y addr))	;has to be fraction
	      (scale-float (float (get-L addr)) -24))))
      (print "dsp not running"))))

(defun setf-instrument-value (ins var val)
  (let ((kval (gethash var (get (dsp-data-ins-name ins) :ins-vars))))
    (dsp-set (dsp-data-slot ins) (dsp-data-dsp ins))
    (if (hi-ok)
	(let ((mem (first (first kval)))
	      (addr (second (first kval))))
	  (if (eq 'X mem)
	      (set-X addr (make-integer val))
	    (if (eq 'Y mem)
		(set-Y addr (make-fraction val))
	      (multiple-value-bind
		  (x y) (make-real val)
		(set-L addr x y)))))
      (print "dsp not runnning")))
  val)

(defsetf instrument-value setf-instrument-value)
