;;; -*- syntax: common-lisp; package: clm; base: 10; mode: lisp -*-
;;;
;;;  stubs to turn QP support into no-ops (for Mac and so on)

(in-package :clm)

;;; qp.lisp replacements
(defun qp-error () (if c56-debug (print "attempt to call a QP stub procedure")) -1)

(defun qp-check-all-slots (arr) 
  (setf (aref arr 0) -1)
  (setf (aref arr 1) -1)
  (setf (aref arr 2) -1)
  1)

(defun qp-all-done () (qp-error))
(defun qp-boot-dsp (i j k m n o) (declare (ignore i j k m n o)) (qp-error))
(defun qp-save-built-in-dsp () (qp-error))
(defun qp-set-current-dsp (i j) (declare (ignore i j)) -1)
(defun qp-is-open () 0)
(defun qp-close () (qp-all-done))
(defun qp-initialize () 0)
(defun get-qp-info () nil)

(defvar qp-info nil)

(defstruct QP-data (fbeg 0) 
	           (fend -1) 
		   (fdata-end 0)
		   (active-bufs 0) 
		   (iolocs nil) 
		   (DRAM-adrs nil) 
		   (master nil)
		   (buf-size 0)
		   (DRAM-size 0)
		   (current-dsp nil)
		   (fdata-start 0)
		   (trigger-point 0))

(defvar qps nil)

;;; qplib56.lisp replacements
(defun QP-initialize-names () 
  (emit '(DEFINE DMC-MCR        #xFFFA))
  (emit '(DEFINE DMC-reset 4)))

(defun QP-initialize-temps () nil)
(defun QP-in-current-DRAM-frame (ld-ptr QP-ptr) (declare (ignore ld-ptr QP-ptr)))
(defun QP-master-is-done-merging (master) (declare (ignore master)))
(defun QP-master-is-done-initializing (master) (declare (ignore master)))
(defun QP-master-is-done-shifting (master) (declare (ignore master)))
(defun QP-save-IO-data (ptr x-or-y j srams xs) (declare (ignore ptr x-or-y j srams xs)))
(defun QP-fire-up-merging-monitor (master &optional no-output) (declare (ignore master no-output)))
(defun QP-merge (curdsp curld cursiz &optional (beg 0)) (declare (ignore curdsp curld cursiz beg)))
(defun qp-flush (m beg) (declare (ignore m beg)))
(defun QP-cleanup-1 (master) (declare (ignore master)))
(defun QP-reset-cleanup (master qp-ptr) (declare (ignore master qp-ptr)))
(libdecl .QP-initialize-DRAM 'QP-initialize-DRAM-load '() nil)
(defun qp-initialize-dram-load () (emit '(.qp-initialize-dram)))
(defun qp-instrument-monitor-load (output)  (declare (ignore output)) (emit '(.QP-DRAM-merge)))
(defun QP-no-one-can-use-current-frame (master) (declare (ignore master)))
(defun QP-get-least-beg (master) (declare (ignore master)))
(defun QP-refresh-off () )
(defun QP-refresh-on () )
(defun QP-write-DRAM (a b) (declare (ignore a b)))
(defun QP-read-DRAM (a b) (declare (ignore a b)))

(defun QP-size-location () )
(defun QP-size-code (dsp) (declare (ignore dsp)) )

