;;; -*- syntax: common-lisp; package: clm; base: 10; mode: lisp -*-
;;;

(in-package :clm)

(defconstant SERVICE-BREAK 0)		;this list of index numbers must match that in next56.c
(defconstant READ-INPUT 1)
(defconstant LOCSIZ-SERVICE-BREAK 2)
(defconstant AWAIT-GET-SERVICE-BREAK 3)
(defconstant AWAIT-PUT-SERVICE-BREAK 4)	;5 removed 16-Feb-94
(defconstant AWAIT-OUTPUT-SERVICE-BREAK 6)
(defconstant FATAL-WRITE-ERROR 7)

#+Excl (progn

  #+QP (progn
      (ff:defforeign 'qp-check-all-slots   :entry-point "_QP_check_all_slots"   :arguments '(array)      :return-type :integer)
      (ff:defforeign 'qp-all-done          :entry-point "_QP_all_done"          :arguments nil           :return-type :void)
      (ff:defforeign 'qp-boot-dsp          :entry-point "_QP_boot_dsp"          
		     :arguments '(fixnum fixnum fixnum array fixnum fixnum) :return-type :integer)
      (ff:defforeign 'qp-set-current-dsp   :entry-point "_QP_set_current_dsp" 
		     :arg-checking nil :arguments '(fixnum fixnum) :return-type :integer)
      (ff:defforeign 'qp-is-open           :entry-point "_QP_is_open" :arg-checking nil :arguments nil   :return-type :integer)
      (ff:defforeign 'qp-hi-1              :entry-point "_QP_report_hi"         :arguments '(array)      :return-type :void)
      (ff:defforeign 'qp-get-interrupt     :entry-point "_QP_get_interrupt"     :arguments nil           :return-type :integer)
      (ff:defforeign 'qp-clear-interrupt   :entry-point "_QP_clear_interrupt"   :arguments nil           :return-type :void)
      )

  (ff:defforeign 'dsp-is-open       :entry-point "_dspisopen"     :arg-checking nil :arguments nil     :return-type :integer)
  (ff:defforeign 'dsp-read-icr      :entry-point "_get_ICR"       :arguments nil     :return-type :integer)
  (ff:defforeign 'dsp-read-isr      :entry-point "_get_ISR"       :arguments nil     :return-type :integer)
  (ff:defforeign 'dsp-read-cvr      :entry-point "_get_CVR"       :arguments nil     :return-type :integer)
  (ff:defforeign 'dsp-write-icr     :entry-point "_put_ICR"       :arguments '(fixnum) :return-type :void)
  (ff:defforeign 'dsp-write-cvr     :entry-point "_put_CVR"       :arguments '(fixnum) :return-type :void)
  (ff:defforeign 'dsp-HF2           :entry-point "_HF2"           :arguments nil     :return-type :integer)
  (ff:defforeign 'dsp-HF3           :entry-point "_HF3"           :arguments nil     :return-type :integer)
  (ff:defforeign 'c-array-transfer  :entry-point "_arrtran"       
		 :arguments '(fixnum fixnum array fixnum array) :return-type :void) ;used only in set-initial-contents
  (ff:defforeign 'c-read-dsp-block  :entry-point "_basicdspread"  
		 :arguments '(fixnum fixnum fixnum fixnum fixnum array array array array array array) :return-type :void)
  (ff:defforeign 'dsp-send-input    :entry-point "_dspsendinput"  
		 :arguments '(array fixnum array array array array fixnum) :return-type :void)
  (ff:defforeign 'c-insig           :entry-point "_inn" :arguments '(fixnum fixnum fixnum fixnum fixnum) :return-type :void)
  (ff:defforeign 'c-load-fractional-array :entry-point "_cloadfarr" :arguments '(array fixnum fixnum array) :return-type :void)
  (ff:defforeign 'dsp-put-one-word  :entry-point "_dspputoneword" :arguments '(fixnum) :return-type :integer)
  (ff:defforeign 'dsp-get-one-word  :entry-point "_dspgetoneword" :arguments nil       :return-type :integer)
  (ff:defforeign 'lsp-put-one-word  :entry-point "_dspputoneword" :arguments '(fixnum) :return-type :integer)
  (ff:defforeign 'lsp-get-one-word  :entry-point "_dspgetoneword" :arguments nil       :return-type :integer)
  (ff:defforeign 'dsp-put-array     :entry-point "_dspputarray"   :arguments '(fixnum fixnum array) :return-type :integer)
  (ff:defforeign 'dsp-get-array     :entry-point "_dspgetarray"   :arguments '(fixnum fixnum array) :return-type :integer)
  (ff:defforeign 'dsp-merge-one-buffer :entry-point "_outonebuf"  :arguments '(fixnum fixnum fixnum) :return-type :integer)
  (ff:defforeign 'dsp-set-up-program :entry-point "_dspsetupprogram" 
		 :arguments '(fixnum fixnum fixnum fixnum fixnum fixnum fixnum fixnum array array array) :return-type :integer)
  (ff:defforeign 'dsp-start-again   :entry-point "_dspstartagain" :arguments '(fixnum fixnum) :return-type :integer)
  (ff:defforeign 'dsp-data-ready    :entry-point "_dspdataready"  :arg-checking nil :arguments nil       :return-type :integer)
  (ff:defforeign 'dsp-check-host-interface :entry-point "_checkhostInterface" :arguments nil :return-type :integer) 
  (ff:defforeign 'dsp-get-host-interface :entry-point "_hival"    
		 :arguments nil       :return-type :integer) ;(ash this -3 to get c value)
  (ff:defforeign 'dsp-set-up        :entry-point "_cpu_boot"      :arguments '(fixnum array) :return-type :integer)
  (ff:defforeign 'clear-host-interfaces :entry-point "_clear_host_interfaces" :arguments nil :return-type :void)
  (ff:defforeign 'dsp-2-close       :entry-point "_cpu_close"     :arguments nil       :return-type :integer)
  (ff:defforeign 'set-current-active-dsp :entry-point "_set_active_dsp" :arguments '(fixnum) :return-type :void)
  (ff:defforeign 'get-current-active-dsp :entry-point "_get_active_dsp" :arguments nil :return-type :integer)
  (ff:defforeign 'get-wait-time     :entry-point "_get_wait_time" :arguments nil :return-type :integer)
  (ff:defforeign 'set-wait-time     :entry-point "_set_wait_time" :arguments '(fixnum)  :return-type :integer)
  (ff:defforeign 'get-dsp-error     :entry-point "_get_clm_dsp_error" :arguments nil :return-type :integer)
  )

(defconstant %external-input 0)
(defconstant %external-envelope 1)
(defconstant %external-break 2)
(defconstant %external-warn 3)
(defconstant %external-error 4)
(defconstant %external-print 5)
(defconstant %external-y-or-n-p 6)
(defconstant %external-yes-or-no-p 7)
(defconstant %external-terpri 8)
(defconstant %external-funcall 9)
(defconstant %external-apply 10)
(defconstant %external-output 11)
(defconstant %external-zdelay 12)
(defconstant %external-locsig 13)
(defconstant %external-overflow-warning 14)
(defconstant %external-array-index-warning 15)
(defconstant %external-nil-UG-warning 16)
(defconstant %external-ztap 17)
(defconstant %external-variable-print 18)
(defconstant %external-princ 19)
(defconstant %external-variable-princ 20)
(defconstant %external-unrestartable-envelope-error 21)
(defconstant %external-clm-print 22)

(defconstant %external-integer 0)
(defconstant %external-long-integer 1)
(defconstant %external-real 2)
(defconstant %external-fraction 3)
(defconstant %external-boolean 4)

(defvar in-dsp-break nil)
(defun clservicebreak (&optional (loc nil))
  (if in-dsp-break (error "recursive dsp error"))
  (unwind-protect
      (progn
	(setf in-dsp-break t)
	(if loc (print (format nil "hit a break-point in ~A" loc))
	  (print "hit a break point (unknown caller)"))
	(dsp-service-break))		;lib56.lisp
    (setf in-dsp-break nil)))

#+Excl (progn
  (ff:defun-c-callable servicebreak () (clservicebreak "checkHF3"))
  (ff:register-function 'servicebreak SERVICE-BREAK)

  (ff:defun-c-callable awaitgetservicebreak () 
		       (clservicebreak (format nil "dsp-get-one-word (wait timed out~A)"
					       (if (and (zerop (dsp-hf3)) (plusp (dsp-hf2)))
						   " -- probably hung awaiting input from a closed file" ""))))
  (ff:register-function 'awaitgetservicebreak AWAIT-GET-SERVICE-BREAK)
  
  (ff:defun-c-callable awaitputservicebreak () (clservicebreak "dsp-put-one-word (wait timed out)"))
  (ff:register-function 'awaitputservicebreak AWAIT-PUT-SERVICE-BREAK)
  
  (ff:defun-c-callable locsizservicebreak () (clservicebreak "c-read-dsp-block (sigsiz too big)"))
  (ff:register-function 'locsizservicebreak LOCSIZ-SERVICE-BREAK)

  (ff:defun-c-callable outputservicebreak () (clservicebreak "c-read-dsp-block (hung output)"))
  (ff:register-function 'outputservicebreak AWAIT-OUTPUT-SERVICE-BREAK)

  (ff:defun-c-callable clloadinput () (external-dispatch (lsp-get-one-word)))
  (ff:register-function 'clloadinput READ-INPUT)

  (ff:defun-c-callable cwriteerror () (error "fatal write error"))
  (ff:register-function 'cwriteerror FATAL-WRITE-ERROR)
  ;; this function only in Excl/Next version

  ;; kcl version is in kcl-c56.lisp
  ;; mac version is in macintosh56.lisp
  )

#+kcl (defun call_lisp_and_hope_for_best (index)
	(if (= index SERVICE-BREAK) (clservicebreak "checkHF3")
	  (if (= index READ-INPUT) (external-dispatch (lsp-get-one-word))
	    (if (= index LOCSIZ-SERVICE-BREAK) (clservicebreak "c-read-dsp-block (sigsiz too big)")
	      (if (= index AWAIT-GET-SERVICE-BREAK) (clservicebreak (format nil "dsp-get-one-word (wait timed out~A)"
									    (if (and (zerop (dsp-hf3)) (plusp (dsp-hf2)))
										" -- probably hung awaiting input from a closed file" "")))
		(if (= index AWAIT-PUT-SERVICE-BREAK) (clservicebreak "dsp-put-one-word (wait timed out)")
		  (if (= index AWAIT-OUTPUT-SERVICE-BREAK) (clservicebreak "c-read-dsp-block (hung output)")
		    (if (= index FATAL-WRITE-ERROR) (error "fatal write error")))))))))



(defun external-dispatch (op)
  (cond ((= op %external-input) (handle-external-input))
	((= op %external-envelope) (handle-external-envelope))
	((= op %external-output) (handle-external-output))
	((= op %external-zdelay) (handle-external-zdelay))
	((= op %external-locsig) (handle-external-locsig))
	((= op %external-funcall) (handle-external-funcall))
	((= op %external-break) (handle-external-break))
	((= op %external-warn) (handle-external-warn))
	((= op %external-error) (handle-external-error))
	((= op %external-print) (handle-external-print))
	((= op %external-y-or-n-p) (handle-external-y-or-n-p))
	((= op %external-yes-or-no-p) (handle-external-yes-or-no-p))
	((= op %external-terpri) (handle-external-terpri))
	((= op %external-apply) (handle-external-apply))
	((= op %external-overflow-warning) (handle-external-overflow-warning))
	((= op %external-array-index-warning) (handle-external-array-index-warning))
	((= op %external-nil-UG-warning) (handle-external-nil-UG-warning))
	((= op %external-ztap) (handle-external-ztap))
	((= op %external-variable-print) (handle-external-variable-print))
	((= op %external-princ) (handle-external-princ))
	((= op %external-clm-print) (handle-external-clm-print))
	((= op %external-variable-princ) (handle-external-variable-princ))
	((= op %external-unrestartable-envelope-error) (handle-external-unrestartable-envelope-error))
	(t (error "unknown external function request: ~D" op))))

(defun handle-external-input ()
  (let* ((bufsiz (lsp-get-one-word))
	 (fil-chn (lsp-get-one-word))
	 (pass-low (lsp-get-one-word))
	 (pass-high (lsp-get-one-word))
	 (pass (+ (ash pass-high 24) pass-low))
	 (file-index (logand (ash fil-chn -16) #xFF))
	 (channel (logand (ash fil-chn -8) #xFF))
	 (fil (aref *clm-current-open-files* file-index)))
    (if (null fil) (error "invalid file index: ~A" file-index))
    (if (or (and (mono fil) (not (zerop channel))) 
	    (and (stereo fil) (> channel 1))
	    (< channel 0)
	    (> channel 3))
	(error "invalid channel: ~A" channel))
    (clm-input-check pass fil bufsiz)
    (c-insig (IO-beg fil) 
	     bufsiz 
	     (- pass (IO-beg fil)) 
	     (cond ((= channel 0) (IO-dat-A fil))
		   ((= channel 1) (IO-dat-B fil))
		   ((= channel 2) (IO-dat-C fil))
		   ((= channel 3) (IO-dat-D fil)))
	     (IO-siz fil))))

(defun handle-external-output ()
  ;; pass in fil-chn, pass (high, low), value
  ;; then (out-sample pass datum stream buf)
  (let* ((datum (frac24 (lsp-get-one-word)))
	 (fil-chn (lsp-get-one-word))
	 (pass-low (lsp-get-one-word))
	 (pass-high (lsp-get-one-word))
	 (pass (+ (ash pass-high 24) pass-low))
	 (file-index (logand (ash fil-chn -16) #xFF))
	 (channel (logand (ash fil-chn -8) #xFF))
	 (fil (aref *clm-current-open-files* file-index)))
    (if (null fil) (error "invalid file index: ~A" file-index))
    (if (or (and (mono fil) (not (zerop channel))) 
	    (and (stereo fil) (> channel 1))
	    (< channel 0)
	    (> channel 3))
	(error "invalid channel: ~A" channel))
    (out-sample pass datum fil (cond ((= channel 0) (IO-dat-A fil))
				     ((= channel 1) (IO-dat-B fil))
				     ((= channel 2) (IO-dat-C fil))
				     ((= channel 3) (IO-dat-D fil))))))
				     
(defvar *clm-locsigs* nil)
(defvar *clm-locsig-dsps* nil)
(defvar *clm-max-locsig* -1)
(defvar *clm-max-locsigs* 16)

(defun get-locsig-from-id (id)
  (if *clm-locsigs*
      (or (aref *clm-locsigs* id)
	  (error "lost locsig ~D" id))
    (error "no locsigs?")))

(defun remember-locsig (loc)
  (when (null *clm-locsigs*)
    (setf *clm-locsigs* (make-array *clm-max-locsigs* :initial-element nil))
    (setf *clm-locsig-dsps* (make-array *clm-max-locsigs* :initial-element nil)))
  (let ((ind (find-open-slot *clm-locsigs*)))
    (setf (aref *clm-locsigs* ind) loc)
    (setf *clm-max-locsig* (max *clm-max-locsig* ind))
    (setf (aref *clm-locsig-dsps* ind) (active-dsp))
    ind))

(defun forget-locsig (ldp)
  (when *clm-locsigs*
    (let ((new-top -1))
      (loop for i from 0 to *clm-max-locsig* do
	(if (eq ldp (aref *clm-locsig-dsps* i))
	    (progn
	      (setf (aref *clm-locsig-dsps* i) nil)
	      (setf (aref *clm-locsigs* i) nil))
	  (if (aref *clm-locsigs* i) (setf new-top i))))
      (setf *clm-max-locsig* new-top))))

(defun handle-external-locsig ()
  ;; pass in loc id, pass, datum
  (let* ((datum (frac24 (lsp-get-one-word)))
	 (locid (get-locsig-from-id (lsp-get-one-word)))
	 (pass-low (lsp-get-one-word))
	 (pass-high (lsp-get-one-word))
	 (pass (+ (ash pass-high 24) pass-low)))
    (locsig locid pass datum)))

(defun get-zdelay-from-id (id)
  (if *clm-zdelay-lines*
      (or (aref *clm-zdelay-lines* id)
	  (error "lost zdelay ~D" id))
    (error "no zdelays?")))
	  
(defun handle-external-zdelay ()
  ;; get id, current phase, return interpolated value, add in next input
  (let* ((z (get-zdelay-from-id (lsp-get-one-word)))
	 (input (frac24 (lsp-get-one-word)))
	 (pm-int (lsp-get-one-word))
	 (pm-frac (lsp-get-one-word))
	 (pm (real56 0 pm-int pm-frac))
	 (outval (zdelay z input pm)))
    (lsp-put-one-word (logand (floor (scale-float outval 23)) #xFFFFFF))))

(defun handle-external-ztap ()
  ;; get id, current phase, return interpolated value
  (let* ((z (get-zdelay-from-id (lsp-get-one-word)))
	 (pm-int (lsp-get-one-word))
	 (pm-frac (lsp-get-one-word))
	 (pm (real56 0 pm-int pm-frac))
	 (outval (ztap z pm)))
    (lsp-put-one-word (logand (floor (scale-float outval 23)) #xFFFFFF))))


(defvar external-envelopes nil)
;;; an array of data lists

(defun handle-external-envelope ()
  ;; here (abs bufsiz) is the index into the external-envelopes array
  ;; the next datum to get is how many new segments (2 48-bit words) to pass down
  ;; we start with how many segments we'll actually pass (might be less),
  ;;   then -1 if this is the end of env data, else 0
  ;;   then the segments (counter rate)
  (let* ((bufsiz24 (lsp-get-one-word))
	 (bufsiz (- bufsiz24 (expt 2 24)))
	 ;; i.e. we get back an uninterpreted 24 bit number, and have to coerce it to a (signed) 32 bit fixnum
	 (ind (1- (abs bufsiz)))
	 (segs (lsp-get-one-word)))
    (if (or (not external-envelopes)
	    (not (array-in-bounds-p external-envelopes ind))
	    (not (aref external-envelopes ind)))
	(error "bogus external envelope index received from dsp: ~D (and segs: ~D)" ind segs)
      (let* ((extenvlst (aref external-envelopes ind))
	     (end (first extenvlst))
	     (base (second extenvlst))
	     (extenv (third extenvlst))
	     (extenvlen (ceiling (length extenv) 2))
	     (tsegs (min segs extenvlen))
	     (tend (= tsegs extenvlen)))
	(lsp-put-one-word (if tend #xFFFFFF tsegs))
	(lsp-put-one-word tsegs)
	(lsp-put-one-word base)
	(loop for i from 1 to tsegs do
	  (let* ((rate (or (pop extenv) 0.0))
		 (pctr (or (pop extenv) (1+ end)))
		 (ipctr (floor pctr)))
	    (multiple-value-bind
		(pass-rate-int pass-rate-frac)
		(make-real (float rate))
	      (lsp-put-one-word (ash ipctr -24))         ;X mem
	      (lsp-put-one-word (logand ipctr #xFFFFFF)) ;Y mem
	      (lsp-put-one-word pass-rate-int)           ;X
	      (lsp-put-one-word pass-rate-frac))))       ;Y
	(setf (aref external-envelopes ind) (if extenv
						(list end base extenv)
					      nil))))))

;;; handle-external break|warning|error|print

(defun handle-external-break ()
  ;; args coming in (expanded in-line in code56) are:
  ;; string length
  ;; string chars packed 3 to a word
  ;; number of args
  ;; each arg (type then value?)
  ;; then chip jsr's to .break, so we should change to c56 package somehow and drop into debugger
  (let* ((str (read-dsp-string))
	 (argn (lsp-get-one-word))
	 (args (loop for i from 0 below argn collect (read-dsp-arg))))
    #+Excl (top-level:Do-command "pa" "C56")
    (print (format nil "Dropping into DSP breakpoint handler -- (dsp-go) and :continue 0 to try to continue.~%"))
    (if (null str)
	(break)
      (apply #'break str args))))

(defun handle-external-print ()
  (print (read-dsp-string))
  (force-output))

(defun handle-external-variable-print ()
  (read-dsp-string)			;fstr assumed nil
  (lsp-get-one-word)			;argn assumed 1
  (print (read-dsp-arg))
  (force-output))

(defun handle-external-princ ()
  (princ (read-dsp-string))
  (force-output))

(defun handle-external-variable-princ ()
  (read-dsp-string)			;fstr assumed nil
  (lsp-get-one-word)			;argn assumed 1
  (princ (read-dsp-arg))
  (force-output))

(defun handle-external-error ()
  (let* ((str (read-dsp-string))
	 (argn (lsp-get-one-word))
	 (args (loop for i from 0 below argn collect (read-dsp-arg))))
    (c56-reset-cleanup)
    (apply #'error str args)))

(defun handle-external-warn ()
  (let* ((str (read-dsp-string))
	 (argn (lsp-get-one-word))
	 (args (loop for i from 0 below argn collect (read-dsp-arg))))
    (apply #'warn str args)
    (force-output)))

(defun handle-external-clm-print ()
  (let* ((str (read-dsp-string))
	 (argn (lsp-get-one-word))
	 (args (loop for i from 0 below argn collect (read-dsp-arg))))
    (princ (apply #'format nil str args))
    (force-output)))

(defun handle-external-overflow-warning ()
  (let* ((op (lsp-get-one-word))
	 (arg-frac (lsp-get-one-word))
	 (arg-int (lsp-get-one-word))
	 (arg (real56 0 arg-int arg-frac)))
    (warn "fractional overflow: ~A is ~1,4F" (decode-overflow-op op) arg)
    (force-output)))

(defun handle-external-unrestartable-envelope-error ()
  (error "attempt to restart unrestartable envelope"))

(defun handle-external-array-index-warning ()
  (let* ((index (lsp-get-one-word))
	 (limit (lsp-get-one-word))
	 (true-index (lsp-get-one-word))
	 (el-size (lsp-get-one-word)))
    (warn "array index is too high: ~D > ~D." true-index (floor (- limit (- index true-index)) el-size))
    (force-output)))

(defun decode-overflow-op (op)
  (cond ((= op 1) "delay input")
	((= op 2) "am input1")
	((= op 3) "am input2")
	((= op 4) "am carrier")
	((= op 5) "polynomial x")
	((= op 6) "one-pole input")
	((= op 7) "one-zero input")
	((= op 8) "two-pole input")
	((= op 9) "two-zero input")
	((= op 10) "filter input")
	((= op 11) "zdelay input")
	((= op 12) "comb or all-pass input")
	((= op 13) "outn input")
	((= op 14) "locsig input")
	((= op 15) "real to fraction conversion within an expression; orignal value")
	(t "un-named entity")))

(defun handle-external-y-or-n-p ()
  (let* ((str (read-dsp-string))
	 (argn (lsp-get-one-word))
	 (args (loop for i from 0 below argn collect (read-dsp-arg)))
	 (res (apply #'y-or-n-p str args)))
    (lsp-put-one-word (if res <t> <nil>))
    (lsp-put-one-word 0)))

(defun handle-external-yes-or-no-p ()
  (let* ((str (read-dsp-string))
	 (argn (lsp-get-one-word))
	 (args (loop for i from 0 below argn collect (read-dsp-arg)))
	 (res (apply #'yes-or-no-p str args)))
    (lsp-put-one-word (if res <t> <nil>))
    (lsp-put-one-word 0)))

(defun handle-external-terpri ()
  (terpri))

;;; for funcall and apply, dsp-read-string the function name, get the args,
;;; need to turn string function name into #'name for apply or funcall
;;; (how useful is apply if we don't have lists on chip?)

(defun handle-external-funcall ()
  (let* ((fun (read-dsp-string))
	 (argn (lsp-get-one-word))
	 (args (loop for i from 0 below argn collect (read-dsp-arg)))
	 (res (or (apply (read-from-string fun) args) 0.0)))
    (multiple-value-bind 
	(int frac)
	(make-real res)
      (lsp-put-one-word int)
      (lsp-put-one-word frac))))
;; is this kosher???

(defun handle-external-apply ()
  (handle-external-funcall))

(defun handle-external-nil-UG-warning ()
  (let* ((addr (lsp-get-one-word))
	 (hashed-vars (get *current-instrument-name* :ins-vars)))
    (if (not hashed-vars) 
	(warn "clm wanted to complain that you are trying to run an uninitialized generator, but ~
               now it seems to have misplaced the current instrument's name, and is completely at sea.")
      (let ((ug-name nil))
	(maphash #'(lambda (a b) 
		     (if (or (= (second (first b)) addr) 
			     (= (second (first b)) (1- addr)))
			 (setf ug-name a))) 
		 hashed-vars)
	(if (not ug-name) 
	    (warn "clm was going to complain that ~A is trying to run an uninitialized generator, but ~
                   the offending address, ~D, doesn't seem to belong to anyone." *current-instrument-name* addr)
	  (warn "attempt to run an uninitialized unit-generator named ~A in ~A" ug-name *current-instrument-name*))))))

(defun read-dsp-string ()
  (if (> char-code-limit 256) 
      (warn "This lisp's char-code-limit is ~D, but we assume on chip that it is < 256." char-code-limit))
  (let* ((strlen (lsp-get-one-word)))
    (if (zerop strlen)
	""
      (let* ((str (make-string strlen))
	     (k -1))
	(loop for i from 0 below strlen by 3 do
	  (let* ((word (lsp-get-one-word))
		 (hb (logand (ash word -16) #xFF))
		 (mb (logand (ash word -8) #xFF))
		 (lb (logand word #xFF)))
	    (setf (elt str (incf k)) (code-char hb))
	    (when (< k (1- strlen)) 
	      (setf (elt str (incf k)) (code-char mb))
	      (when (< k (1- strlen))
		(setf (elt str (incf k)) (code-char lb))))))
	str))))

(defun make-dsp-string (str)
  (let* ((strlen (length str))
	 (k -1))
    (loop for i from 0 below strlen by 3 
      collect (logior (ash (char-code (elt str (incf k))) 16)
		      (if (< k (1- strlen)) (ash (char-code (elt str (incf k))) 8) 0)
		      (if (< k (1- strlen)) (char-code (elt str (incf k))) 0)))))

(defun read-dsp-arg ()
  ;; just numerical args currently
  (let* ((op (lsp-get-one-word))
	 (i (lsp-get-one-word)))
    (cond ((= op %external-integer)
	   (if (>= i (expt 2 23)) (- i (expt 2 24)) i))
	  ((= op %external-fraction) 
	   (scale-float (float (if (>= i (expt 2 23)) (- i (expt 2 24)) i)) -23))
	  ((= op %external-long-integer)
	   (+ (ash i 24) (lsp-get-one-word)))
	  ((= op %external-real)
	   (float (+ (if (>= i (expt 2 23)) (- i (expt 2 24)) i)
		     (/ (lsp-get-one-word) (expt 2 24)))))
	  ((= op %external-boolean)
	   (= i <t>))
	  (t (error "unknown dsp type: ~D" op)))))


(defun dsp-1-close ()
  (let ((err (dsp-2-close)))
    (if (= err -2)
	(error "dsp-close with null host interface")
      (if (= err -3)
	  (error "dsp-close on closed dsp")
	(if (= err -4)
	    (error "dsp-close on wrong interface pointer"))))
    err))


