/* DAC routines and so on for the Next (system 2.0 and later) */
/* compiled via cc next.c -c -O */

#include <sound/sound.h>
#include <sound/sounddriver.h>
#include <mach/mach.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>

static SNDSoundStruct *snp = NULL;

int SNDFree1(SNDSoundStruct *s)
{
  SNDFree(s);
  snp = NULL;
}

int startdac(char *argv, int igerr, float start, float end)
{
    int err,offset,oldsize,oldloc,len;
    float size;
    err = SNDReadSoundfile(argv,&snp);
    len = 0;
    oldsize = snp->dataSize;
    oldloc = snp->dataLocation;
    offset = ((snp->channelCount) * 2 * (snp->samplingRate) * start);
    if (offset != 0)
      {
	snp->dataLocation += offset;
	snp->dataSize -= offset;
      }
    /* one would naively think that it should be possible to edit the SNDSoundStruct */
    /* fields here to change the start/end times, srate and so on, but changed srate */
    /* is ignored, changed size hangs, changed location works, I think (clicks?),    */
    /* and, of course, we can't play non-NeXT sound files.                           */

    if ((err == 0) || (igerr != 0))
      {
	err = SNDStartPlaying(snp,1,5,0,0,(SNDNotificationFun)SNDFree1);
      }
    return err;
}

abortdac(void)
{
  SNDStop(1);
  if (snp != NULL) SNDFree(snp);
  snp = NULL;
}

int dacisrunning(void)
{
  if (snp != NULL) return 1;
  return 0;
}

waitfordac(void)
{
  SNDWait(0);  /* i.e. wait for all, but there's only one... */
}


int sethost(char *host)
{
  /* I'm not even sure what this does, but it's in the manual so what the heck. */
  int i;
  i = SNDSetHost(host);
  return i;
}


/* 
   There is apparently a low pass filter on the DAC --
   new documentation calls it a pre-emphasis filter.
*/

int getdacfilter (void)
{
  int err;
  port_t dev_port = 0, owner_port = 0;
  boolean_t lowpass,speaker,zerofill;
  err = SNDAcquire(SND_ACCESS_DSP, 0, 0, 0, NULL_NEGOTIATION_FUN, 0, &dev_port, &owner_port);
  if (err == 0)
    err = snddriver_get_device_parms(dev_port,&speaker,&lowpass,&zerofill);
  if (err == 0) err = lowpass;
  SNDRelease(SND_ACCESS_DSP,dev_port,owner_port);    /* SNDAcquire holds onto the dsp until we release it explicitly */
  /* see /NextLibrary/Documentation/NextDev/SndMusicDSP/Reference/03_CFunctions/SoundFunctions.rtf */
  /* in 3.0 this appears to be /NextLibrary/Documentation/NextDev/GeneralRef/16_Sound/SoundFunctions/SoundFunctions.rtf */
  return err;
}

int setdacfilter (int state)
{
  int err;
  port_t dev_port = 0, owner_port = 0;
  boolean_t lowpass,speaker,zerofill;
  err = SNDAcquire(SND_ACCESS_DSP, 0, 0, 0, NULL_NEGOTIATION_FUN, 0, &dev_port, &owner_port);
  if (err == 0)
    {
      err = snddriver_get_device_parms(dev_port,&speaker,&lowpass,&zerofill);
      lowpass=state;
      if (err == 0) 
	err = snddriver_set_device_parms(dev_port,speaker,lowpass,zerofill);
    }
  SNDRelease(SND_ACCESS_DSP,dev_port,owner_port);
  return err;
}
/* my tests indicate it's a pretty weak filter */
    

int getvolume (int *arr)
{
  int err;
  port_t dev_port = 0, owner_port = 0;
  boolean_t lowpass,speaker,zerofill;
  err = SNDAcquire(SND_ACCESS_DSP, 0, 0, 0, NULL_NEGOTIATION_FUN, 0, &dev_port, &owner_port);
  if (err == 0)
    err = snddriver_get_device_parms(dev_port,&speaker,&lowpass,&zerofill);
  if (err == 0) 
    {
      arr[0] = speaker;
      err = snddriver_get_volume(dev_port,&arr[1],&arr[2]);
    }
  SNDRelease(SND_ACCESS_DSP,dev_port,owner_port);
  return err;
}

int setvolume (int *arr)
{
  int err;
  port_t dev_port = 0, owner_port = 0;
  boolean_t lowpass,speaker,zerofill;
  err = SNDAcquire(SND_ACCESS_DSP, 0, 0, 0, NULL_NEGOTIATION_FUN, 0, &dev_port, &owner_port);
  if (err == 0)
    {
      err = snddriver_get_device_parms(dev_port,&speaker,&lowpass,&zerofill);
      speaker = arr[0];
      if (err == 0)
	err = snddriver_set_device_parms(dev_port,speaker,lowpass,zerofill);
      if (err == 0)
	err = snddriver_set_volume(dev_port,arr[1],arr[2]);
    }
  SNDRelease(SND_ACCESS_DSP,dev_port,owner_port);
  return err;
}
    
int setramp (int rmp)         /* see NextLibrary/Documentation/NextDev/SNDMusicDSP/Reference/03_CFunctions/DriverFunctions.rtf */
{
  int err;
  port_t dev_port = 0, owner_port = 0;
  boolean_t lowpass,speaker,zerofill;
  err = SNDAcquire(SND_ACCESS_DSP, 0, 0, 0, NULL_NEGOTIATION_FUN, 0, &dev_port, &owner_port);
  if (err == 0)
    err = snddriver_set_ramp(dev_port,rmp);
  SNDRelease(SND_ACCESS_DSP,dev_port,owner_port);
  return err;
}


int getdaczerofill (void)
{
  int err;
  port_t dev_port = 0, owner_port = 0;
  boolean_t lowpass,speaker,zerofill;
  err = SNDAcquire(SND_ACCESS_DSP, 0, 0, 0, NULL_NEGOTIATION_FUN, 0, &dev_port, &owner_port);
  if (err == 0)
    err = snddriver_get_device_parms(dev_port,&speaker,&lowpass,&zerofill);
  if (err == 0) err = zerofill;
  SNDRelease(SND_ACCESS_DSP,dev_port,owner_port);    /* SNDAcquire holds onto the dsp until we release it explicitly */
  /* see /NextLibrary/Documentation/NextDev/SndMusicDSP/Reference/03_CFunctions/SoundFunctions.rtf */
  return err;
}

int setdaczerofill (int state)
{
  int err;
  port_t dev_port = 0, owner_port = 0;
  boolean_t lowpass,speaker,zerofill;
  err = SNDAcquire(SND_ACCESS_DSP, 0, 0, 0, NULL_NEGOTIATION_FUN, 0, &dev_port, &owner_port);
  if (err == 0)
    {
      err = snddriver_get_device_parms(dev_port,&speaker,&lowpass,&zerofill);
      zerofill=state;
      if (err == 0) 
	err = snddriver_set_device_parms(dev_port,speaker,lowpass,zerofill);
    }
  SNDRelease(SND_ACCESS_DSP,dev_port,owner_port);
  return err;
}
