;;; -*- Lisp -*-

(compile-file "v.ins") (load "v")
(compile-file "addflt.ins") (load "addflt")
(compile-file "resflt.ins") (load "resflt")
(compile-file "drone.ins") (load "drone")
(compile-file "canter.ins") (load "canter")
(compile-file "reson.ins") (load "reson")
(compile-file "insect.ins") (load "insect")
(compile-file "nrev.ins") (load "nrev")
(compile-file "jcrev.ins") (load "jcrev")
(compile-file "pqw.ins") (load "pqw")
(compile-file "trp.ins") (load "trp")
(compile-file "noise.ins") (load "noise")
(compile-file "add.ins") (load "add")
(compile-file "bigbird.ins") (load "bigbird")
(compile-file "kiprev.ins") (load "kiprev")
(compile-file "pluck.ins") (load "pluck")
(compile-file "cellon.ins") (load "cellon")
(compile-file "vox.ins") (load "vox")
(compile-file "jcvoi.ins") (load "jcvoi")
(compile-file "mlbvoi.ins") (load "mlbvoi")
(compile-file "pqwvox.ins") (load "pqwvox")
(compile-file "addsnd.ins") 
(compile-file "revsnd.ins")
#|
(compile-file "cut.ins") (load "cut")
(compile-file "btest.ins") (load "btest")
(compile-file "dloc.ins") (load "dloc")
(compile-file "tc.ins") (load "tc")
|#

(with-sound (:wait t) (fm-violin 0 1 440 .1))	;FM-VIOLIN
(with-sound (:reverb jc-reverb :wait t) 
	    (fm-violin 0 .1 440 .1))	;JC-REVERB
(with-sound (:reverb nrev :wait t) 
	    (fm-violin 0 .1 440 .1))	;NREV
(with-sound (:reverb kiprev :wait t) 
	    (fm-violin 0 .1 440 .1))	;KIPREV
(with-sound (:wait t) (scissor 0) (scissor 1))	;BIGBIRD
(with-sound (:wait t)				;FM-NOISE
	    (fm-noise 0 2.0 500 .25 '(0 0 25 1 75 1 100 0) .1 .1 1000 
		      '(0 0 100 1) .1 .1 10 1000 '(0 0 100 1) 0 0 100 500 '(0 0 100 1) 0 0))


(defvar locust '(0 0 40 1 95 1 100 .5))	;FM-INSECT
(defvar Bug_hi '(0 1 25 .7 75 .78 100 1))
(defvar amp    '(0 0 25 1 75 .7 100 0))
(with-sound (:wait t)	
	    (FM-Insect 0      1.699  4142.627  .015 amp 60 -16.707 locust 500.866 bug_hi  .346  .500)
	    (FM-Insect 0.195   .233  4126.284  .030 amp 60 -12.142 locust 649.490 bug_hi  .407  .500)
	    (FM-Insect 0.217  2.057  3930.258  .045 amp 60 -3.011  locust 562.087 bug_hi  .591  .500)
	    (FM-Insect 2.100  1.500   900.627  .06  amp 40 -16.707 locust 300.866 bug_hi  .346  .500)
	    (FM-Insect 3.000  1.500   900.627  .06  amp 40 -16.707 locust 300.866 bug_hi  .046  .500)
	    (FM-Insect 3.450  1.500   900.627  .09  amp 40 -16.707 locust 300.866 bug_hi  .006  .500)
	    (FM-Insect 3.950  1.500   900.627  .12  amp 40 -10.707 locust 300.866 bug_hi  .346  .500)
	    (FM-Insect 4.300  1.500   900.627  .09  amp 40 -20.707 locust 300.866 bug_hi  .246  .500))


(with-sound (:wait t)				;ADDFLTS
	    (addflts 0 1.0 2 2 '(0 0 100 1) 100 120 '(0 0 50 1 100 0) .25 30 0 0 1.0 0.01
		     '((0 0 100 1) (0 0 100 1) 1200 2400 .9 .995 .005)
		     '((0 0 100 1) (0 0 100 1) 600 1200 .95 .995 .01)))

					;CANTER and DRONE
(defvar fmt1 '(0 1200 100 1000))
(defvar fmt2 '(0 2250 100 1800))
(defvar fmt3 '(0 4500 100 4500))
(defvar fmt4 '(0 6750 100 8100))
(defvar amp1 '(0 .67 100 .7))
(defvar amp2 '(0 .95 100 .95))
(defvar amp3 '(0 .28 100 .33))
(defvar amp4 '(0 .14 100 .15))
(defvar ind1 '(0 .75 100 .65))
(defvar ind2 '(0 .75 100 .75))
(defvar ind3 '(0 1 100 1))
(defvar ind4 '(0 1 100 1))
(defvar skwf '(0 0 100 0))
(defvar ampf '(0 0 25 1 75 1 100 0))
(defvar ranf '(0 .5 100 .5))
(defvar index '(0 1 100 1))
(defvar zero_fun '(0 0 100 0))

(defvar atskew '(0 -1 15 .3 22 -.1 25 0 75 0 100 -.2))
(defvar vibfun '(0 0 .3 .3 15 .6 25 1 100 1))
(defvar slopefun '(0 1 75 1 100 0))
(defvar trap '(0 0 25 1 75 1 100 0))
(defvar ramp '(0 0 25 0 75 1 100 1))
(defvar solid '(0 0 5 1 95 1 100 0))
(defvar sfz '(0 0 25 1 30 .6 50 .5 75 .2 100 0))
(defvar mound '(0 0 10 .4 25 .8 40 1 60 1 75 .8 90 .4 100 0))
(defvar vio '(0 0 7 .2 25 .5 40 .6 60 .6 75 .5 90 .2 100 0))
(defvar bassdr2 '(.5 .06 1 .62 1.5 .07 2.0 .6 2.5 .08 3.0 .56 4.0 .24 
		  5 .98 6 .53 7 .16 8 .33 9 .62 10 .12 12 .14 14 .86
		  16 .12 23 .14 24 .17))
(defvar bassdrstr '(.5 .06 1.0 .63 1.5 .07 2.01 .6 2.5 .08 3.02 .56
		    4.04 .24 5.05 .98 6.06 .53 7.07 .16 8.08 .33 9.09 .62
		    10.1 .12 12.12 .14 13.13 .37 14.14 .86 16.16 .12 23.23 .14 24.24 .17))
(defvar tenordr '(.3 .04 1 .81 2 .27 3 .2 4 .21 5 .18 6 .35 7 .03 8 .07 9 .02 10 .025 11 .035))
(defvar tenordrstr '(.3 .04 1.03 .81 2.03 .27 3.03 .20 4.03 .21 5.03 .18
		     6.03 .35 7.03 .03 8.03 .07 9.03 .02 10.03 .03 11.03 .04))

(with-sound (:reverb nrev :wait t)
(DRONE  .000  4.000  115.000  (* .25 .500) SOLID BASSDR2  .100  .500
	.030  45.000 1  .010 10)
(DRONE  .000  4.000  229.000  (* .25 .500) SOLID TENORDR  .100  .500
	.030  45.000 1  .010 11)
(DRONE  .000  4.000  229.500  (* .25 .500) SOLID TENORDR  .100  .500
	.030  45.000 1  .010 9)
(CANTER  .000  2.100 918  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  2.100  .300 688.5  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  2.400  .040 826.2  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  2.440  .560 459  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.000  .040 408  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.040  .040 619.65  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.080  .040 408  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.120  .040 688.5  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.160  .290 459  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.450  .150 516.375  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.600  .040 826.2  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.640  .040 573.75  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.680  .040 619.65  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.720  .180 573.75  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.900  .040 688.5  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
(CANTER  3.940  .260 459  (* .25 .700)  45.000 1  .050 AMPF RANF SKWF
	 .050  .010 10 INDEX  .005  .005 AMP1 IND1 FMT1 AMP2
	IND2 FMT2 AMP3 IND3 FMT3 AMP4 IND4 FMT4  )
)

(with-sound (:wait t)				;PQW
	    (pqw 0 .5 200 1000 .2 '(0 0 25 1 100 0) '(0 1 100 0) '(2 .1 3 .3 6 .5)))

(with-sound (:wait t)				;FM-TRUMPET
	    (fm-trumpet 0 .5))

(with-sound (:wait t)				;RESON
	    (reson 0 1.0 440 .1 2 '(0 0 100 1) '(0 0 100 1) .1 .1 .1 5 .01 5 .01 0 1.0 0.01
		   '((0 0 100 1) 1200 .5 .1 .1 0 1.0 .1 .1)
		   '((0 1 100 0) 2400 .5 .1 .1 0 1.0 .1 .1)))

(with-sound (:wait t)				;RESFLT
  (resflt 0 1.0 0 0 0 nil .1 200 230 10 '(0 0 50 1 100 0) '(0 0 100 1) 500 .995 .1 1000 .995 .1 2000 .995 .1)
  (resflt 2 1.0 1 10000 .01 '(0 0 50 1 100 0) 0 0 0 0 nil nil 500 .995 .1 1000 .995 .1 2000 .995 .1))

(with-sound (:wait t)				;COMPLETE-ADD
	    (test-add))

(with-sound (:wait t) (pluck .01 1 330 .3 .96 0 0 0))

(with-sound (:wait t) (vox 0 2 110 .4 '(0 0 25 1 75 1 100 0) '(0 0 5 .5 10 0 100 1) .1 '(0 UH 25 UH 35 ER 65 ER 75 UH 100 UH) '(.8 .15 .05) '(.005 .0125 .025)))

(with-sound (:wait t) (pqw-vox 0 2 100 414 .2 '(0 0 50 1 100 0) '(0 0 100 1) .01 '(0 OW 50 E 100 ER) '(.8 .15 .05) '((1 1 2 .5 3 .1 4 .01) (1 1 4 .1) (1 1 2 .1 4 .05)) .01))

#|
(with-sound(:wait t :channels 2) (one-cut 0 1 :sample-rate 3.2 :soundfile "/user/bil/pool/pistol.snd"))
(with-sound (:wait t) (tc 0 1 "/user/bil/pool/pistol.snd" .5 1.25))
(let ((dlocsig-max-time 0.1)(dlocsig-debug nil))(with-sound (:channels 4 :play nil :statistics t :wait t)(simp 0 0.01 440 0.1)))

(with-sound (:play nil :wait t) (btest)) ;should be .1 for 100 (i.e. 3276)
(open-input default-sound-file-name)
(if (> (abs (- .1 (ina 10))) .001) (error "oops"))
(close-input)
|#