;;; -*- Syntax: Common-Lisp; Package: clm; Base: 10; Mode: Lisp -*-

(in-package :clm)
 
(defun mac-ram-size ()
  (%stack-block ((m 4)) 
    (#_gestalt "ram " m)
    (%get-unsigned-long m)))

(defun mac-ram-in-MB ()
  (floor (mac-ram-size) (expt 2 20)))

(defconstant kMachineNameStrID -16395)

(defun mac-machine-type ()
  (%stack-block ((m 4)) 
    (#_gestalt "mach" m)
    (let ((n (%get-unsigned-long m)))
      (ccl::get-ind-string kMachineNameStrID n))))

(defun mac-os-version ()
  ;; returns the digits in successive 8-bit bytes as (for example) 1808 = #x710 = system 7.1
  (%stack-block ((m 4)) 
    (#_gestalt "sysv" m)
    (%get-unsigned-long m)))

(defun mac-os-name ()
  (let ((n (format nil "~X" (mac-os-version))))
    (concatenate 'string (subseq n 0 1) "." (subseq n 1 2) "." (subseq n 2 3))))

(defun mac-processor ()
  (%stack-block ((m 4)) 
    (#_gestalt "proc" m)
    (let ((n (%get-unsigned-long m)))
      (case n
	(1 "68000")
	(2 "68010")
	(3 "68020")
	(4 "68030")
	(5 "68040")
	(otherwise (format nil "unknown: ~D" n))))))

(defun mac-sound-attributes ()
  (%stack-block ((m 4)) 
    (#_gestalt "proc" m)
    (let ((n (%get-unsigned-long m)))
      n)))
;;; a table of attributes:
;;; 0=stereo, 1=mixed internally, 3=new sound manager, 4=sound-in built-in, 5=sound-in from somewhere,
;;; 6=can play and record, 7=has 16-bit, 8=can record stereo, 9=line level input, 10=play from disk ok,
;;; 11=not just mono, 12=16-bit supported

(defun mac-slot-locations ()
  (%stack-block ((m 4)) 
    (#_gestalt "sltc" m)
    (let ((n (%get-unsigned-long m)))
      n)))
;;; this is a table -- bit on = that slot is available in the hardware

#|
(defun dac (file)
  (read-header file)
  (let ((size (c-snd-header-data-size))
	(chans (c-snd-header-chans))
	(srate (c-snd-header-srate))
	(loc (c-snd-header-data-location)))
    ;; use the open/close routines in examples:mac-file-io.lisp
    (let* ((fd (ccl:fsopen file))
	   (nilptr (%null-ptr))
	   (ioref (ccl:pref fd :hparamblockrec.iorefnum)))
      (let ((chantyp (if (= chans 1) initMono initStereo))) -- where are these defined?

	;; now how to call SndNewChannel 

    (#_sndstartfileplay [chan]nilptr ioref 0 [size]4096 nilptr nilptr nilptr [0]-1)

    ;; are we expected to wait here?

    (#_SndDisposeChannel SndChan 1)
    (ccl:fsclose fd)))
 
;;; now why doesn't that work???
|#


(defun mcl-get-string (num) (#_GetString num))

(defun get-volume ()			;apparently a number between 0 and 7
  (traps::getsoundvol))			;from MCL 2.0:library:interfaces.lisp

(defun set-volume (vol)
  (traps::setsoundvol vol))
