/* support for Dac and other system-specific stuff */

#include <Sound.h>
#include <Fcntl.h>
#include <Ioctl.h> 

int set_volume(int right_val, int left_val)
{
  OSErr err;
  err = SetDefaultOutputVolume((right_val << 16) | left_val);
  return((int)err);
}

long get_volume(void)
{
  long amp;
  OSErr err;
  err = GetDefaultOutputVolume(&amp);
  return(amp);
}



extern int c_read_header_with_fd (int chan);
extern int c_snd_header_data_size (void);
extern int c_snd_header_data_location (void);
extern int c_snd_header_chans (void);
extern int c_snd_header_srate (void);


#ifdef ASK_FOR_TROUBLE
/* this version did not actually play anything and caused MCL to crash horribly */
int start_dac(char *arg)
{
  SndChannelPtr chan;
  OSErr err;
  int i,size,chans,srate,loc,fd,chantyp,tmp;
  short fRefNum;

  fd = open(arg,O_RDONLY);

  if (fd != -1)
    {
      i = c_read_header_with_fd(fd);
      srate = c_snd_header_srate();
      chans = c_snd_header_chans();
      loc = c_snd_header_data_location();
      size = c_snd_header_data_size();

      i = ioctl(fd,FIOREFNUM,&tmp);
      fRefNum = (short) tmp;
      chantyp = initMono;
      if (chans == 2) chantyp = initStereo;

      err = SndNewChannel(&chan,sampledSynth,chantyp,NULL);
      err = SndStartFilePlay(chan,fRefNum,0,size,0,0,0,0);
      err = SndDisposeChannel(chan,1);
      close(fd);
    }
  return((int)err);
}
#endif

