(in-package :clm)

#+mcl (progn

	(defun make-handle-i (arr)
	  (let ((size (length arr))
		(hd (#_NewHandle :check-error 0)))
	    (unless (ccl:handlep hd)
	      (error "#_newHandle failed with ~A." hd))
	    (#_SetHandleSize :check-error hd (* size 4))
	    (ccl:with-dereferenced-handles ((p hd))
	      (dotimes (i size)
		(ccl:%put-long p (aref arr i) (* i 4))))
	    hd))

	(defun free-handle-i (hd arr)
	  (unless (ccl:handlep hd)
	    (error "~S is not a valid handle." hd))
	  (let ((size (floor (#_GetHandleSize :check-error hd) 4)))
	    (ccl:with-dereferenced-handles ((p hd))
	      (dotimes (i size)
		(setf (aref arr i) (ccl:%get-long p (* i 4))))))
	  (#_DisposHandle :check-error hd))

	(defun make-handle-f (arr)
	  (let ((size (length arr))
		(hd (#_NewHandle :check-error 0)))
	    (unless (ccl:handlep hd)
	      (error "#_newHandle failed with ~A." hd))
	    (#_SetHandleSize :check-error hd (* size 8))
	    (ccl:with-dereferenced-handles ((p hd))
	      (dotimes (i size)
		(multiple-value-bind (int frac) (floor (aref arr i))
		  (ccl:%put-long p int (* i 8))
		  (ccl:%put-long p (floor (* 32768 frac)) (+ 4 (* i 8))))))
	    hd))

	(defun free-handle-f (hd)
	  (unless (ccl:handlep hd)
	    (error "~S is not a valid handle." hd))
	  (#_DisposHandle :check-error hd))

	)

	
