;;; -*- syntax: common-lisp; package: clm; base: 10; mode: lisp -*-

(in-package :clm)

(CLines "

/* now the derefencing functions to turn KCL objects into C arrays */

#define intarr(x) (x->fixa.fixa_self)
#define flarr(x)  (x->sfa.sfa_self)

int c_openin(object arg1)
{
  return(clm_open_read(object_to_string(arg1)));
}

int c_openout(object arg1)
{
  return(clm_open_write(object_to_string(arg1)));
}

int c_truefillen(object arg1)
{
  return(clm_true_file_length(object_to_string(arg1)));
}

float c_maxamparray(int size, object arr)
{
  return(maxamparray(size,flarr(arr)));
}

void c_normarray(int size, object arr)
{
  normarray(size,flarr(arr));
}

void c_load_one_sine (float partial, float amp, object otable, int table_size, float phase)
{ 
  /* oddly enough, this function has to be in the same file as the associated defentry */
  #define two_pi 6.283185307179586
  float *table;
  float angle,freq;
  int i;
  table = flarr(otable);
  if (amp != 0.0)
    {
      freq = (partial*two_pi)/((float)table_size);
      for (i=0,angle=phase;i<table_size;i++,angle+=freq)
	table[i]+=amp*sin(angle);
    }
}

int c_startdac(object arg)
{
  return(startdac(object_to_string(arg),0,0.0,0.0));
}

int c_sethost(object hst)
{
  return(sethost(object_to_string(hst)));
}

int c_getvolume (object arr)
{
  return(getvolume(intarr(arr)));
}

int c_setvolume (object arr)
{
  return(setvolume(intarr(arr)));
}

int c_mix_compatible_sounds(object mainfile, int main_sample, object mergefile, 
			    int merge_sample, int samples, 
			    int scaler, int use_env, object env)
{
  return(mix_compatible_sounds(object_to_string(mainfile),main_sample,object_to_string(mergefile),
                               merge_sample,samples,
                               scaler,use_env,intarr(env)));
}

int c_mix_mono_to_stereo_sounds(object mainfile, int main_sample, object mergefile, 
			        int merge_sample, int samples,
			        int scalerA, int scalerB, int chan, int use_env, object env)
{
  return(mix_mono_to_stereo_sounds(object_to_string(mainfile),main_sample,object_to_string(mergefile),
                                   merge_sample,samples,
                                   scalerA,scalerB,chan,use_env,intarr(env)));
}

int c_mix_stereo_to_mono_sounds(object mainfile, int main_sample, object mergefile, 
			        int merge_sample, int samples,
			        int scalerA, int scalerB, int chan, int use_env, int initial_value, object env)
{
  return(mix_stereo_to_mono_sounds(object_to_string(mainfile),main_sample,object_to_string(mergefile),
                                   merge_sample,samples,
                                   scalerA,scalerB,chan,use_env,initial_value,intarr(env)));
}

int c_mix_stereo_to_stereo_sounds(object mainfile, int main_sample, object mergefile, 
				  int merge_sample, int samples, 
				  int scalerAA, int scalerBB, int scalerAB, int scalerBA)
{
  return(mix_stereo_to_stereo_sounds(object_to_string(mainfile),main_sample,object_to_string(mergefile),
                                     merge_sample,samples,
                                     scalerAA,scalerBB,scalerAB,scalerBA));
}

int c_mix_quad_to_quad_sounds(object mainfile, int main_sample, object mergefile, 
			      int merge_sample, int samples, 
			      int scalerA, int scalerB, int scalerC, int scalerD,
                              int straight_mix, int initial_value, object env)
{
  return(mix_quad_to_quad_sounds(object_to_string(mainfile),main_sample,object_to_string(mergefile),
                                     merge_sample,samples,
                                     scalerA,scalerB,scalerC,scalerD,
                                     straight_mix,initial_value,intarr(env)));
}

void cc_convolve (object fname, 
                 int filec, int filehdr, int filesize,
                 int filterc, int filterhdr, int filtersize,
                 int start, int fftsize, int ipow, int allpow, int samps, int fullsize, int chans, int chan)
{
  c_convolve (object_to_string(fname),
             filec,filehdr,filesize,
             filterc,filterhdr,filtersize,
             start,fftsize,ipow,allpow,samps,fullsize,chans,chan);
}

void cc_fft(object rl, object im, int n, int isign, int ipow)
{
  c_fft(flarr(rl),flarr(im),n,isign,ipow);
}

int c_c_read_header (object name) 
{
  return(c_read_header(object_to_string(name)));
}

int c_c_write_header(object name, int type, int srate, int chans, int loc, int siz, int format, object comment, int len)
{
  return(c_write_header(object_to_string(name),type,srate,chans,loc,siz,format,object_to_string(comment),len));
}

int c_c_update_header(object name, int type, int size, int srate, int format)
{
  return(c_update_header(object_to_string(name),type,size,srate,format));
}

")


;;; next-io

(defentry c-clear-array-1 (int int int) (void cleararray1))
(defentry c-normalize (int object) (void c_normarray))
(defentry c-load-one-sine-wave (float float object int float) (void c_load_one_sine))
(defentry c-arrblt-1 (int int int int) (void arrblt))
(defentry c-make-array (int) (int makearray))
(defentry c-free-array (int) (void freearray))
(defentry c-setf-aref (int int int) (int setarray))
(defentry c-getf-aref (int int) (int getarray))
(defentry c-incf-aref (int int int) (int incarray))
(defentry c-close (int) (void clm_close))
(defentry c-open-input-file (object) (int c_openin))
(defentry c-open-output-file (object) (int c_openout))
(defentry c-open-clm-file-descriptors (int int int int) (void open_clm_file_descriptors))
(defentry c-close-clm-file-descriptors (int) (void close_clm_file_descriptors))
(defentry c-write-zeros (int int) (void cwritez))
(defentry c-true-file-length (object) (int c_truefillen))
(defentry c-file-position (int int int) (int clm_seek))
(defentry c-read-mono (int int int int) (void crdmono))
(defentry c-read-stereo (int int int int int) (void crdstereo))
(defentry c-read-quad (int int int int int int int) (void crdquad))
(defentry c-write-mono (int int int int) (void cwrtmono))
(defentry c-write-stereo (int int int int int) (void cwrtstereo))
(defentry c-write-quad (int int int int int int int) (void cwrtquad))
(defentry c-abs-max-array (int int int) (int absmaxarr))
(defentry c-timed-abs-max-array (int int int) (int timedabsmaxarr))
(defentry c-last-timed-max () (int get_last_time))

#+NeXT (progn
  (defentry get-dac-filter () (int getdacfilter))
  (defentry set-dac-filter (int) (int setdacfilter))
  (defentry get-dac-zero-fill () (int getdaczerofill))
  (defentry set-dac-zero-fill (int) (int setdaczerofill))
  (defentry ur-get-volume (object) (int c_getvolume))
  (defentry ur-set-volume (object) (int c_setvolume))
  (defentry start-dac (object) (int c_startdac))
  (defentry stop-dac () (void abortdac))
  (defentry abort-dac () (void abortdac))
  (defentry wait-for-dac () (void waitfordac))
  (defentry dac-is-in-use () (int dacisrunning))
  (defentry set-dac-ramp (int) (int setramp))
  (defentry set-dac-host (object) (int c_sethost)))

#+SGI (progn
  (defentry ur-get-volume () (int getvolume))
  (defentry ur-set-volume (int) (int setvolume))
  (defentry start-dac (object) (int urdac))
  )

;;;merge
(defentry c-mix-compatible-sounds (object int object int int int int object) (int c_mix_compatible_sounds))
(defentry c-mix-mono-to-stereo-sounds (object int object int int int int int int object) (int c_mix_mono_to_stereo_sounds))
(defentry c-mix-stereo-to-mono-sounds (object int object int int int int int int int object) (int c_mix_stereo_to_mono_sounds))
(defentry c-mix-stereo-to-stereo-sounds (object int object int int int int int int) (int c_mix_stereo_to_stereo_sounds))
(defentry c-mix-quad-to-quad-sounds (object int object int int int int int int int int object) (int c_mix_quad_to_quad_sounds))

;;; fft
(defentry c-convolve (object int int int int int int int int int int int int int int) (void cc_convolve))
(defentry c-fft (object object int int int) (void cc_fft))

#|
(defCfun "long lisp_call(index) int index;" 0
  ;; here we are mimicking ACL's lisp-callback feature
  ((fatal_write_error)))
|#

(defun fatal_write_error () (error "fatal write error"))


;;; headers
(defentry c-snd-header-chans () (int c_snd_header_chans))
(defentry c-snd-header-srate () (int c_snd_header_srate))
(defentry c-snd-header-data-size () (int c_snd_header_data_size))
(defentry c-snd-header-datum-size () (int c_snd_header_datum_size))
(defentry c-snd-header-data-location () (int c_snd_header_data_location))
(defentry c-snd-header-format () (int c_snd_header_format))
(defentry c-snd-header-type () (int c_snd_header_type))
(defentry c-snd-header-distributed () (int c_snd_header_distributed))
(defentry c-snd-header-comment-start () (int c_snd_header_comment_start))
(defentry c-snd-header-comment-end () (int c_snd_header_comment_end))
(defentry c-snd-header-type-specifier () (int c_snd_header_type_specifier))
(defentry c-set-snd-header (int int int) (void c_set_snd_header))

(defentry c-read-header (object) (int c_c_read_header))
(defentry c-write-header (object int int int int int int object int) (int c_c_write_header))
(defentry c-update-header (object int int int int) (int c_c_update_header))
