;;; -*- syntax: common-lisp; package: clm; base: 10; mode: lisp -*-

(in-package :clm)

;;; my interpretation of the kcl report documentation of the defcfun/gc problem
;;;  is that object arguments are safe, so references to fields of that object
;;;  have a chance of being safe as well. We are passing down to C the array
;;;  address stored as the "self" field of the array object, and it's not out of
;;;  the question that the GC might move the array during a sweep.  However,
;;;  to quote the report "objects on the value stack are automatically protected 
;;;  against garbage collection", and you get the value stack, as opposed to the
;;;  C stack, unless you give explicit type declarations at the lexical point of
;;;  the call.  Since the 56k callers never use declare of a type, nothing can go wr

;;; an added annoyance in this set of c files is that KCL refuses to honor case
;;;  distinctions even within "||"! So, we add extra functions just to get lower
;;;  case names.

#+QP (Clines "
#define QUINTPROCESSOR
")

#+ArielPc56d (Clines "
#define ARIEL_PC_56D
#include \"dspdriverAccess.c\"
")

#+Ilink (Clines "
#include \"IlinkUser.c\"
")

#+MultiSound (Clines "
#include \"MultiSoundUser.c\"
")

#+(and ArielPc56d (not Ilink) (not MultiSound)) (Clines "
#include \"ArielPC56dUser.c\"
")

#+Arielpc56d (Clines "
static int current_active_dsp = -1;
")


(Clines "

#define AKCL
#include \"next56.c\"

#ifdef QUINTPROCESSOR
  #include \"qp.c\"
#endif

#define intarr(x) (x->fixa.fixa_self)
#define flarr(x)  (x->sfa.sfa_self)


/* KCL dereferencing functions */

void c_arrtran (int beg1, int end1, object arr1, int beg2, object arr2)
{
  arrtran(beg1,end1,intarr(arr1),beg2,intarr(arr2));
}

void c_loadfarr(object tbl, int siz, int beg, object mem)
{
  cloadfarr(flarr(tbl),siz,beg,intarr(mem));
}

int c_dspputarray(int beg, int end, object arr)
{
  return(dspputarray(beg,end,intarr(arr)));
}

int c_dspgetarray(int beg, int end, object arr)
{
  return(dspgetarray(beg,end,intarr(arr)));
}

int c_outonebuf(int start, int stop, object outloc)
{
  return(outonebuf(start,stop,intarr(outloc)));
}

int c_cpu_boot(int end, object program)
{
  return(cpu_boot(end,intarr(program)));
}

void c_dspsendinput(object beg, int cursiz, object sigops, object sigptrs, object ptr_sigadrs, object sigsizes, int sigsiz)
{
  dspsendinput(intarr(beg),cursiz,intarr(sigops),intarr(sigptrs),intarr(ptr_sigadrs),intarr(sigsizes),sigsiz);
}

void c_basicdspread (int beg, int end, int sigsiz, int dlys, int ins,
	      object sigops, object ptr_sigadrs, object sigptrs,
	      object sigbas, object sigtop, object sigsizes)
{
  basicdspread(beg,end,sigsiz,dlys,ins,
               intarr(sigops),intarr(ptr_sigadrs),intarr(sigptrs),
               intarr(sigbas),intarr(sigtop),intarr(sigsizes));
}

int c_dspsetupprogram(int ix, int iy, int ex, int ey, int ep, int xoff, int yoff, int poff, object ixarr, object iyarr, object earr)
{
  return(dspsetupprogram(ix,iy,ex,ey,ep,xoff,yoff,poff,intarr(ixarr),intarr(iyarr),intarr(earr)));
}

#ifdef QUINTPROCESSOR
/* QP.C */

int c_qp_check_all_slots(object slots)
{
  return(QP_check_all_slots(intarr(slots)));
}

int c_qp_boot_dsp(int slot, int dsp, int end, object program, int monend, int memorymap)
{
  return(QP_boot_dsp(slot,dsp,end,intarr(program),monend,memorymap));
}

void c_qp_report_hi (object his)
{
  QP_report_hi(intarr(his));
}

/* now KCL bug work-arounds... */

void qp_all_done (void) {QP_all_done();}
int qp_set_current_dsp (int slot, int dsp) {return(QP_set_current_dsp(slot,dsp));}
int qp_is_open (void) {return(QP_is_open());}
int qp_get_interrupt (void) {return(QP_get_interrupt());}
void qp_clear_interrupt (void) {QP_clear_interrupt();}
#endif QUINTPROCESSOR

int get_icr (void) {return(get_ICR());}
int get_isr (void) {return(get_ISR());}
int get_cvr (void) {return(get_CVR());}
void put_icr (int word) {put_ICR(word);}
void put_cvr (int word) {put_CVR(word);}
int hf2 (void) {return(HF2());}
int hf3 (void) {return(HF3());}
int checkhostinterface (void) {return(checkhostInterface());}


")

#+QP (progn
       (defentry qp-check-all-slots (object) (int c_qp_check_all_slots))
       (defentry qp-all-done () (void qp_all_done))
       (defentry qp-boot-dsp (int int int object int int) (int c_qp_boot_dsp))
       (defentry qp-set-current-dsp (int int) (int qp_set_current_dsp))
       (defentry qp-is-open () (int qp_is_open))
       (defentry qp-hi-1 (object) (void c_qp_report_hi))
       (defentry qp-get-interrupt () (int qp_get_interrupt))
       (defentry qp-clear-interrupt () (void qp_clear_interrupt))
       )

(defentry dsp-is-open () (int dspisopen))
(defentry dsp-read-icr () (int get_icr))
(defentry dsp-read-isr () (int get_isr))
(defentry dsp-read-cvr () (int get_cvr))
(defentry dsp-write-icr (int) (void put_icr))
(defentry dsp-write-cvr (int) (void put_cvr))
(defentry dsp-HF2 () (int hf2))
(defentry dsp-HF3 () (int hf3))
(defentry c-array-transfer (int int object int object) (void c_arrtran))
(defentry c-read-dsp-block (int int int int int object object object object object object) (void c_basicdspread))
(defentry dsp-send-input (object int object object object object int) (void c_dspsendinput))
(defentry c-insig (int int int int int) (void inn))
(defentry c-load-fractional-array (object int int object) (void c_loadfarr))
(defentry dsp-put-one-word (int) (int dspputoneword))
(defentry dsp-get-one-word () (int dspgetoneword))
(defentry lsp-put-one-word (int) (int dspputoneword))
(defentry lsp-get-one-word () (int dspgetoneword))
(defentry dsp-put-array (int int object) (int c_dspputarray))
(defentry dsp-get-array (int int object) (int c_dspgetarray))
(defentry dsp-merge-one-buffer (int int object) (int c_outonebuf))
(defentry dsp-set-up-program (int int int int int int int int object object object) (int c_dspsetupprogram))
(defentry dsp-start-again (int int) (int dspstartagain))
(defentry dsp-data-ready () (int dspdataready))
(defentry dsp-check-host-interface () (int checkhostinterface))
(defentry dsp-get-host-interface () (int hival))
(defentry dsp-set-up (int object) (int c_cpu_boot))
(defentry clear-host-interfaces () (void clear_host_interfaces))
(defentry dsp-2-close () (int cpu_close))
(defentry set-current-active-dsp (int) (void set_active_dsp))
(defentry get-current-active-dsp () (int get_active_dsp))
(defentry get-wait-time () (int get_wait_time))
(defentry set-wait-time (int) (int set_wait_time))

#+56-mus-gens
(defCfun "long lisp_call(index) int index;" 0
  ;; here we are mimicking ACL's lisp-callback feature
  ((call_lisp_and_hope_for_best (int index))))
