;;; -*- Lisp -*-
;;;

#-cltl2 (in-package :clm :use (list (find-package :lisp) (find-package :walker) (find-package :loop)))

#+cltl2 (in-package :clm)

#-KCL (progn
  (defvar *clm* (find-package :clm) "common lisp music synthesis package")
  (defvar *clm-version* "Common Lisp Music 22-Jun-94")
  (defvar *clm-date* "22-Jun-94")
  )

#-cltl2
(export '(*CLM* *CLM-VERSION* *CLM-NEWS* *CLM-DATE* *CLM-VERBOSE* *CLM-ARRAY-PRINT-LENGTH* *CLM-INIT*
	  *CLM-SAFETY* *CLM-SPEED* *SOUND-PLAYER* *GRAB-DAC* *CLM-INTERRUPTED*
					;from io.lisp
	  IO IO-P MAKE-IO IO-BEG IO-END IO-SIZ IO-DATA-END IO-DAT-A IO-DAT-B IO-DAT-C IO-DAT-D IO-NAM IO-DIR IO-FIL 
	  IO-OPEN-INDEX IO-HDR IO-DATA-START IO-BUFSIZ IO-HDR-END
	  *CURRENT-OUTPUT-FILE* *CURRENT-INPUT-FILE* FILE-BUFFER-SIZE *CLM-CURRENT-OPEN-FILES*
	  CLM-OPEN-INPUT CLM-OPEN-OUTPUT CLM-CLOSE-INPUT CLM-CLOSE-OUTPUT CLM-REOPEN-OUTPUT
	  OUTA OUTB OUTC OUTD INA INB IN-A IN-B IN-C IN-D QUAD STEREO MONO 
	  *REVERB* REVIN REVOUT
	  *AVAILABLE-IO-CHANNELS*
          FULL-MERGE-PATHNAMES
					;from headers.lisp
	  MAKE-HEADER READ-HEADER WRITE-HEADER UPDATE-HEADER EDIT-HEADER
	  DEFAULT-SOUND-FILE-NAME DEFAULT-REVERB-FILE-NAME DEFAULT-SOUND-FILE-TYPE
	  SND-HEADER-COMMENT
	  *IGNORE-HEADER-ERRORS* *FIX-HEADER-ERRORS*
	  AIFF-SOUND-FILE NEXT-SOUND-FILE RIFF-SOUND-FILE
					;from dacs.lisp
	  VOLUME DAC-FILTER
					;from mus.lisp
	  ONE-PI TWO-PI HALF-PI THREE-HALF-PI SAMPLING-RATE FREQUENCY-MAG SET-SRATE IN-HZ
	  OSC OSC-FREQ OSC-PHASE MAKE-OSC OSC-P OSCIL MAKE-OSCIL
	  DEFAULT-TABLE-SIZE MAX-AMP NORMALIZE ARRAY-INTERP MAKE-TABLE GET-INCREMENT TABLE-INTERP
	  TBL MAKE-TBL TBL-P TBL-FREQ TBL-INTERNAL-MAG TBL-PHASE TBL-TABLE TBL-TABLE-SIZE
	  MAKE-TABLE-LOOKUP UR-TABLE-LOOKUP TABLE-LOOKUP LOAD-SYNTHESIS-TABLE
	  RING-MODULATE AMPLITUDE-MODULATE
	  DLY MAKE-DLY DLY-P DLY-SIZE DLY-PLINE DLY-LOC DLY-ID DLY-EXT-ID MAKE-DELAY DELAY *CLM-DELAY-LINES* TAP
	  ZDLY MAKE-ZDLY ZDLY-P ZDLY-DEL ZDLY-PHASE MAKE-ZDELAY ZDELAY REMEMBER-ZDELAY *CLM-ZDELAY-LINES* ZTAP
	  CMBFLT MAKE-CMBFLT CMBFLT-P CMBFLT-DLY-UNIT CMBFLT-SCALER MAKE-COMB COMB NOTCH MAKE-NOTCH
	  ALLPASSFLT MAKE-ALLPASSFLT ALLPASSFLT-P ALLPASSFLT-DLY-UNIT ALLPASSFLT-FEEDFORWARD 
	  ALLPASSFLT-FEEDBACK MAKE-ALL-PASS ALL-PASS
	  FLT MAKE-FLT FLT-P FLT-A FLT-B FLT-C FLT-D FLT-M FLT-SO FLT-TYP MAKE-FILTER FILTER
	  CONVOLVE MAKE-CONVOLVE CONV CONV-P MAKE-CONV CONV-FILTR CONV-FILTI CONV-FFTF
	  DOT-PRODUCT
	  SMPFLT MAKE-SMPFLT SMPFLT-P SMPFLT-A0 SMPFLT-A1 SMPFLT-A2 SMPFLT-B1 
	  SMPFLT-B2 SMPFLT-X1 SMPFLT-X2 SMPFLT-Y1 SMPFLT-Y2
	  ONE-POLE ONE-ZERO TWO-POLE TWO-ZERO MAKE-ONE-POLE MAKE-ONE-ZERO MAKE-TWO-POLE MAKE-TWO-ZERO
	  MAKE-PPOLAR PPOLAR MAKE-ZPOLAR ZPOLAR
	  FRMNT MAKE-FRMNT FRMNT-P MAKE-FORMNT FORMNT FRMNT-G FRMNT-TP FRMNT-TZ
	  LATTICE-FILTER LADDER-FILTER FFT-FILTER DIRECT-FILTER
	  MAKE-LATTICE-FILTER MAKE-LADDER-FILTER MAKE-DIRECT-FILTER DIRECT-FORM LATTICE-FORM LADDER-FORM MAKE-FFT-FILTER
	  NOI MAKE-NOI NOI-P NOI-FREQ NOI-BASE NOI-PHASE NOI-OUTPUT NOI-INCR NOI-RAN-OP
	  MAKE-RANDH RANDH MAKE-RANDI RANDI

	  ENVELOPE MAKE-ENVELOPE ENVELOPE-P ENVELOPE-CURRENT-VALUE ENVELOPE-RATE ENVELOPE-DATA ENVELOPE-PASS ENVELOPE-END
	  ENVELOPE-BASE ENVELOPE-OFFSET ENVELOPE-SCALER ENVELOPE-POWER ENVELOPE-OP ENVELOPE-RESTART ENVELOPE-TYPE
	  LIST-INTERP MAX-ENVELOPE SCALE-ENVELOPE NORMALIZE-ENVELOPE ENV-LAST-X RESTART-ENV
	  ENV MAKE-ENV DIVSEG DIVENV OP-Y-ENV OP-X-ENV FIX-ENVELOPE MAKE-FUNC

	  SW MAKE-SW SW-P SW-CURRENT-VALUE SW-FREQ SW-PHASE SW-BASE
	  MAKE-TRIANGLE-WAVE TRIANGLE-WAVE MAKE-SQUARE-WAVE SQUARE-WAVE
	  MAKE-SAWTOOTH-WAVE SAWTOOTH-WAVE MAKE-PULSE-TRAIN PULSE-TRAIN
	  WS MAKE-WAVESHAPE-TABLE MAKE-PHASE-QUAD-TABLE MAKE-WAVESHAPE WAVESHAPE WS-P MAKE-WS WS-TAB WS-OS WS-OFFSET 
	  GET-CHEBYCHEV-COEFFICIENTS NORMALIZE-PARTIALS POLYNOMIAL
	  LOCSIG MAKE-LOCSIG LOCS LOCS-P LOCS-ASCL LOCS-BSCL LOCS-CSCL LOCS-DSCL LOCS-RSCL 
	  LOCS-DEG LOCS-DIS LOCS-PC-REV LOCS-REVNAME MAKE-LOCS MAKE-QUADSIG
	  MAKE-ROOMSIG RMLOC RMLOC-P RMLOC-W RMLOC-L RMLOC-UW RMLOC-UL RMLOC-DATA RMLOC-DISTS
	  SMP MAKE-SMP SMP-P SMP-FIL SMP-SR SMP-X SMP-LST SMP-NXT SMP-I SMP-CHN MAKE-RESAMPLE RESAMPLE
	  CONTRAST-ENHANCEMENT GET-BEG-END 

	  CLM-GET-DURATION CLM-GET-CHANNELS CLM-GET-SAMPLING-RATE CLM-GET-MAX-AMP CLM-GET-SAMPLES
	  READIN MAKE-READIN READIN-REVERSE MAKE-REVERSE
	  RDIN-P RDIN MAKE-RDIN RDIN-I RDIN-INC RDIN-CHN RDIN-FIL 
	  SUM-OF-COSINES MAKE-SUM-OF-COSINES COSP COSP-P COSP-COSINES COSP-PHASE COSP-FREQ COSP-SCALER MAKE-COSP
	  SINE-SUMMATION MAKE-SINE-SUMMATION SSS SSS-P SSS-PHASE SSS-FREQ SSS-A SSS-N SSS-B MAKE-SSS
	  ASYMMETRIC-FM MAKE-ASYMMETRIC-FM ASYMFM ASYMFM-P ASYMFM-R ASYMFM-PHASE ASYMFM-FREQ ASYMFM-RATIO ASYMFM-R MAKE-ASYMFM
	  RBLK-P RBLK-BUF RBLK-SIZ RBLK-CTR RBLK-LOC MAKE-RBLK MAKE-BLOCK RUN-BLOCK CLEAR-BLOCK RBLK
	  WT WT-P MAKE-WT WT-WAVE WT-WSIZ WT-FREQ WT-B MAKE-WAVE-TRAIN WAVE-TRAIN WT-PHASE WT-INTERNAL-MAG
	  MAKE-EXPAND EXPAND
	  SPD SPD-P MAKE-SPD SPD-RD SPD-LEN SPD-RMP SPD-AMP SPD-IN-SPD SPD-OUT-SPD SPD-TYP SPD-CUR-IN SPD-CUR-OUT
	  SPD-B SPD-S20 SPD-S50 SPD-CTR
	  MAKE-SRC SRC MAKE-SR SR SR-RD SR-P MAKE-SR SR-X SR-INCR SR-DATA SR-WIDTH SR-LEFT SR-RIGHT SINC SR-FILT
	  FFTFLT-P MAKE-FFTFLT FFTFLT-ENV FFTFLT-SIZ FFTFLT-HOP FFTFLT-RD FFTFLT-B 
	  FFTFLT-DATAR FFTFLT-DATAI FFTFLT-HALF-SIZ FFTFLT
	  FFT INVERSE-FFT FFT-WINDOW
	  MAKE-FFT-DATA FFT-DATA-P FFT-DATA-REAL FFT-DATA-IMAGINARY FFT-DATA-SIZE FFT-DATA MAKE-FFT-DATA-ARRAYS
	  SPECTRUM RECTANGULAR-WINDOW HANNING-WINDOW WELCH-WINDOW PARZEN-WINDOW BARTLETT-WINDOW 
	  HAMMING-WINDOW ORDER-0-WINDOW ORDER-1-WINDOW ORDER-2-WINDOW ORDER-3-WINDOW ORDER-4-WINDOW 
	  EXPONENTIAL-WINDOW KAISER-WINDOW 
	  
	  READ-FORWARD READ-BACKWARD READ-POSITION
	  SHOW-DATA SHOW-LOG-DATA PRINT-HASH CLM-PRINT
	  
	  LONG-INT REAL FRACTION ;integer??

					;from next.c via next.lisp
	  SOUND-ERROR DSP-WHO START-DAC STOP-DAC ABORT-DAC WAIT-FOR-DAC DAC-IS-IN-USE
	  *CLM-LANGUAGE*		;added 13-Mar-94
	  *CLM-PHRASES-ACTIVE*		;added 25-Apr-94
					;from io.lisp
	  CLM-NOTEHOOK CLM-STATISTICS CLM-LAST-BEGIN-TIME CLM-TOTAL-DURATION
	  CLM-INITIALIZE-STATISTICS CLM-PRINT-STATISTICS CLM-INITIALIZE-NOTEHOOK
	  CLM-GET-DEFAULT-HEADER

	  RUN END-RUN
	  C56-CLEANUP C56-RESET-CLEANUP C56-DEBUG C-DEBUG
	  DSP-OPEN DSP-CLOSE DSP-IS-OPEN 
	  SET-INSTRUMENT-PROPERTIES *CURRENT-INSTRUMENT-NAME* 
	  DISPLAY-DSP-STATE DESCRIBE-DSP-STATE DESCRIBE-C-STATE DESCRIBE-INS-STATE
	  DEF-CLM-STRUCT USER-STRUCTS
	  MAKE-PHRASE WAIT-FOR-PHRASE PHRASE-VALUE PHRASE
	  INSTRUMENT-VALUE SET-UP-DSP-MEMORY-MAP

	  WITH-SOUND CLM-LOAD DAC DAC-N CLOSE-OUTPUT CLOSE-INPUT DEFINSTRUMENT DAC* DEFCINSTRUMENT
	  OPEN-OUTPUT REOPEN-OUTPUT OPEN-INPUT CLU-RESET INSTRUMENT-LET MIX-SOUND MIX-IN MIX
	  *OPEN-INPUT-VERBOSE* *OPEN-INPUT-PRINT* *OPEN-INPUT-TRUENAME* *OPEN-INPUT-PATHNAME* *CLM-FORCE-RECOMPUTATION*
	  *OPEN-INPUT-EXPLICIT-OUTPUT* *OPEN-INPUT-EXPLICIT-REVERB* *MIX-CALLS* *SOUND-PLAYER* DPYSND
	  *CLM-INSTRUMENTS* SOUND-LET WITH-MIX *MIX-OPTIONS* FASMIX COMPILE-INS *GRAB-DAC* *REVERB-DECAY-TIME*
	  INIT-WITH-SOUND FINISH-WITH-SOUND CLM-CLEANUP

	  #+NeXT JRDAC #+NeXT INIT-JRDAC
	  
	  ))


#+KCL (progn
  (defvar *clm* (find-package :clm) "common lisp music synthesis package")
  (defvar *clm-version* "Common Lisp Music 22-Jun-94")
  (defvar *clm-date* "22-Jun-94")
  )

(pushnew :CLM *features*)

(defvar *clm-news* 
  "
22-Jun: Sound Designer II format support added.

21-Jun: added reverb maxamp data to stats

10,13,15-Jun: minor bug fixes.

7-Jun:  tap on 56k implemented; sigint support and sms.lisp improved.

1..2-Jun: c_env inlined, various other cmus optimizations. This caused a change to the AKCL NeXT.defs LIBS
        statement -- AKCL users need to rebuild libmus.a, change the LIBS statement, re-run add-defs, and
        remake AKCL.  Evaluate-polynomial removed, also clmrpc support and 56k floating variables.
")


(defvar *old-clm-news* 
"
27-May: sms.lisp updated. Added sigint trap to C instruments.
20-May: cmus.h-directory added (defaults.lisp).
17-May: MCL disables 'run'.
4-May:  SGI AKCL support.
2-May:  jrdac support for play program of Jean Laroche on the NeXT
25-Apr: describe-ins-state, phrasing stuff in C ins.
15-Apr: Support added for Ilink board (NSI).  c-mus-gens switch removed.
14-Apr: merged ztap into rest of CLM, added tap.
11-Apr: c-mus-gens optimized.  describe-structure-for-run replaced by def-clm-struct.
        display-chip-state replaced by display-dsp-state.  kcl version now requires
        loading kcl with libmus.a.  kcl-cmus.lisp, defrun.cl and fft.c deleted.  Many extensions
        to C case (arrays of spd and locs, cosp, rdin, and io struct fields, instruments
        no longer need to be compiled in Lisp, end-run is unneeded, user-defined C
        functions can be called without any overhead, and so on).  The new CLM runs
        about 8-10 times faster in ACL, 10-15 times faster in KCL, when using C unit
        generators, so there is now no reason to use the 56000 except when a QP board
        is available.  describe-c-state and print-hash added. fftflt-saved-env removed.
        All C envelopes are restartable (that is, the :restartable keyword is a no-op)
        blk struct renamed rblk. c56 and clu packages removed -- everything is in clm package.
        seg-func, map-func, exp-func removed. New options for definstrument.
14-Mar: c-mus-gens and 56-mus-gens are now compatible, so C fallback is much more robust.
11 Mar: QP switch complete.
9-Mar:  support non-word aligned data (NeXT files). Many SGI changes, courtesy Fernando D. Mato Mira.
7-Mar:  added rest of header readers and alaw/mulaw translation.
3-Mar:  AFsp header reader, completion of PC56D port
21-Feb: support for Ariel PC56D card on NeXTStep/Intel. Many changes to next56.c
9-Feb:  192K SFSU mem bug fixed, several changes to dsp open/close code
1-Feb:  NS/Intel port for c unit generators, init-with-sound and finish-with-sound for Common Music
28-Jan: port to NSI (using c ugs), more mac improvements
12-Jan: various fixups of 3-Jan changes, MPW 3.3, NS 3.2, RIFF, etc
3-Jan-94:  mac revisions, header/dac support for other file formats, DAC stuff, volume function

1-Dec:  kcl c revisions
24-Nov: complete revision of c unit generator code
1-Nov:  added fm arg to waveshape unit generator; changes to ins.lisp
12-Oct: read-forward, read-backward, read-position -- see the instrument 'backandforth' in ins.lisp
1-Oct:  56K monitor change; SFSU 192K DSP memory expansion support; yoffset.h removed, dsp32K switch removed
15-Jul: ACL 4.1 confused by loop ref in run.lisp
29-Jun: fusion.ins
23-Jun: X mem allocation bug fixed
17-May: input-file-start-time and input-file-start added as synonyms of start-time and start respectively.
14-May: mix/with-mix notice interrupted section computations and recompute them, smarter output to secondary files
16-Apr: added quad case to fasmix.
25-Mar: removed NeXT OS 1.0 files, *grab-dac* added.
22-Mar: save-body in with-sound, statistics improved
18-Mar: seg-func, map-func, and exp-func coalesced into envelope, restart-env, compile-ins
15-Mar: more fasmix options, c-merge-sound removed, sound-let uses let*, convolve in kcl
8-Mar:  mix-in dur added, fasmix for much faster sound file mixing
3-Mar:  spectral modelling san.ins
1-Mar:  physical modelling clarinet added, waveguide removed, outa improved
24-Feb: with-mix added, clm-get-max-amp improved
8-Feb:  nrev improved, sound-let, window changed to fft-window (name conflicts on Mac)
3-Feb-93:  C unit generators (for SGI), ACL 4.1 support on the NeXT

24-Nov: (print var) now works in Run, princ added
19-Oct: Turbo Next; QP on 3.0 turned up a slot driver change
16-Oct: ACL 3.1 on NeXT 3.0; *clm-instruments*
1-Oct:  *sound-player* for special dac routines; akcl on 3.0 NeXT.
10-Sep: ztap; multiple locsigs/outns should work to some extent
7-Aug:  dsp32K for NeXT 32K DSP memory upgrade, NeXT 3.0.
22-Jun: SGI support, safety optimization quality added
18-Jun: multidimensional arrays, several code generator optimizations, expt improved
8-Jun:  def-run-fun
1-Jun:  mix
28-May: let/let* do/do* local variables in loop statements, psetf/psetq
26-May: zdelay arrays and external functions, more than one outa/locsig
15-May: zpolar should have been two-zero, not two-pole!
1-May:  open-input smarter, *clm-verbose*, fft in run, pm input to oscil, polynomial
10-Apr: Instrument-let
30-Mar: Mac II/Sound Accelerator support re-implemented
16-Mar: external envelopes, print, error, warn, funcall added in Run
17-Feb-92: readin-reverse, wave-train bugs fixed, clmrpc added for QP access across Ethernet
")