;;; -*- syntax: common-lisp; package: clm; base: 10; mode: lisp -*-
;;;

(in-package :clm)

(defvar *ask-before-falling-back-on-C-and-Lisp-in-run* t);other values are nil and :warn


;;; CODE GENERATOR GLOBALS -------------------------------------------------------------------------
;;; 
;;; the following things are here just to avoid lisp compiler confusion -- they really belong in run.lisp

(defun new-label (&optional name)
  (if name name (gensym "L-")))

(defun new-signal () (gentemp "DSP_"))  ;changed to "_" to be C compatible 14-Mar-94
					;we need gentemp here, rather than gensym, because these signals may be SET later.

(defvar pp nil)				; 56000 program in preparation
					; (prior to optimizations of various kinds)
(defvar pip nil)			;i/o loop prog

(defvar p-init nil)			;library initialization code, if any

(defvar pup nil)			;our load-time program fragment
					;(setf's X and Y memory arrays to initial values)
(defvar pp-init-sample nil)

(defvar user-structs nil)		;hash table of user-defined struct info

(defvar c56-debug nil)
(defmacro DEBUGGING (x)
  #+mcl (declare (ignore x)) 
  #-mcl `(if c56-debug ,x)
  )

(defvar emit-prog nil)
(defvar vars (make-hash-table))		;compiler's symbol table


;;; next set of variables are used by the RUN macro in run.lisp, but need to be declared here.
(defvar new-sig nil)			;a list of temporary signal names
(defvar true-user-var nil)		;variables that are SETQ'd
(defvar user-var nil)			;variables that are referenced
(defvar typed-user-var nil)		;variables where we can make a plausible guess at the type
					;a list of lists of form ( (var type) ...)
(defvar setf-first-var nil)		;special cases -- run-time type accepted blindly
(defvar typed-user-sig nil)
(defvar new-prog nil)
(defvar loop-var nil)

(defvar local-vars nil)
(defvar parallel-local-vars nil)
(defvar full-array-names nil)

(defvar run-safety 0)			;setting of safety switch in Run
(defvar run-speed 1)
;;; end RUN variables.

(defun car-member (var lst)
  (and lst
       (or
	(and (eq var (caar lst)) (cadar lst))
	(car-member var (cdr lst)))))

(defun known-var (var)
  (or (member var user-var)
      (member var true-user-var)
      (car-member var typed-user-var)
      (car-member var local-vars)
      (member var new-sig)))

(defun local-var-alias (var)
  (or (and local-vars (car-member var local-vars))
      var))


(defvar current-slot 0)
(defvar current-dsp 0)
(defvar dsps 0)

;;; dsp-data states (keep in sync with list in dsp-data structure definition in ins56)
(defconstant dsp-normal 0)
(defconstant dsp-ready-to-merge 1)
#+QP (defconstant qp-merging 2)
(defconstant dsp-merging 3)
#+QP (defconstant qp-uninitialized 4)
#+QP (defconstant qp-as-reverb 5)
(defconstant dsp-off 6)
#+QP (defconstant qp-initializing 7)
#+QP (defconstant qp-normal 8)
(defconstant dsp-uninitialized 9)
(defconstant dsp-not-currently-in-use 10)
#+QP (defconstant qp-shifting 11)


(defmacro def-clm-struct (name &rest fields)
  `(eval-when (eval compile load)
     (progn
       (defstruct (,name (:type list) :named) ,@(loop for fld in fields collect (if (listp fld) (first fld) fld)))
       (if (null user-structs) (setf user-structs (make-hash-table)))
       (setf (gethash ',name user-structs) ',fields)
       (loop for i from 1 and field in ',fields do 
	     (let* ((field-name (if (listp field) (first field) field))
		    (accessor-name (intern (concatenate 'string (symbol-name ',name) "-" (symbol-name field-name)))))
	   (setf (gethash accessor-name user-structs)
		 (list i (if (and (listp field) (symbolp (cadr field))) (cdr field) '(real)) ',name field-name)))))))

;;; user-struct dependents are in cmus.lisp, ins56.lisp, code56.lisp, run.lisp

(defvar <t> 0)
(defvar <nil> #x10000)

(defvar checked-variables nil)
(defvar inited-arrays nil)
(defvar dsp-pc 0)

(defconstant pure-float-structs '(osc flt-one-pole flt-one-zero flt-two-pole flt-two-zero smpflt frmnt sw cosp noi randi hloc))

(defvar *current-instrument-name* nil)
(defvar c56-need-to-load-expt nil)
(defvar c56-need-to-save-labels nil)

