;;; -*- syntax: common-lisp; package: clm; base: 10; mode: lisp -*-
;;;
;;; this file contains most of the global default values that control CLM

(in-package :clm)

(defconstant NeXT-sound-file 0)
(defconstant AIFF-sound-file 1)
(defconstant RIFF-sound-file 2)
(defconstant BICSF-sound-file 3)
(defconstant NIST-sound-file 4)
(defconstant INRS-sound-file 5)
(defconstant ESPS-sound-file 6)
(defconstant SVX-sound-file 7)
(defconstant VOC-sound-file 8)
(defconstant SNDT-sound-file 9)
(defconstant raw-sound-file 10)
(defconstant SMP-sound-file 11)
(defconstant SD2-sound-file 12)


(defvar sampling-rate 22050)

#+MCL (defvar file-buffer-size 4096)
#-MCL (defvar file-buffer-size (* 64 1024))
;;; because data is packed two samples to a word, this buffer-size better be an even number
;;; There's no real point in making this a variable, rather than a constant (defconstant)
;;; because the io defstruct in io.lisp sets up various buffer sizes at compile time


#+NeXT (defvar default-sound-file-name "/zap/test.snd")
#+NeXT (defvar default-reverb-file-name "/zap/reverb.snd")
#+NeXT (defvar default-sound-file-type NeXT-sound-file)

#+SGI (defvar default-sound-file-name "/usr/zap/test.snd")
#+SGI (defvar default-reverb-file-name "/usr/zap/reverb.snd")
#+SGI (defvar default-sound-file-type NeXT-sound-file)

#+MCL (defvar default-sound-file-name "clm:test.snd")
#+MCL (defvar default-reverb-file-name "clm:reverb.snd")
#+MCL (defvar default-sound-file-type AIFF-sound-file)

;;; these are the default output sound file names used in open-output, open-input, dac, and
;;; so on.  Due to unix weirdness, if several people are using one machine, these files should
;;; be deleted upon logout -- here at CCRMA this is automatically done for anything on the
;;; "zap" directory.  If one user leaves these files around, and another tries to overwrite
;;; them, the probability is high that he will get the error "create file error: permission denied"
;;; or some variant thereof.  This happens because the normal "umask" is 022, meaning "don't let
;;; random users write my files", so even if we write the temporary files with the permission 666
;;; (see c-create in io.c), the actual permission written is normally 644.  When another user
;;; comes along, he isn't the owner, so he can't overwrite the left over files.


(defvar *ignore-header-errors* nil)	; size field is considered "advisory" in specs, so it can be wrong
(defvar *fix-header-errors* t)		; if header is wrong, should we get corrected data

(defvar *clm-verbose* nil)		; will cause instrument names and so on to be printed out

(defvar *sound-player* nil)		; user-supplied DAC function
(defvar *grab-dac* t)			; should dac function interrupt whatever the DAC is doing

(defvar default-table-size 512)		; used for table-lookup tables and others

(defvar *clm-max-delay-lines* 256)	; how many delay lines do we keep track of (can be any size without much penalty)

(defvar *clm-safety* 0)			; default safety setting in Run (applies only to DSP code)
(defvar *clm-speed* 1)			; currently unused

(defvar *clm-array-print-length* 10)	; how much of an array to print out during debugging
(defvar *available-IO-channels* 16)	; how many IO channels can we have open at once (can be whatever the operating
					;   system will allow -- 16 is certainly safe)

(defvar *clm-init* nil)			; name of init file used during load process

(defvar *clm-language* #+56-mus-gens :56k #-56-mus-gens :c)
					; default output language for instruments

;(defvar cmus.h-directory "/Local/Lisp/clm/")            ; where cmus.h is (for the c-instrument option in definstrument)
(defvar cmus.h-directory "")            ; where cmus.h is (for the c-instrument option in definstrument)
