/* header for cmus generated c files and its associated library */

#define one_pi 3.141592653589793
#define two_pi 6.283185307179586
#define minus_two_pi -6.283185307179586
#define half_pi 1.5707963267948966
#define three_half_pi 4.71238898038469
#define lotsa_pi 6283.185307179586
#define minus_lotsa_pi -6283.185307179586
#define inverse_pi 0.15915494309189535

#define _sndfix_ 32768.0
#define _sndflt_ 0.000030517578
/* assuming here 16-bit sound samples (as stored in the io buffers) */


#if CLM_C_INSTRUMENT

  #define ERROR_C 100
  #define BREAK_C 101
  #define FUNCTION_C 102

  void clm_full_file_reset(int loc, int *io);
  void clm_file_reset(int loc, int *io);

  extern void c_init_sine (void);
  extern float c_sin_lookup(float phase);
  extern float c_frandom(float amp);
  extern void c_newline(void);
  extern void c_fft_window(float *rl, float *win, int size);
  extern void c_clear_block(float *rl, int size);
  extern double c_gcd(double a, double b);
  extern double c_lcm(double a, double b);
  extern float c_table_lookup (int *tbl, float *datar, float fm);
  extern float c_table_interp (float *fn, float x, int len);
  extern float c_direct_flt (int m, float input, float *flt_a, float *flt_b, float *flt_d);
  extern float c_lattice_flt (int m, float input, float *flt_a, float *flt_b, float *flt_d);
  extern float c_ladder_flt (int m, float input, float so, float *flt_a, float *flt_b, float *flt_c, float *flt_d);
  extern int c_y_or_n_p (void);
  extern int c_yes_or_no_p (void);
  extern void c_fft (float* rl, float* im, int n, int isign, int ipow);
  extern void c_convolve (char *fname, 
			  int filec, int filehdr, int filesize,
			  int filterc, int filterhdr, int filtersize,
			  int start, int fftsize, int ipow, int allpow, int samps, int fullsize, int chans, int chan);
  extern float c_env_restart (float *ef, int *ei, float *data);
  extern float c_run_block (int *blk, float *fblk, float *buf);
  extern void c_base_run_block (int *blk, float *fblk, float *buf);
  extern float c_src(int *rd, int *io, float *srf, int *sri, float *data, float *filt, float fm);
  extern float c_spd (int *rddat, int *spidat, float *spfdat, int *io, float *b);
  extern float c_fft_filter (int *rddat, int *io, int *runblk, float *fblk, int *fftdat,
			     float *runbuf, float *datar, float *datai, float *fenv);
  extern float c_readin (int *rd, int *io);
  extern void c_blti(int *arr0, int beg, int *arr1, int len);
  extern void c_bltf(float *arr0, int beg, float *arr1, int len);
  extern float c_convolve_or_readin (int *rddat, int *io, int *runblk, float *fblk, int *fftdat,
				     float *runbuf, float *datar, float *datai, float *filtr, float *filti);
  extern double jv_exp(double x);

#endif
