
;;;
;;; This is an example of using Common Music to play an
;;; instrument from Common Lisp Music.
;;;

(in-package 'common-music)

;;;
;;; First define the instrument, an FM violin in this case.
;;; I got the parameter lists from clm/ins.lisp, taking the list
;;; of keywords from the FM violin there and using it twice:
;;; Once as message parameters (after the "&message" word),
;;; and once as the slot-list (after "duration frequency amplitude").
;;;
#|
(defpart Simple-FM5 (clm-part) 
                    (name start-time duration frequency amplitude
			   &message C1-ratio M1-ratio C2-ratio M2-ratio index0 
index1-scl index2-scl index1-env index2-env amp1-env amp2-env index3-env 
index4-env amp3-env amp4-env at1-time at2-time dc-time degree distance 
reverb-amount )
( duration frequency amplitude
			   &message C1-ratio M1-ratio C2-ratio M2-ratio index0 
index1-scl index2-scl index1-env index2-env amp1-env amp2-env index3-env 
index4-env amp3-env amp4-env at1-time at2-time dc-time degree distance 
reverb-amount ))
|#
(defpart fm-violin (clm-part)
       (name time duration frequency amplitude
	     &message fm-index amp-env periodic-vibrato-rate 
	     random-vibrato-rate periodic-vibrato-amplitude
	     random-vibrato-amplitude noise-amount noise-freq 
	     gliss-env glissando-amount 
	     fm1-env fm2-env fm3-env fm1-rat fm2-rat fm3-rat
	     base reverb-amount noise-type index-type degree distance)
       (duration frequency amplitude
	fm-index amp-env periodic-vibrato-rate
	random-vibrato-rate periodic-vibrato-amplitude
	random-vibrato-amplitude noise-amount noise-freq 
	gliss-env glissando-amount 
	fm1-env fm2-env fm3-env fm1-rat fm2-rat fm3-rat
	base reverb-amount noise-type index-type degree distance))


;;;
;;; Make CM produce CLM scorefiles.
;;; This could also be done with the "type" option to defscorefile.
;;; If you don't do this, you'll get a message "Warning: MUSIC-KIT-SCOREFILE
;;; ignoring LOAD command. No applicable method."
;;;

(setf *default-scorefile-class* 'clm-scorefile)

;;;
;;; Here is an example that plays the violin.
;;; Two things to note:
;;;	- (after 'load) rather than (play t)
;;;	- the item-list of notes uses (pitches ...) rather than (notes ...).
;;;

(defscorefile (after 'load)
       (with-part fm-violin
	 (time 0 duration 0.2 amplitude 0.2)
	 (setf frequency (item (pitches c4 d e f g a b c5 d c b4 a g f e d c)
			       :kill t))
	 (setf time (+ time 0.3))
	 ))
