/* clmdsp.h: struct defs for various 56000 host interface memory maps */

#include <stdio.h>

typedef volatile struct _DSPRegs {
	unsigned char icr;
	unsigned char cvr;
	unsigned char isr;
	unsigned char ivr;
	union {
/*		unsigned int	receive;  */
/*		unsigned int	transmit; */
/* this worked on system 1.0 and system 2.0 with the 68030 but can't be used with the 68040 */
	        struct {
                        unsigned char   pad;
                        unsigned char   h;
                        unsigned char   m;
                        unsigned char   l;
                } rx;
                struct {
                        unsigned char   pad;
                        unsigned char   h;
                        unsigned char   m;
                        unsigned char   l;
                } tx;
	      } data;
      } DSPRegs;


/* QP DSP host-interface registers, as accessed in memory-mapped mode */
/* for the QP board, dsp regs are in byte 3 of each word -- this struct can't be used with the NeXT's DSP! */

typedef volatile struct _QPRegs {
	unsigned char icr_pad[3];
	unsigned char icr;	 
	unsigned char cvr_pad[3];
	unsigned char cvr;	 
	unsigned char isr_pad[3];
	unsigned char isr;	 
	unsigned char ivr_pad[3];
	unsigned char ivr;	 
	union {
	      unsigned int	receive;
	      unsigned int	transmit;
              } data;
      } QPRegs; 

/* in system 1.0, the structs were the same, so we needed only one set of access macros */
/* Some of these are called trillions of times, so we don't want to waste time deciding */
/* (at this level) which host interface type we are accessing (i.e. higher levels will */
/* have to keep track of this). */

DSPRegs *cpu_HI;
QPRegs *qp_HI;

#ifdef ARIEL_PC_56D 
  #define CPU_ICR dsp_getICR(current_active_dsp)
  #define CPU_CVR dsp_getCVR(current_active_dsp)
  #define CPU_ISR dsp_getISR(current_active_dsp)
  #define put_cpu_icr(x) dsp_putICR(current_active_dsp,x)
  #define put_cpu_cvr(x) dsp_putCVR(current_active_dsp,x)
#else
  #define CPU_ICR cpu_HI->icr
  #define CPU_CVR cpu_HI->cvr
  #define CPU_ISR cpu_HI->isr
  #define put_cpu_icr(x) CPU_ICR = x
  #define put_cpu_cvr(x) CPU_CVR = x
#endif


/* #define put_cpu_tx(x)  CPU_TX = x */
/* made a procedure and moved to next56.c (to avoid collision with qp.c) */

#define get_cpu_icr(x) *(x) = CPU_ICR
#define get_cpu_cvr(x) *(x) = CPU_CVR
#define get_cpu_isr(x) *(x) = CPU_ISR
/* #define get_cpu_rx(x)  *(x) = CPU_RX */

#define QP_ICR qp_HI->icr
#define QP_CVR qp_HI->cvr
#define QP_ISR qp_HI->isr
#define QP_TX qp_HI->data.transmit
#define QP_RX qp_HI->data.receive
#define put_qp_icr(x) QP_ICR = x
#define put_qp_cvr(x) QP_CVR = x
#define put_qp_tx(x)  QP_TX = x
#define get_qp_icr(x) *(x) = QP_ICR
#define get_qp_cvr(x) *(x) = QP_CVR
#define get_qp_isr(x) *(x) = QP_ISR
#define get_qp_rx(x) *(x) = QP_RX
                           
