;;; -*- syntax: common-lisp; package: clm; base: 10; mode: lisp -*-
;;;

(in-package :clm)

;;; C support procedures used here and in mus.lisp
;;; setting :arg-checking to nil here and in next56.c speeds up some cases by about 4% -- not enough to be worth it


(defvar *io-call-direct* t)
(defvar *io-check-args* nil)
(defvar *io-prototyped* t)   ; Should be nil only if C implementation is not

#+(and Excl Next) 
   (progn
     (ff:defforeign 'c-clear-array-1     :entry-point "_cleararray1"  :arguments '(fixnum fixnum fixnum) :return-type :void)
     (ff:defforeign 'c-normalize         :entry-point "_normarray"    :arguments '(fixnum array)         :return-type :void)
     (ff:defforeign 'c-load-one-sine-wave :entry-point "_load_one_sine" :prototype t
		    :arguments '(single-float single-float array fixnum single-float) :return-type :void)
     (ff:defforeign 'c-arrblt-1          :entry-point "_arrblt"       :arguments '(fixnum fixnum fixnum fixnum) :return-type :void)
     (ff:defforeign 'c-make-array        :entry-point "_makearray"    :arguments '(fixnum)               :return-type :integer)
     (ff:defforeign 'c-free-array        :entry-point "_freearray"    :arguments '(fixnum)               :return-type :void)
     (ff:defforeign 'c-setf-aref         :entry-point "_setarray"     :arguments '(fixnum fixnum fixnum) :return-type :integer)
     (ff:defforeign 'c-getf-aref         :entry-point "_getarray"     :arguments '(fixnum fixnum)        :return-type :integer)
     (ff:defforeign 'c-incf-aref         :entry-point "_incarray"     :arguments '(fixnum fixnum fixnum) :return-type :integer)
     (ff:defforeign 'c-close             :entry-point "_clm_close"    :arguments '(fixnum)               :return-type :void)
     (ff:defforeign 'c-open-input-file   :entry-point "_clm_open_read"      :arguments '(string)         :return-type :integer)
     (ff:defforeign 'c-open-output-file  :entry-point "_clm_open_write"     :arguments '(string)         :return-type :integer)

     (ff:defforeign 'c-open-clm-file-descriptors :entry-point "_open_clm_file_descriptors"
		    :arguments '(fixnum fixnum fixnum fixnum) :return-type :void)
     (ff:defforeign 'c-close-clm-file-descriptors :entry-point "_close_clm_file_descriptors" :arguments '(fixnum) :return-type :void)

     (ff:defforeign 'c-write-zeros       :entry-point "_cwritez"      :arguments '(fixnum fixnum)        :return-type :void)
     (ff:defforeign 'c-true-file-length  :entry-point "_clm_true_file_length"  :arguments '(string)               :return-type :integer)
     (ff:defforeign 'c-file-position     :entry-point "_clm_seek"     :arguments '(fixnum fixnum fixnum)      :return-type :integer)
     (ff:defforeign 'c-read-mono         :entry-point "_crdmono"      :arguments '(fixnum fixnum fixnum fixnum) :return-type :void)
     (ff:defforeign 'c-read-stereo       :entry-point "_crdstereo"    :arguments '(fixnum fixnum fixnum fixnum fixnum) :return-type :void)
     (ff:defforeign 'c-read-quad         :entry-point "_crdquad"      :arguments '(fixnum fixnum fixnum fixnum fixnum fixnum fixnum) 
		    :return-type :void)
     (ff:defforeign 'c-write-mono        :entry-point "_cwrtmono"     :arguments '(fixnum fixnum fixnum fixnum) :return-type :void)
     (ff:defforeign 'c-write-stereo      :entry-point "_cwrtstereo"   :arguments '(fixnum fixnum fixnum fixnum fixnum) :return-type :void)
     (ff:defforeign 'c-write-quad        :entry-point "_cwrtquad"     :arguments '(fixnum fixnum fixnum fixnum fixnum fixnum fixnum) 
		    :return-type :void)
     
     (ff:defforeign 'c-abs-max-array :entry-point "_absmaxarr" :arguments '(fixnum fixnum fixnum)  :return-type :integer)
     (ff:defforeign 'c-timed-abs-max-array :entry-point "_timedabsmaxarr" :arguments '(fixnum fixnum fixnum)  :return-type :integer)
     (ff:defforeign 'c-last-timed-max :entry-point "_get_last_time" :arguments nil :return-type :integer)
     
     ;; the next function added to support large convolutions
     (ff:defforeign 'c-convolve :entry-point "_c_convolve" 
		    :arguments '(string fixnum fixnum fixnum fixnum fixnum fixnum fixnum fixnum fixnum fixnum fixnum fixnum fixnum fixnum))
     (ff:defforeign 'c-fft :entry-point "_c_fft" :arguments '(array array fixnum fixnum fixnum))
     

     ;; for fast simple merges (merge.c and sound.lisp)

     (ff:defforeign 'c-mix-compatible-sounds :entry-point "_mix_compatible_sounds"
		    :arguments '(string fixnum string fixnum fixnum fixnum fixnum array) 
		    :return-type :integer)
     
     (ff:defforeign 'c-mix-mono-to-stereo-sounds :entry-point "_mix_mono_to_stereo_sounds" 
		    :arguments '(string fixnum string fixnum fixnum fixnum fixnum fixnum fixnum array) 
		    :return-type :integer) 

     (ff:defforeign 'c-mix-stereo-to-mono-sounds :entry-point "_mix_stereo_to_mono_sounds" 
		    :arguments '(string fixnum string fixnum fixnum fixnum fixnum fixnum fixnum fixnum array) 
		    :return-type :integer) 

     (ff:defforeign 'c-mix-stereo-to-stereo-sounds :entry-point "_mix_stereo_to_stereo_sounds" 
		    :arguments '(string fixnum string fixnum fixnum fixnum fixnum fixnum fixnum) 
		    :return-type :integer) 

     (ff:defforeign 'c-mix-quad-to-quad-sounds :entry-point "_mix_quad_to_quad_sounds" 
		    :arguments '(string fixnum string fixnum fixnum fixnum fixnum fixnum fixnum fixnum fixnum array) 
		    :return-type :integer) 

     )

#+(and Excl SGI) 
(ff:defforeign-list 
 `((c-clear-array-1     :entry-point  "cleararray1"  
			:arguments    (integer integer integer) 
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-normalize         :entry-point  "normarray"    
			:arguments    (integer array)         
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-load-one-sine-wave :entry-point  "load_one_sine" :prototype t
			 :arguments    (single-float single-float array integer single-float) 
			 :return-type  :void
			 :call-direct  ,*io-call-direct*
			 :arg-checking ,*io-check-args*
			 :callback nil
			 :prototype    ,*io-prototyped*)
   (c-arrblt-1          :entry-point  "arrblt"       
			:arguments    (integer integer integer integer) 
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)			     
   (c-make-array        :entry-point  "makearray"    
			:arguments    (integer)               
			:return-type  :integer
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)	
   (c-free-array        :entry-point  "freearray"    
			:arguments    (integer)               
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)	
   (c-setf-aref         :entry-point  "setarray"     
			:arguments    (integer integer integer) 
			:return-type  :integer
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)				     
   (c-getf-aref         :entry-point  "getarray"     
			:arguments    (integer integer)        
			:return-type  :integer
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-incf-aref         :entry-point  "incarray"     
			:arguments    (integer integer integer) 
			:return-type  :integer
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-close             :entry-point  "clm_close"       
			:arguments    (integer)               
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-open-input-file   :entry-point  "clm_open_read"      
			:arguments    (string)               
			:return-type  :integer
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-open-output-file  :entry-point  "clm_open_write"     
			:arguments    (string)               
			:return-type  :integer
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-open-clm-file-descriptors :entry-point "open_clm_file_descriptors"
		    :arguments (fixnum fixnum fixnum fixnum) 
		    :return-type :void
		    :call-direct  ,*io-call-direct*
		    :arg-checking ,*io-check-args*
		    :callback nil
		    :prototype    ,*io-prototyped*)
   (c-close-clm-file-descriptors :entry-point "close_clm_file_descriptors" 
				 :arguments (fixnum) 
				 :return-type :void
				 :call-direct  ,*io-call-direct*
				 :arg-checking ,*io-check-args*
				 :callback nil
				 :prototype    ,*io-prototyped*)
   (c-write-zeros       :entry-point  "cwritez"      
			:arguments    (integer integer)        
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:prototype    ,*io-prototyped*)
   (c-true-file-length  :entry-point  "clm_true_file_length"  
			:arguments    (string)               
			:return-type  :integer
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-file-position     :entry-point  "clm_seek"
			:arguments    (integer integer integer)        
			:return-type  :integer
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-read-mono         :entry-point  "crdmono"      
			:arguments    (integer integer integer integer) 
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-read-stereo       :entry-point  "crdstereo"    
			:arguments    (integer integer integer integer integer) 
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-read-quad         :entry-point  "crdquad"      
			:arguments    (integer integer integer integer integer integer integer) 
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:callback nil
			:prototype    ,*io-prototyped*)
   (c-write-mono        :entry-point  "cwrtmono"     
			:arguments    (integer integer integer integer) 
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:prototype    ,*io-prototyped*)
   (c-write-stereo      :entry-point  "cwrtstereo"   
			:arguments    (integer integer integer integer integer) 
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:prototype    ,*io-prototyped*)
   (c-write-quad        :entry-point  "cwrtquad"     
			:arguments    (integer integer integer integer integer integer integer) 
			:return-type  :void
			:call-direct  ,*io-call-direct*
			:arg-checking ,*io-check-args*
			:prototype    ,*io-prototyped*)
   (c-abs-max-array :entry-point  "absmaxarr" 
		    :arguments    (integer integer integer)  
		    :return-type  :integer
		    :call-direct  ,*io-call-direct*
		    :arg-checking ,*io-check-args*
		    :callback nil
		    :prototype    ,*io-prototyped*)
   (c-timed-abs-max-array :entry-point  "timedabsmaxarr" 
			  :arguments    (integer integer integer)  
			  :return-type  :integer
			  :call-direct  ,*io-call-direct*
			  :arg-checking ,*io-check-args*
			  :callback nil
			  :prototype    ,*io-prototyped*)
   (c-last-timed-max :entry-point  "get_last_time" 
		     :arguments    nil 
		     :return-type  :integer
		     :call-direct  ,*io-call-direct*
		     :arg-checking ,*io-check-args*
		     :callback nil
		     :prototype    ,*io-prototyped*)

   ;; the next function added to support large convolutions
   (c-convolve :entry-point  "c_convolve" 
	       :arguments    (string 
			      integer integer integer 
			      integer integer integer 
			      integer integer integer integer integer integer integer integer)
	       :call-direct  ,*fft-call-direct*
	       :arg-checking ,*fft-check-args*
	       :prototype    ,*fft-prototyped*)
   (c-fft :entry-point  "c_fft" 
	  :arguments    (array array fixnum fixnum fixnum)
	  :call-direct  ,*fft-call-direct*
	  :arg-checking ,*fft-check-args*
	  :prototype    ,*fft-prototyped*)


   ;; for fast simple merges (merge.c and sound.lisp)

   (c-mix-compatible-sounds :entry-point  "mix_compatible_sounds"
			    :arguments    (string integer string integer integer integer integer array) 
			    :return-type  :integer
			    :call-direct  ,*merge-call-direct*
			    :arg-checking ,*merge-check-args*
			    :prototype    ,*merge-prototyped*)

   (c-mix-mono-to-stereo-sounds :entry-point  "mix_mono_to_stereo_sounds" 
				:arguments    (string integer string integer integer integer integer integer integer array) 
				:return-type  :integer
				:call-direct  ,*merge-call-direct*
				:arg-checking ,*merge-check-args*
				:prototype    ,*merge-prototyped*)

   (c-mix-stereo-to-mono-sounds :entry-point  "mix_stereo_to_mono_sounds" 
				:arguments    (string integer string integer integer integer integer integer integer integer array) 
				:return-type  :integer
				:call-direct  ,*merge-call-direct*
				:arg-checking ,*merge-check-args*
				:prototype    ,*merge-prototyped*)

   (c-mix-stereo-to-stereo-sounds :entry-point  "mix_stereo_to_stereo_sounds" 
				  :arguments    (string integer string integer integer integer integer integer integer) 
				  :return-type  :integer
				  :call-direct  ,*merge-call-direct*
				  :arg-checking ,*merge-check-args*
				  :prototype    ,*merge-prototyped*)

   (c-mix-quad-to-quad-sounds :entry-point  "mix_quad_to_quad_sounds" 
			      :arguments    (string integer string integer integer integer integer integer integer integer integer array) 
			      :return-type  :integer
			      :call-direct  ,*merge-call-direct*
			      :arg-checking ,*merge-check-args*
			      :prototype    ,*merge-prototyped*)


   ))



;;; Mac stuff is complicated -- macintosh-io.lisp
;;; KCL stuff requires derefencing -- see kcl-clm.lisp
