
functor TreeSetTable(structure Key : COMPARE and Value : ELEMENT) : TABLE =
struct
	structure Key = Key
	structure Value = Value
	
	structure Pair =
	    struct
		datatype value = Bottom | Some of Value.element

		type element = Key.element * value
		
		fun put _ (_,Bottom) = ()
		  | put os (k,Some v) = 
		    (Key.put os k;
		     output(os,"=");
		     Value.put os v)
                
		local open Pretty 
		in
		    fun format (_,Bottom) = string "()" 
		      | format (k,Some v) = 
			     block(!indent,
				   [string "(", 
				    Key.format k,
				    string " . ",
				    Value.format v,
				    string ")"])
		end
		    
	        datatype relation = Equal | Less | Greater | None

		fun compare (k1,_) (k2,_) = 
		    case Key.compare k1 k2 of
			Key.Equal => Equal
		      | Key.Less => Less
		      | Key.Greater => Greater
		      | Key.None => None;
	       
		fun eq p1 p2 = 
		    compare p1 p2 = Equal
	    end
	    
	structure S = TreeSet(Pair);
	
	open S

      	type table = set ref

	exception Get
	  
	fun table () = ref empty_set;
	
        fun get tbl ky =
	    let val (ky1,Pair.Some val1) = S.get (ky,Pair.Bottom) (!tbl)
	    in
		val1
	    end handle S.Compare => raise Get

	fun put t k v =
	    t := add (k,Pair.Some v) (!t)

	fun copy t = ref (!t)

	fun put_table os t = put_set os (!t)
	
	fun reduce f i t = 
	    let fun f1 (e, Pair.Bottom) x = x 
		  | f1 (e, Pair.Some p) x = f (e,p) x 
	    in 
		S.reduce f1 i (!t)
	    end

        fun format t  = S.format (!t)
end;
