
(* Author: Tom Gordon;   this version includes memoization *)

functor Stream () : STREAM =
    struct

	abstype 'a stream = mkstr of 'a str ref
	and      'a str =  empty 
	  |  cons of 'a * 'a stream 
	  |  dly of (unit -> 'a stream)

	with

	    fun eval (mkstr(sr as (ref (dly f)))) : 'a str  =
		let val s = f() 
		in 
		    case s of
			(mkstr (ref (dly f1))) => sr := eval s
		      | (mkstr (ref s1)) => sr := s1;
			    !sr 
		end
	      | eval (mkstr (ref s)) = s

	    fun empty_stream () = mkstr (ref empty)

	    fun singleton e = mkstr (ref (cons (e, mkstr(ref empty))))
	    fun stream (e,s) = mkstr (ref (cons (e, s)))
	    fun delay f = mkstr (ref (dly f))

	    fun eos (mkstr (ref empty)) = true
	      | eos (mkstr (ref (cons _)))  = false
	      | eos s = (eval s;  eos s)

	    exception EmptyStream

	    fun next (mkstr (ref empty)) = raise EmptyStream
	      | next (mkstr (ref (cons (h,t)))) = (h,t)
	      | next (s as (mkstr (ref (dly f)))) = (eval s; next s)

	    fun head s = #1 (next s)
	    fun tail s = #2 (next s)

	    fun list2stream [] = mkstr (ref empty)
	      | list2stream (h::t) = stream(h,list2stream t)
       
	    fun stream2list (mkstr (ref empty)) = []
	      | stream2list (mkstr (ref (cons (h,t)))) = h::(stream2list t)
	      | stream2list (s as (mkstr (ref (dly _)))) = 
		(eval s; stream2list s)
     
	    fun append (str1, str2) =
		if eos str1 then
		    str2
		else
		    stream (head str1, delay (fn () => 
					      append (tail str1, str2)))

    
	    fun interleave (str1, str2) =
		if eos str1 then
		    str2
		else
		    stream (head str1, 
			    delay (fn () => interleave(str2, (tail str1))))
	
	    fun accumulate f initial str =
		if eos str then
		    initial
		else
		    f (head str, accumulate f initial (tail str))

	    fun flatten s =
		accumulate append (mkstr (ref empty)) s

	    fun map (f : 'a -> '2b) (s : 'a stream) : '2b stream =
		if eos s then
		    mkstr (ref empty)
		else
		    stream (f (head s), delay (fn () => map f (tail s)))

	    (* filter continues evaluating the stream until the 
	     first element satisfying the predicate is found *)

	    fun filter pred s = 
		if eos s then
		    s
		else
		    let val (head,tail) = next s
		    in
			if pred head then
			    stream (head, delay (fn () => filter pred tail))
			else
			    filter pred tail
		    end

	    fun flatmap f str = flatten (map f str)
	end
    end;
