

(*
import "../EQ/EQ";
*)

signature SET =
sig
        structure E : EQ
	
	type element
	sharing type element = E.element

        type set;
        val empty_set : set
        val set       : element list -> set
        val singleton : element -> set
        val empty  : set -> bool
        val member : element -> set -> bool
        val subset : set -> set -> bool
        val eqsets : set -> set -> bool
        exception Choose
        val choose       : set -> (element * set) 
        val union        : set -> set -> set
        val intersection : set -> set -> set

        val difference   : set -> set -> set
        val add          : element -> set -> set
        val remove       : element -> set -> set
        val size         : set -> int

        val filter       : (element -> bool) -> set -> set
        val reduce       : (element -> 'a -> 'a) -> 'a -> set -> 'a
  
       	val put_set      : outstream -> set -> unit 
       	val format       : set -> Pretty.block
end
