
signature RMS =
    sig
	structure D : DATUM
	structure E : SET
	structure S : STREAM

	type datum
	type environment

	sharing type datum = D.element = E.E.element
	    and type environment = E.set

	val env : datum list -> environment
	val justify : environment -> datum -> unit
	val assume : datum -> unit
	val presume : datum -> unit

        val reset : unit -> unit

	val derivable : environment -> datum -> bool
	val inconsistent : environment -> bool
	val nogoods : unit -> environment S.stream
	val supports : datum -> environment S.stream
    end
    

    
