
(* 

ParserGen structure.

A generator for recursive descent parsers.  Parsers made with this
structure parse streams of tokens generated using the TokenStream
structure.  The tokens are just those needed for Scheme S-expressions,
with the exception of floating point numbers. 

The structure is based on Paulson's functor on page 324 of ML for
the Working Programmer.  Changes were necessary to parse streams of
S-expression tokens, rather than lists of tokens of the kind Paulson
used.  The implementation has been simplified somewhat, by omitting
several functions I don't require: $, id, and infixes.

infix 5 --;
infix 3 >>;
infix 0 ||;

*)

structure Parser : PARSER =
  struct
      structure L = Lex
      open L

      infix 5 --;
      infix 3 >>;
      infix 0 ||;

      exception SyntaxError of string;

      (* Application of f to the result of a phrase *)

      fun (ph>>f) toks = 
	  let val (x,toks2) = ph toks
	  in  
	      (f x, toks2)  
	  end;

      (*Alternative phrases*)

      fun (ph1 || ph2) toks = 
	  ph1 toks handle SyntaxError _ => ph2 toks;

      (*Consecutive phrases*)

      fun (ph1 -- ph2) toks = 
	  let val (x,toks2) = ph1 toks
	      val (y,toks3) = ph2 toks2
	  in  
	      ((x,y), toks3)  
	  end;

      fun empty toks = ([],toks);

      (*Zero or more phrases*)
		      
      fun repeat ph toks = 
	  (   ph -- repeat ph >> (op::)
	      || empty   ) toks;

      (*Scan and parse, checking that no tokens remain*)

      fun reader ph (s : instream) = 
	  let val (x, rest) = ph (lex s)
	  in
	      if S.eos rest then
		  x
	      else
		  raise SyntaxError "Extra characters in phrase"
	  end

  end;

  
