
functor ListSet (E : EQ) :SET =  
    struct 
	structure E = E;
	    
	type element = E.element
	type set = element list;

	exception Choose;
				
	val empty_set :set = [];
	    	
	fun singleton x = 
	    [x] :set;
	
	fun add (e :E.element) (h::t :set) =
	    if E.eq e h then
		h::t
	    else
		h::(add e t)
	  | add (e) ([]) =
	    [e];

	fun set [] = empty_set
	  | set (h::t) = add h (set t)

	fun empty ([] :set) = 
	    true
	  | empty _ = 
	    false;
	fun member (x) (h::t :set) = 
	    if E.eq x h then 
		true 
	    else 
		member x t 
	  | member (x) ([]) = 
	    false;
	fun subset ([] :set) (_ :set) = 
	    true 
	  | subset (h::t) (s2) = 
	    member h s2 andalso subset t s2;
	fun eqsets (s1) (s2) = 
	    subset s1 s2 andalso subset s2 s1;
	fun union ([]) (s2) :set =
	    s2 
	  | union (h::t)( s2) = 
	    if member h s2 then
		union t s2
	    else
		h::(union t s2);
	fun intersection ([]) (s2) :set =
	    []
	  | intersection (h::t) (s2) = 
	    if member h s2 then
		h::(intersection t s2)
	    else
		intersection t s2;
	fun difference ([]) (s2) :set = 
	    []
	  | difference (h::t) (s2) =
	    if member h s2 then
		difference t s2
	    else
		h::(difference t s2);
	fun choose (h::t :set) :E.element * set = 
	    (h,t)
	  | choose ([]) = 
	    raise Choose;
	fun remove (e :E.element) (h::t :set) :set =
	    if E.eq e h then
		t
	    else 
		h::(remove e t)
	  | remove (_) ([]) =
	    [];
	fun filter (f :E.element ->bool) :set->set =
	    let 
		fun ff (s :set) =
		    if empty s then
			s
		    else
			let
			    val (first, rest) = choose s
			in
			    if f first then
				add first (ff rest)
			    else
				ff rest
			end
	    in
		fn (s) =>
		    ff s
	    end;
	fun reduce (f :E.element -> 'b -> 'b) (default :'b) (s :set) =

	    let
		fun iter ([]) (d) =
		    d
		  | iter (h::t) (d) =
		    iter t (f h d)
	    in
		iter s default
	    end;

	fun size [] = 0
    	 |  size (h::t) = 1+(size t)

	fun put_set os s =
		let fun put [] = ()
                      | put [x] = E.put os x
                      | put (h::t) = 
                           (E.put os h;  put t)
                in
		    put s	
		end

	local open Pretty 
	in
	    fun format [x] = block (!indent, 
				    [string "(", E.format x, string ")"])
	      | format l =
		let fun f [last] = [E.format last, string ")"]
		      | f (h::t) = (E.format h)::(break 1)::(f t)
		in
		    case l of
			[] => string "()"
		      | _  => block(1, (string "("::(f l)))
		end
	end
    end;
