
(* tokenStream generates a stream of S-expression tokens. *)

structure Lex : LEX =
struct
    structure L = SexpLex
    structure S = Stream ()
    
    open SexpLex.UserDeclarations

    fun lex (s : instream) : token S.stream =
	let val lexer = L.makeLexer (fn n => IO.input_line s)
	    fun generate () = 
		let val token = lexer()
		in
			case token of
			    EOF => S.empty_stream () 
			  | _ => S.stream(token, 
					  S.delay (fn () => generate ()))
		end
	in
	    generate ()
	end
end
