
(* An easy implementation of tables using association lists. *) 

(*
import "../EQ/EQ";
import "../TABLE/TABLE"; 
*)

functor AList(structure Key : EQ and Value : ELEMENT) : TABLE  =
struct
	structure Key = Key
	structure Value = Value

      	datatype table = alist of (Key.element * Value.element) list ref

	exception Get
	  
	fun table () = alist(ref [])
	  
	fun get (alist(ref list)) key1 =
		let fun get1(key1, []) = raise Get
		      | get1(key1, (key2,object)::tail) =
				if (Key.eq key1 key2) then
					object
				else
					get1(key1,tail)
		in
			get1(key1,list)
		end
			
	  
	  (* In this implementation, the new (key,object) pair is just
	  consed onto the front of the list, effectively shadowing any
	  other object with the same key. Thus, the put operation is
	  fast, but the table will contain "garbage" that will not
	  be collected if the object associated with some key is
	  replaced. This also slows down the get operation when the
	  searched for is not in the table. *)
		 
	fun put (alist(listref)) key object =
	  	(listref := (key,object)::(!listref); 
         	 ())

	(* copy:  copies the table, but not the elements of the table.
	If the elements contain references, changes to the elements of the
	original will also change the elements of the copy. *)

	fun copy (alist (ref l)) = alist (ref l)

	(* The key, value pairs are not printed, as the table may
	include "garbage" in the case of duplicate entries. *)
	
	fun reduce _ i (alist (ref [])) = i
	  | reduce f i (alist (ref l)) =
	    let fun loop _ i [] = i 
		  | loop keys i ((e as (k1,v))::t) =
		    if List.exists (fn k2 => Key.eq k2 k1) keys then
			(* already visited, ignore *)
			loop keys i t 
		    else
			loop keys (f e i) t
	    in
		loop [] i l
	    end

	fun put_table os tbl = output(os, "<table>")
        fun format _ = Pretty.string "<table>"			
end;
