#include  "defns.i"
#include  "extern.i"
float LitBits;

	/*  Examine bindings on relation R; check the best against the
	    best so far  */

    CheckRelation(R, Tries, NRelns)
/*  -------------  */
    Relation R;
    int NRelns, Tries;

{
    long clock();

    /* Coding Cost - Equality with Theory Constant considered as though
       part of Equality relation */

    if(UNIFORMCODING)
    {
        LitBits = CostOfLit(1,RelnArgPairs,NLit);
    }
    else if(R==SAMEVAR || R->ConstantCmp)
    {
        LitBits = CostOfLit(NRelns,EqualityRelnArgs,NLit);
    }
    else
    {
        LitBits = CostOfLit(NRelns,Tries,NLit);
    }

    if ( LitBits > AvailableBits )
    {
	VERBOSE(1)
	    printf("\tliterals using %s require %.1f bits\n", R->Name,LitBits);

	return;
    }

    Tried = 0;

    /* Try the different possible argument lists, computing the gain for viable
       argument lists - using simplified argument checking if the relation
       is binary symmetric or CONTGT */

    if ( R->BinSym )
    {
	BinSymArgs(R);
    }
    else if( R==CONTGT )
    {
        GTArgs();
    }
    else
    {
        TryArgs(1, MaxVar, 0, 0, false, R, 0);
    }

    VERBOSE(1)
    {
	printf("\t\t\t\t[%s tried %d / %d, %.1f secs]\n",
		R->Name, Tried, Tries, clock() / 1.0E6);
    }
}


/*****************************************************************************/
/*                                                                           */
/*  BinSymArgs(R) - simplified form of checking of the argument list for the */
/*                  case of a binary symmetric relation. Arguments are       */
/*                  worth trying in ComputeGain if types are compatible,     */
/*                  unless this is the target relation and no partial order  */
/*                  has been established for the first argument. In the      */
/*                  special case of the equality relation, the checking for  */
/*                  a variable equalling itself, or an unbound variable, is  */
/*                  not performed.                                           */
/*                                                                           */
/*****************************************************************************/

    BinSymArgs(R)
/*  ------------  */
Relation R;

{
    int NewVars;

    NewVars = (MaxVar >= MAXARITY - 1) ? 0 : 1 ;
    for ( ArgList[1] = 1 ;
          ( ArgList[1] < MaxVar + ( R == SAMEVAR ? 0 : NewVars ) )
              && BestLitGain < MaxPossibleGain ;
	  ArgList[1]++ )
    {
        if ( (Variable[ArgList[1]]->OriginalVar) ||
             (R==Target && !OrderBetween(ArgList[1],1)) ||
             (R!=SAMEVAR&& !Compatible[Variable[ArgList[1]]->Type]
                                      [R->Type[1]]) ||
	     (R==SAMEVAR&& Variable[ArgList[1]]->Continuous) )
            continue;

	for ( ArgList[2] = ArgList[1] + ( R == SAMEVAR ? 1 : 0 ) ;
             ( ArgList[2] <= MaxVar + ( R == SAMEVAR ? 0 : NewVars ) )
             && BestLitGain < MaxPossibleGain ;
	     ArgList[2]++ )
	{
            if ( R != SAMEVAR && ArgList[2] > MaxVar )
	    {
                Variable[ArgList[2]]->Type = R->Type[2];
                Variable[ArgList[2]]->TypeRef = R->TypeRef[2];
	    }
	    if ( !Variable[ArgList[2]]->OriginalVar
		 && Compatible[Variable[ArgList[1]]->Type]
                              [Variable[ArgList[2]]->Type] )
	    {
	        if( (R!=Target) || RecursiveCallOK(ArgList) )
		{
		    ComputeGain(R, ArgList, LitBits, true);
		    Tried++;
		}
	    }
	}
    }
}

/*****************************************************************************/
/*                                                                           */
/*  GTArgs(): Simplified form of trying the argument lists, for the greater  */
/*            than relationship.                                             */
/*                                                                           */
/*****************************************************************************/

    GTArgs()
/*  ------  */

{
    for ( ArgList[1] = 1 ;
          ( ArgList[1] < MaxVar )
              && BestLitGain < MaxPossibleGain ;
          ArgList[1]++ )
    {

        if( !Variable[ArgList[1]]->Continuous )
            continue;

        for ( ArgList[2] = ArgList[1]+1;
             ( ArgList[2] <= MaxVar )
             && BestLitGain < MaxPossibleGain ;
             ArgList[2]++ )
	{
            if ( Variable[ArgList[1]]->Type == Variable[ArgList[2]]->Type )
	    {
                ComputeGain(CONTGT, ArgList, LitBits, true);
                Tried++;
	    }
	}
    }
}


    /*  Examine possible argument lists for relation R.
	Any such list must select at least one case in the
	training set.  */

    TryArgs(This, HiVar, FreeVars, MaxDepth, SomePartOrd, R, Key)
/*  -------  */
    int This, HiVar, FreeVars, MaxDepth, Key;
    Boolean SomePartOrd;
    Relation R;
{
    Var V, VMax;
    Boolean Free, NewFree;
    int count;

    VMax = (HiVar >= MAXARITY - ExtraUnboundVars) 
                                        ? MAXARITY : HiVar + ExtraUnboundVars ;

    for ( V = 1 ; V <= VMax && BestLitGain < MaxPossibleGain ; V++ )
    {
	Free = V > MaxVar;

	if ( NewFree = V > HiVar )
	{
	    if ( MaxDepth >= MAXVARDEPTH ) return;
	    Key |= (1 << This);
	    if ( IllegalKey(Key, R) ) return;
	    HiVar = V;
	    Variable[V]->Type = R->Type[This];
            Variable[V]->TypeRef = R->TypeRef[This];
	}
	else
	if ( ! Free && Variable[V]->Depth + (FreeVars > 0) > MAXVARDEPTH ||
	     ! Compatible[Variable[V]->Type][R->Type[This]] ||
	       Variable[V]->OriginalVar ||
	       R->TypeRef[This]->Continuous)

	{
	    continue;
	}

	ArgList[This] = V;

	if ( This < R->Arity )
	{
	    if ( NewFree  /* V unconstrained */  ||
		 PossibleGain(This, R, HiVar) )
	    {
		TryArgs(This+1, HiVar,
			FreeVars + Free,
			Free || Variable[V]->Depth <= MaxDepth ? 
                                                 MaxDepth : Variable[V]->Depth,
			(Boolean) (SomePartOrd 
                                   || ! NewFree && OrderBetween(V,This)),
			R, Key);
	    }
	}
	else
	if ( FreeVars + Free < R->Arity &&
	     ( R != Target || SomePartOrd 
                           || ! NewFree && OrderBetween(V,This) ) )
	{
	    if( (R!=Target) || RecursiveCallOK(ArgList) )
	    {
		ComputeGain(R, ArgList, LitBits, true);
		Tried++;
	    }
	}
    }
}



Boolean PossibleGain(This, R, HiVar)
/*    ------------  */
    int This, HiVar;
    Relation R;
{
    int i, Neg, YesPos = 0, YesNeg = 0, NoPos = 0, NoNeg = 0;
    float MinUsefulGain, YesPosThresh, NoNegThresh;
    Boolean RuleOutYes, RuleOutNo;
    Tuple *Scan;

    RuleOutYes = false;
    RuleOutNo  = ! NEGLITERALS;

    /*  Maximum possible gain:
	    Yes:	exclude all but existing YesPos positive cases
	    No:		exclude only YesPos positive cases  */

    Neg = Tot - Pos;

    /*  The minimum gain that would be of interest is just enough to give
	a literal a chance to be saved by the backup procedure or, if
	there are determinate literals, to reach the required fraction
	of the maximum possible gain  */

    MinUsefulGain = NPossible < MAXPOSSLIT ? MINALTFRAC * BestLitGain :
 		     Max(Possible[MAXPOSSLIT]->Gain, MINALTFRAC * BestLitGain);

    if ( NDeterminate && MinUsefulGain < DETERMINATE * MaxPossibleGain )
    {
	MinUsefulGain = DETERMINATE * MaxPossibleGain;
    }

    YesPosThresh = MinUsefulGain / BaseInfo - 0.001;
    NoNegThresh = (Pos + 1) * (pow(2.0, BaseInfo - MinUsefulGain / Pos) - 1) 
                   + 0.001;

    ForEach(i, This+1, R->Arity)
    {
	ArgList[i] = HiVar + i - This;
    }

    for ( Scan = TrainingSet + Tot - 1 ; Scan >= TrainingSet ; Scan-- )
    {
	if ( Join(R->Pos, R->PosIndex, ArgList, *Scan, R->Arity, true) )
	{
	    if ( Positive(*Scan) )
	    {
		if ( ++YesPos >= YesPosThresh ) return true;
	    }
	    else
	    {
		if ( Neg - (++YesNeg) < NoNegThresh ) return true;
	    }
	}
	else
	{
	    if ( Positive(*Scan) )
	    {
		if ( Pos - (++NoPos) < YesPosThresh && ! RuleOutYes )
		{
		    RuleOutYes = true;
		    if ( RuleOutNo ) break;
		}
	    }
	    else
	    {
		if ( ++NoNeg > NoNegThresh && ! RuleOutNo )
		{
		    RuleOutNo = true;
		    if ( RuleOutYes ) break;
		}
	    }
	}
    }

    VERBOSE(2)
    {
	ForEach(i, This+1, R->Arity)
	{
	    ArgList[i] = 0;
	}

	printf("\t");
	PrintLiteral(R, true, ArgList);
	printf("\tTrue [%d,%d], False [%d,%d]: gain below threshold\n",
		YesPos, YesPos+YesNeg, NoPos, NoPos+NoNeg);
    }

    return false;
}



    /*  Count possible argument lists for relation R.  */

int NumberArgLists(This, HiVar, AllFree, R, Key)
/*  --------------  */
    int This, HiVar, Key;
    Boolean AllFree;
    Relation R;
{
    int V, V1, VMax, PossibleArgs = 0;
    Boolean Free;

    if ( R->BinSym )
    {
        VMax = (R==SAMEVAR) ? MaxVar :
                ((MaxVar >= MAXARITY - 1) ? MAXARITY : MaxVar + 1) ;
	for ( V = 1 ; V < VMax ; V++ )
        {
	    if( Variable[V]->OriginalVar ||
                (R==SAMEVAR && Variable[V]->Continuous)  ||
                (R!=SAMEVAR && !Compatible[Variable[V]->Type][R->Type[1]]) )
                continue;
	    for ( V1 = V + ( R == SAMEVAR ? 1 : 0 ) ; ( V1 <= VMax ) ; V1++ )
	    {
	        if ( R != SAMEVAR && V1 > MaxVar )
		{
                    Variable[V1]->Type = R->Type[2];
		    Variable[V1]->TypeRef = R->TypeRef[2];
		}
		if ( !Variable[V1]->OriginalVar
		    && Compatible[Variable[V]->Type]
                                 [Variable[V1]->Type] ) PossibleArgs++;
	    }
        }
    }
    else if (R==CONTGT)
    {
        for ( V = 1; V<MaxVar ; V++ )
	{
	    if(!Variable[V]->Continuous) continue;
	    for ( V1 = V+1 ; V1 <= MaxVar ; V1++)
	    {
	        if( Variable[V]->Type==Variable[V1]->Type )
		    PossibleArgs++;
	    }
	}
    }
    else
    {
        VMax = (HiVar >= MAXARITY - ExtraUnboundVars) 
                                        ? MAXARITY : HiVar + ExtraUnboundVars ;

	for ( V = 1 ; V <= VMax ; V++ )
	{
	    if ( V > HiVar )
	    {
		Key |= (1 << This);
		if ( IllegalKey(Key, R) ) continue;

		Variable[V]->Type = R->Type[This];
                Variable[V]->TypeRef = R->TypeRef[This];
	    }
	    else
	    if ( Variable[V]->OriginalVar ||
                 ! Compatible[Variable[V]->Type][R->Type[This]] ||
		   R->TypeRef[This]->Continuous)
	    {
		continue;
	    }

	    Free = V > MaxVar;
	    ArgList[This] = V;
	    HiVar = Max(HiVar, V);

	    if ( This < R->Arity )
	    {
		PossibleArgs += 
                        NumberArgLists(This+1, HiVar, AllFree && Free, R, Key);
	    }
	    else
	    {
		if ( ! Free || ! AllFree ) PossibleArgs++;
	    }
	}
    }

    return PossibleArgs;
}


	/*  Determine whether a partial key matches one of
	    the defined keys for this relation.  */

Boolean IllegalKey(Key, R)
/*      ----------  */
    int Key;
    Relation R;
{
    int i;

    if ( ! R->NKeys ) return false;

    ForEach(i, 0, R->NKeys-1)
    {
	if ( (R->Key[i] | Key) == R->Key[i] ) return false;
    }

    return true;
}
