#include  "defns.i"
#include  "extern.i"


	/*  Construct the index for a set of tuples  */

Index MakeIndex(T, N)
/*    ---------  */
    Tuple *T;
    int N;
{
    Index IX;
    Tuple Case, *Scan;
    int **Next, Size, Arg, Val, No = 0;

    /*  Allocate storage  */

    IX = (int ***) malloc((N+1) * sizeof(int **));
    Next = (int **) malloc((N+1) * sizeof(int *));

    ForEach(Arg, 1, N)
    {
	IX[Arg] = (int **) malloc((MaxConst+1) * sizeof(int *));
	Next[Arg] = (int *) malloc((MaxConst+1) * sizeof(int));
    }

    for ( Scan = T ; Case = *Scan++ ; )
    {
	ForEach(Arg, 1, N)
	{
	    Next[Arg][Case[Arg]]++;
	}
    }

    ForEach(Arg, 1, N)
    {
	ForEach(Val, 1, MaxConst)
	{
	    IX[Arg][Val] = Next[Arg][Val] ? (int *) malloc((Next[Arg][Val]+1) * sizeof(int)) : Nil;
	    Next[Arg][Val] = 0;
	}
    }

    /*  Construct the index  */

    for ( Scan = T ; *Scan ; Scan++ )
    {
	ForEach(Arg, 1, N)
	{
	    Val = (*Scan)[Arg];
	    IX[Arg][Val][Next[Arg][Val]++] = No;
	}

	No++;
    }

    /*  Terminate index and free Next  */

    ForEach(Arg, 1, N)
    {
	ForEach(Val, 1, MaxConst)
	{
	    if ( IX[Arg][Val] )
	    {
		IX[Arg][Val][Next[Arg][Val]] = FINISH;
	    }
	}
	free(Next[Arg]);
    }
    free(Next);

    return IX;
}
