#include <math.h>
#include <stdio.h>

#define  MAXARITY	 52
#define	 MAXTYPES	200
#define  MAXRELS	100
#define  MAXCLS		 50
#define  MAXLITS	 50
#define  MAXTUPLES   100000
#define  PATIENCE	  3
#define  FINISH	   10000000	/* a large constant used as a terminator */

#define	 MAXPAIRS		(MAXARITY * (MAXARITY-1)) / 2


				/*  Switches controlling FOIL's behaviour  */

#define	 TYPEFILTER   true	/*  When producing training set under closed-world,
				    require - tuples to obey type constraints  */
#define	 USEOPT      false	/*  Undefined tuples treated conservatively  */


#define Resize(P,N) ( ((int) P) ? realloc(P,N) : malloc(N) )


typedef	char	Var,
		*Vars,
		Boolean;

				/*  A tuple is stored as an array of integers.
				    T[0] = tuple number (plus tuples), 0 otherwise.
				    T[i] = constant number  */

typedef  int	Const,
		*Tuple,
		**Tuples;


				/*  Relations are indexed by a three-dimensional array.
				    I[i][j][k] = index of kth tuple with T[j] = i
				    Last one is followed by FINISH  */

typedef  int	***Index;


typedef  struct _rel_rec	*Relation;

typedef	 struct _type_rec	*TypeInfo;

typedef  struct _lit_rec	*Literal,
				**Clause;	/* clause is array of literals  */

typedef	 struct _poss_lit_rec	*PossibleLiteral;

typedef  struct _backup_rec	*Alternative;

typedef  struct _lit_rec
	{	Boolean		Sign;		/* false = negated */
		Relation	Rel;
		Vars		Args;
		float		Bits;
		Boolean		*OrderedArg;	/* recursive literals only */
		int		OrderedArgs;
	};

typedef  struct _rel_rec
	{	char		*Name;
		int		Arity,
				Type[MAXARITY],
				NKeys,
				*Key;
		Tuples		Pos,
				Neg,
				Opt;
		Index		PosIndex,
				OptIndex,
				NegIndex;
		Clause		*Def;		/* definition is array of clauses */
		/*Boolean		PosPartialOrders[MAXPAIRS+1],
				NegPartialOrders[MAXPAIRS+1];*/
	};

typedef	 struct _type_rec
	{	char		*Name;
		int		NValues;
		Const		*Value;
		short		*CollSeq;
	};

typedef  struct _poss_lit_rec
	{
		float		Gain;
		Relation	Rel;
		Boolean		Sign;
		Vars		Args;
		float		Bits;
		int		NewSize,
				TotCov,
				PosCov;
	};
	
typedef  struct _backup_rec
	{
		float		Value;
		Clause		UpToHere;
	};


#define	 VERBOSE(x)		if(Verbosity>=x)
#define  SAMEVAR		Reln[0]

#define  Log2(x)		(log((float) x)/0.693147)
#define  LogComb(n,r)		(LogFact[n] - LogFact[r] - LogFact[(n)-(r)])
#define  Except(n,e)		((n) ? (1.1*(Log2(n) + LogComb(n, e))) : 0.0)

#define  Nil			0               /*null pointer*/
#define  false			0 
#define  true			1 
#define  Max(a,b)               ( (a)>(b) ? a : b ) 
#define  Min(a,b)               ( (a)<(b) ? a : b ) 
#define  Abs(x)			((x) > 0 ? x : -(x))
#define  Round(x)		((int) (x+0.5))

#define  ForEach(Var,First,Last) for(Var=First;Var<=Last;++Var) 

#define  Mask			 077777777
#define  PosMark		0100000000
#define  Positive(T)		((T)[0]&PosMark)

#define  TrueBit		02
#define  FalseBit		01
#define  SetBit(A,B)		Bits[A] |= B
#define	 TestBit(A,B)		(Bits[A] & B)
#define  ClearBits		memset(Bits,0,InitialTot)

#define  BestLitGain		(NPossible ? Possible[1]->Gain : 0.0)

#define  Plural(n)		((n) > 1 ? "s" : "")
#define  newline		putchar('\n')
#define	 ReadToEOLN		while ( getchar() != '\n' )

Boolean
	CanComplete(),
	CheckRHS(),
	CommonValue(),
	Consistent(),
	IllegalKey(),
	Interpret(),
	Join(),
	JunkLiteral(),
	PossibleGain(),
	ProposeDeterminateLiteral(),
	Recover(),
	Unifiable();

Const
	FindConstant();

Literal
	FindLiteral(),
	MakeLiteral(),
	SelectLiteral();

Clause
	FindClause();

Tuple
	ReadTuple(),
	*ReadTuples(),
	NextConstTuple(),
	Extend();

Index
	MakeIndex();

Relation
	ReadRelation();

float
	ComputeGain(),
	Info(),
	Worth();

int
	FindType(),
	Number(),
	NumberArgLists();

char
	ReadName(),
	*CopyString();

/*void
	CheckCover(),
	CheckRelation(),
	CheckSameVar(),
	CheckSize(),
	ClearTables(),
	ConstructOptionalTuples(),
	Discard(),
	ExtractPartialOrders(),
	FindDefinition(),
	FindPartialOrders(),
	FindRelationOrder(),
	GreedyArgs(),
	InitialiseTrainingSet(),
	InitialiseValues(),
	InspectCase(),
	NewTrainingSet(),
	PrintClause(),
	PrintDefinition(),
	PrintLiteral(),
	PrintTuple(),
	PrintTuples(),
	ProposeLiteral(),
	PruneClause(),
	RecordPartialOrders(),
	RecoverTrainingSet(),
	Remember(),
	RenameVariables(),
	SiftClauses(),
	TryArgs(),
	TryArgs(),
	main(); */

char	*malloc(), *realloc(), *memcpy(), *memset(), *strcpy();
void	free();
