;;;____________________________________________________________________________________
;;;                               Windows Menu
;;;
;;;  Created and designed by Clifford A. Brunk 07/31/91
;;;
;;;  Problems:
;;;____________________________________________________________________________________


(in-package :user)

;;;____________________________________________________________________________________
;;;  *listener-menu-item*

(defparameter *listener-menu-item*
  (make-instance 'menu-item 
                        :menu-item-title "Hide Listener"
                        :menu-item-action #'(lambda () 
                                              (cond ((window-shown-p *top-listener*)
                                                     (setf *error-output* *terminal-io*)
                                                     (window-hide *top-listener*))
                                                    (t
                                                     (window-show *top-listener*)
                                                     (setf *error-output* CCL::*pop-up-terminal-io*)
                                                     (window-select *top-listener*))))))

(set-menu-item-update-function *listener-menu-item*
                               #'(lambda (item)
                                   (if (window-shown-p *top-listener*)
                                     (set-menu-item-title item "Hide Listener")
                                     (set-menu-item-title item "Show Listener"))))


;;;____________________________________________________________________________________
;;;  *close-inspect-windows-menu-item*

(defparameter *close-inspect-windows-menu-item*
  (make-instance 'menu-item 
                 :menu-item-title "Close Inspect Windows"
                 :menu-item-action
                 #'(lambda () (map-windows #'(lambda (w) (window-close w))
                                           :class 'inspector::inspector-window))))

;;;____________________________________________________________________________________
;;;  *close-graph-windows-menu-item*

(defparameter *close-graph-windows-menu-item*
  (make-instance 'menu-item 
                 :menu-item-title "Close Graph Windows"
                 :menu-item-action 
                 #'(lambda () (map-windows #'(lambda (w) (if (eql (kind w) :graph)
                                                           (window-close w)))
                                           :class 'graph-window))))

;;;____________________________________________________________________________________
;;;  *close-learning-windows-menu-item*

(defparameter *close-learning-windows-menu-item*
  (make-instance 'menu-item 
                 :menu-item-title "Close Learning Windows"
                 :menu-item-action
                 #'(lambda () (close-learning-windows))))

;;;____________________________________________________________________________________
;;;  w-menu-item

(defclass w-menu-item (menu-item)
  ((window :initarg :window :initform nil :accessor window)))

(defmethod menu-item-update ((item w-menu-item))
  (if (and (ccl::inherit-from-p (window item) 'fred-window)
           (window-needs-saving-p (window item)))
    (set-menu-item-check-mark item #\))
  (if (ccl::inherit-from-p (window item) 'graph-window)
    (set-menu-item-check-mark item #\))
  (if (or (eq (window item) *COVERAGE-AND-WORK-WINDOW*)
          (eq (window item) *CURRENT-GAIN-WINDOW*)
          (eq (window item) *BEST-GAIN-WINDOW*)
          (eq (window item) *EBL-WINDOW*)
          (eq (window item) *LEARNED-CONCEPT-DESCRIPTION-WINDOW*)
          (eq (window item) *PAUSE-BOX*))
      (set-menu-item-check-mark item #\))
  (if (eq (window item) *top-listener*)
    (set-command-key item #\L))
  (if (eq (window item) (front-window))
    (menu-item-disable item)
    (menu-item-enable item)))
  
(defmethod menu-item-action ((item w-menu-item))
  (window-show (window item))
  (window-select (window item)))

;;;____________________________________________________________________________________
;;;  *focl-windows-menu*

(defparameter *focl-windows-menu*
  (make-instance 'menu
                 :menu-title "Windows"))

(defmethod menu-update ((menu (eql *focl-windows-menu*)))
  (apply 'remove-menu-items menu (menu-items menu))
  (add-menu-items menu *listener-menu-item*)

  (let ((show-close-inspect-windows-menu-item nil)
        (show-close-graph-windows-menu-item nil)
        (show-close-learning-windows-menu-item (and (fboundp 'close-learning-windows)
                                                    (some-learning-window-is-open))))
    (map-windows #'(lambda (w) 
                     (cond ((and (ccl::inherit-from-p w 'graph-window)
                                 (eql (kind w) :graph))
                            (setf show-close-graph-windows-menu-item t))
                           ((ccl::inherit-from-p w 'inspector::inspector-window)
                            (setf show-close-inspect-windows-menu-item t))
                           (t nil)))
                 :include-invisibles nil)

    (when (or show-close-inspect-windows-menu-item
              show-close-graph-windows-menu-item
              show-close-learning-windows-menu-item)
      (add-menu-items menu (make-instance 'menu-item :menu-item-title "-" :disabled t)))
    (when show-close-inspect-windows-menu-item
      (add-menu-items menu *close-inspect-windows-menu-item*))
    (when show-close-graph-windows-menu-item
      (add-menu-items menu  *close-graph-windows-menu-item*))
    (when show-close-learning-windows-menu-item
      (add-menu-items menu *close-learning-windows-menu-item*))
    (when (front-window)
      (add-menu-items menu (make-instance 'menu-item :menu-item-title "-" :disabled t))))
    
  (map-windows #'(lambda (w)
                   (let ((item (make-instance 'w-menu-item
                                              :menu-item-title (window-title w))))
                     (setf (window item) w)
                     (add-menu-items menu item)))
               :include-invisibles nil)
  (call-next-method))
  
#|
(menu-deinstall ccl::*windows-menu*)
(menu-install *focl-windows-menu*)
|#


(provide :windows-menu)