
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)
;; ------------------- Mike Pazzani, 9 Oct 90 ------------------------
;;  revisions
;;  rv  who    date     reason
;;  00  glenn  11/04/90  modified computation of key so it works when max-new-vars = 0
;; Ka, Dec 11: added keyword cache?
(defun get-variabilizations-old
       (pred max-new-vars old ; old is a list of structs
             predicate-being-learned
             variable-types
             original-vars
             &key (cache? t))
  (if (and (builtin-p pred) 
           (not (>= (count-if #'number-type
                              variable-types)
                    2)))
    (setq cache? nil))
  (get-variabilizations2 pred max-new-vars old predicate-being-learned
                         variable-types original-vars :cache? cache?))
;;  01  glenn  05/04/91  fixed up key - mike see if this is reasonable
(defun get-variabilizations (pred max-new-vars old ; old is a list of structs
                                 predicate-being-learned
                                 variable-types
                                 original-vars
                                 &key (cache? t)
                                 &aux (key (list old variable-types max-new-vars))) ; ges
 ; (format t "~%pred is ~a max-new-vars is ~a old is ~a pred-learned is ~a var-types ~a vars ~a" 
  ;        (p-name pred) max-new-vars old (p-name predicate-being-learned) variable-types original-vars)
  (if cache?  ; .. first try to get the hashed value, create otherwise
	(or (gethash key (p-variabilizations pred))
	    (setf (gethash key (p-variabilizations pred))
                  (generate-variabilizations pred old 
                                             predicate-being-learned
                                             variable-types max-new-vars
                                             original-vars )))
        ; not caching.. - needed when vars are gensym'd
          (progn
	    (setf (gethash key (p-variabilizations pred))
                  (generate-variabilizations pred old 
                                             predicate-being-learned
                                             variable-types max-new-vars
                                             original-vars )))))

;; ------------------- Kamal Ali, 9 Oct 90 ------------------------
;;; for each predicate, this generates all the variabilizations of
;;; that predicate consistent with mode/typing etc.
;;; this generation is costly and is done by a call to all-typed-variabilizations
;;; previously, for each clause, for each pred, 1 call had to be made -
;;; now, only 1 call per pred is made and put on the plist of the **name**
;;; of the predicate
(defun generate-variabilizations 
    (pred                          ;generate variabilizations for this pred
     variables                     ;list of old variables
     predicate-being-learned       ;used to detect recursion
     variable-types                ;types of old variables
     maximum-new-vars              ;maximum number of new variables allowed
     original-vars                 ;used to detect recursion
     )
      
        (let ((arity (p-arity pred))
              (type (p-type pred))
              (constraint (p-constraint pred))
              (mode (p-mode pred))
              (commutative (p-commutative pred))
              (induction (p-induction pred))
              (all-variabilizations nil)
              (struct-list nil))

      (when induction
        (setq all-variabilizations (all-typed-variabilizations variables
                                      variable-types
                                      (make-new-vars (min (- arity 1)
                                                          maximum-new-vars))
                                      type))
        (do* ((variabilizations all-variabilizations (cdr variabilizations))
             (variabilization (car all-variabilizations)
                              (car variabilizations)))
            
            ; termination ... 
            ((null variabilization) 
             (reverse struct-list))
                     
            (if (and (not (infinite-recursive-call pred predicate-being-learned
                                                   variabilization original-vars))
                     (or (null mode)
                         (check-mode mode variabilization))
                     (or (null commutative)
                         (check-commutative variabilization))
                     (or (null constraint) ; otherwise constraint must be :unique-vars
                         (not (contains-repeated-var variabilization))))
                (push (make-variabilization-struct :variabilization variabilization)
                      struct-list))))))

(defun reset-variabilization-flags (struct-list)
  (dolist (varzn-struct struct-list struct-list)
    (setf (variabilization-struct-look-at-positive? varzn-struct) t)    
    (setf (variabilization-struct-look-at-negative? varzn-struct) nil)))

   
;; :+ for old variables , :- for new variables, :? for dont care
(defun check-mode(mode-list variabilization)
  (every #'(lambda(curr-mode curr-var)
             (cond ((equal curr-mode :+) (not (new-var? curr-var))) 
                   ((equal curr-mode :-) (new-var? curr-var)) ; smilie here
                   ((equal curr-mode :?) t)
                   (t (progn (format t "~&check-mode: illegal mode: ~a" curr-mode)
                             nil))))
         mode-list variabilization))


;;; assumes a total ordering derivable from the names of variables
;;; then a pair of variables (v1,v2) passes this test if
;;; according to that ordering (>= v1 v2)
;;; so far, commutative is only checked for predicates of arity 2.
(defun check-commutative(variabilization)
  (cond ((not (= (length variabilization) 2)) t)
        (t (var-greater-eq (first variabilization)
                          (second variabilization)))))

;;; specific ordering between variable names 
;;; old varialbes are ?0,?1... new variables are ?-1,?-2 ...
;(defun var-greater-eq (var1 var2)
;  (>= (pcvar-id var1) (pcvar-id var2)))

;;; specific ordering between variable names 
;;; old variables are ?0,?1... new variables are ?-1,?-2 ...
;;; (KA, Dec 11): now some var names are like ?#:G1672, so use string>=
;;; instead of >=
(defun var-greater-eq (var1 var2)
  (string>= (princ-to-string (pcvar-id var1))
            (princ-to-string (pcvar-id var2))))


;;; used when :constraint :unique-vars is set.. eg: no variable can stand for more than
;;; 1 slot
(defun contains-repeated-var(list)
    (cond((null (cdr list)) nil) ; a list of length one can't
                ((member (car list)(cdr list) :test #'var-eq)
                         t)
                       (t (contains-repeated-var (cdr list)))))



