
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)
(defun test-focl()
  (reset-preds)
  (load-source-test-file "member")
  (time(print-rule-summary (print(test-member))))

  (reset-preds)
  (load-source-test-file "illegal")
  (time(print-rule-summary (print(test-illegal))))


  (reset-preds)
  (load-source-test-file "test-numbers")
  (time(print-rule-summary (print(test-numbers))))
  (time(print-rule-summary (print  (focl 'test))))
  (time(print-rule-summary (print  (focl 'test2))))
  (time(print-rule-summary (print  (focl 'test3))))
  (time(print-rule-summary (print (focl 'test4))))
  (time(print-rule-summary (print  (focl 'test5))))

  (reset-preds)
  (load-source-test-file "illegal")
  (load-source-test-file "chess-domain")
  (time(print-rule-summary (print(test-illegal-ebl))))

    (reset-preds)
  (load-source-test-file "illegal")
  (load-source-test-file "chess-knight-and-rook")
  (print (judge-original 100))
  (time(print-rule-summary (print(test-incorrect-illegal))))
  (time(print-rule-summary (print(test-incorrect-illegal t)))) 
  (time(print-rule-summary (print(test-incorrect-illegal t :frontier)))) 
  (reset-preds)
  (load-source-test-file "students")
  (load-source-test-file "loan")
  (time(print-rule-summary (print(test-students))))
  (time(print-rule-summary (print(test-students-induction))))


  (reset-preds)
  (load-source-test-file "worse-loan")
  (time(print-rule-summary (print(test-students-simplify))))
  (time(print-rule-summary (print(test-students-simplify :frontier))))

  (reset-preds)
  (load-source-test-file "illegal-200")
  (time(print-rule-summary (print(test-200))))

  (reset-preds)
  (load-source-test-file "xmas")
  (test-xmas)
  (test-xmas :gain-function :ratio :simplify-operationalizations t :refinement :frontier
	     :prefer-deletions t :prefer-children t :goal-concept-name 'xmas-present :trace '(:i :l :c))
  (test-focl-builtins)
  (test-focl-triangle)
  (test-trade)
  (test-cliches)
  (test-non-numeric-and-equality-builtins)
  )

;;;  exercises builtins (and extensional/builtin predicates) and "is" 
;;;  predicates

(defun test-focl-builtins()
  ;  strongly typed version of student loan with missing rules to 
  ;  demonstrate conjunctions
  (reset-preds)
  (load-source-test-file "typed-students")
  (load-source-test-file "typed-loan")
  (time(print-rule-summary (print(test-students '(:i :l :b :lt)))))
  (time(print-rule-summary (print(test-students '(:i :l :b :lt) :frontier))))
 
  (reset-preds)
  (load-source-test-file "test-hr")
  (time(print-rule-summary (print(test-hr))))

  (reset-preds)
  (load-source-test-file "test-is")
  (time(print-rule-summary (print(test-is))))

  )

;;;  tests mostly the is feature 

(defun test-focl-triangle ()
  (reset-preds)
  (load-source-test-file "triangle")
  (load-source-test-file "test-triangle2")
  (load-source-test-file "test-triangle")
  (time (print-rule-summary (print (test-triangle '(:l)))))
  (format t "~%~%~% long trace for illegal input A < B only")
  (time (print-rule-summary (print (test-illegal-input2 '(:i :l :lt)))))
  (format t "~%~%~%long trace for equaliateral A = B only")
  (time (print-rule-summary (print (test-equilat2 '(:i :l :lt))))))

;;;  tests focl on 50 trade negotiation cases (stored in trade-cases.lisp - 
;;;  case outcomes are stored in trade-outcomes.lisp) with and without the
;;;  a domain theory which is 40% accurate (i.e., classifies a case as 
;;;  belonging to a unique and correct class).  There are four classes of
;;;  cases: uswin, oppwin, noagg, and tie.  
;;;  test-trade outcome is defined in trade-outcomes.lisp. Note that this
;;;  function defaults the :builtin-threshold-only flag to t (for 
;;;  compatability with the cbr system, the domain theories can't contain
;;;  comparisons between variables).

(defun test-trade ()
  (format t "~%~% Testing trade negotiation data with no domain theory")
  (reset-preds)
  (load-source-test-file "trade-cases")
  (load-source-test-file "trade-outcomes")
  (run-trade-test)
  (reset-preds)
  (load-source-test-file "trade-cases")
  (load-source-test-file "trade-outcomes")
  (load-source-test-file "trade-dt")
  (run-trade-test))

(defun run-trade-test ()
  (mapc
   #'(lambda (outcome outcome-rule)
       (format t "~% processing class ~A" outcome)
       (time (print (test-trade-outcome outcome '(:l) outcome-rule))))
   '(uswin oppwin tie noagg)
   '(uswin-rule oppwin-rule tie-rule noagg-rule)))

;;; cliche and non-numeric-builtin tests

;;; tests a cliche by running it using the given available-cliches supplied and
;;; comparing the results using the single unconstrained cliche

;;;    test-files - files to load 
;;;    cliche-tested - name of cliche tested (used only for print msg)
;;;    concept - concept being learned (used only for print msg)
;;;    test-fn - name of function to call note this should accept 
;;;      available-cliches as a keyword paramter and trace as an optional
;;;      parameter
;;;    trace - trace for test-fn
;;;    keys - other keywords args for test-fn

(defun test-cliche (test-files cliche-tested concept test-fn trace 
		    available-cliches 
		    &rest keys &key the-ignored-key &allow-other-keys)
  (declare (ignore the-ignored-key))
  (reset-preds)
  (mapc #'load-source-test-file test-files)
  (format t "~%~%testing ~a CLICHE on ~a~%" cliche-tested concept)
  (time (print (apply test-fn trace :available-cliches available-cliches keys)))
  (format t "~%~% cliche variabilizations checked: ~a ~% total variabilizations checked ~a"
	  *cliche-variabilizations-checked* *variablizations-checked* )
  (format t "~%~%testing UNCONSTRAINED CLICHE on ~a~%" concept)
  (time (print (apply test-fn trace :available-cliches '(unconstrained) keys)))
  (format t "~%~% cliche variabilizations checked: ~a ~% total variabilizations checked ~a"
	  *cliche-variabilizations-checked* *variablizations-checked* ))

;;;  test out available cliches - note the functionality arithmetic cliche 
;;;  is currently not supported in the unconstrained cliche

(defun test-cliches ()
  (test-cliche '("part-of-ourcup") 'partof 'cup 'test-cup '(:l :ci) 
	       '(partof threshold-comparator))
  (test-cliche '("test-hbp-ewbc-good") 'threshold-comparator 'ill 'test-foo 
	       '(:l :ci) '(partof threshold-comparator))
  (test-cliche '("test-non-numeric") 'non-numeric-constant 'red-cup 
	       'test-red-cup 
	       '(:l :ci) '(non-numeric-constant))
  (format t "~%~% Note - arithmetic cliche not yet supported in unconstrained cliche~%")
  (test-cliche '("test-arithmetic-cliche") 'arithmetic 'a+b
	       'test-a+b
	       '(:l :ci) '(arithmetic))
  (test-cliche '("recursive-member") 'recursive 'member 
	       'test-member 
	       '(:l :ci) '(recursive))
  (test-cliche '("recursive-length") 'recursive2 'length 
	       'test-length 
	       '(:l :ci) '(recursive2))
)
 
;;; tests out thresholds for non-numeric builtins and equality constants for
;;; both numeric and non-numeric equality builtins (also tests eql(A,B))

(defun test-non-numeric-and-equality-builtins ()
  (reset-preds)
  (load-source-test-file "test-non-numeric")
  (format t "~%~% testing same color (tests non-numeric equality w/o constants)")
  (time (print (test-same-color '(:l))))
  (reset-preds)
  (load-source-test-file "test-string-lessp")  
  (format t "~%~% testing non-numeric relations with string-lessp")
  (format t "~%~% learnings string-lessp(A,\"mouse\") - i.e., thresholds with non-numeric relations~%")
  (time (print (test-less-than-mouse '(:i :l))))
  (format t "~%~% testing string-lessp on just variables - learning less-strings (i.e. string-lessp(A,B))~%")
  (time (print (test-less-strings '(:l))))
  (reset-preds)
  (load-source-test-file "test-b=7")
  (format t "~%~%testing numeric equality concepts with B=7~%")
  (time (print (test-b=7 '(:l)))))
