
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)

(proclaim '(inline make-pcvar pcvar-p var-eq pcvar-id ))
(defun make-pcvar(&key (id (gensym)))
  (intern (format nil "?~a" id)))

(defun pcvar-p(x)
  (and (symbolp x)
       (eq (char (symbol-name x) 0) #\?)))
(defun pcvar-id(x)
  (or (get x 'pcvar-id)
      (setf (get x 'pcvar-id)
	    (read-from-string (subseq (symbol-name x) 1)))))

;; -- count

(defstruct p 
  name
  arity   ;integer
  type    ;a list of length arity, each element is type of a parameter
  constraint
  mode
  commutative
  induction  ;nil if predicate should be ignored during induction
  neg-tuples-hash     ;used to avoid recomputation of first literal of clause
  neg-tuples-hash-for-negated  ; since neg-tuples doesn't change
  (variabilizations (make-hash-table :test #'equal :size 4)) ;;; kamal
  ;;maps (old . arity) to list of legal variabilizations
  treat-as-commutative ;- should we compute X fn Y and Y fn X
  vars   ;pretty name for variables
  questions ;question for asking user about fact (or printing about x
  (infix nil))  ;t if predicate should be printed in infix form.

(defstruct (pred (:include p))
  pos        ;list of positive examples
  neg        ;list of negative examples
  pos-hash   ;equal hash table, returns list of tuple if tuple is positive, nil otherwise
  slot-value-hash ;array of hash tables, one per parameter, each hash table returns a list of
                  ;tuples that have a particular value for a particular argument position
  )

;;;  00  glenn  05/17/91  added to handle reduction preds 

;;; reduction-type is the type of the argument reduced
;;; reduction-variabilzation constrains the variabilizations when operator is used for
;;;  reduction as part of a cliche
 
(defstruct (reduction-pred (:include pred))
  reduction-type
  reduction-variabilization
  )

;;;  01  MP       07/04/91 added a field causes-1 that contains pointers
;;;                        to rules that are similar, but have one less
;;;                        clause. and a field "from-rule" that has a backpointer

(defstruct (rule (:include p))
	     ;note that for compatobility with prolog, clauses are also on plist of name
  clauses    ;list of clause structures
  prolog-function
  source-cliche ; cliche that rule is derived from
  (clauses-1 nil)
  (from-rule nil)
  )

(defstruct clause
  body ;list of prolog literals
  parameters ;list of variables bound by the head
  number ;number of the clause for a rule- maintained for future use
  head ;name of rule- makes debugging easier
  new-vars ;list of new-variables in clause
  neg-tuples-hash ;note that we never try the negation of a clause, 
                   ;so no neg-tuples-hash-for-negated
  prolog-function) 

;;  rv  who    date       reason
;;  00  glenn  05/12/91   added fields to distinguish equality builtins and to provide
;;     a sorting fn to make non-numeric builtins possible

(defstruct (builtin (:include p))
  function ;lisp function that defines predicate
  (one-variable-comp t) ; should a threshold be computed for each var
  equality?
  (sort-fn #'<)
  )

(defstruct (literal (:print-function print-literal)
                    )
  (negated? nil)    ;true if literal is a negation
  negated-literals  ;only used for negations- filled by a literal structure
  predicate-name    ;name of predicate
  variablization    ;variables used in predicate
  prev              ;maintained, but not yet used
  (next nil)        ;if this is non-nil, its another literal, the next one in a clause
  pos               ;positive tuples that this has been used on
  neg               ;negative tuples 
  new-pos          ;positive tuples satisfied by literal
  new-neg          ;negative tuples satisfied by literal
  derivation       ;a deivation structure, explains reason for using literal
  (deleted? nil)   ;t if literal should not be considered part of the clause
  )

;;  rv  who    date      reason
;;  00  glenn  11/01/90  added
;;  01  cliff  04/07/91  removed literal-bits
;;; records information needed build a conjunction with an extensional predicate
(defstruct conj-info
  extensional-gain
  pred
  variabilization
  max-negated?
  pos-tuples
  neg-tuples
  vars
  types)

(defstruct derivation
            type  ;either :ebl, :induction, or :constructive-induction
            path) ;for :ebl or :constructive-induction, a list describing how the (operational) literal
                ;was derived from a rule- the last element of the list is a prolog form of the literal
                ;the first elements are inserted by insert-proof-trace
                ;they are of the form (clause-structure . prolog-body)
                ;the clause-structure tells waht clause was used
                ;the prolog body uses the same variables as the head of the clause and the literal


;;  rv  who    date     reason
;;  00  glenn  11/1/90  added

;;;  allows access to the structure associated with pred, builtins etc. in a uniform manner
;;;  note I put this in struct.lisp so that when new struct-types are added this will get
;;;  updated.
;;;  note we may want check *builtin-preds* and *extensional-preds* since reset-preds doesn't clean
;;;  this up
(defun get-pstruct (p)
  (cond ((get p 'builtin))
        ((get p 'pred))
        ((get p 'builtin-fn)) ; not used yet
        ((get p 'rule))
        ((get p 'arithmetic-op))
        ((get p 'is-op))
        (t nil)))

;; -- focl ----------------------------------------

;; -- find-literal ----------------------------------------

;; -- summarize ----------------------------------------

;; -- builtin ----------------------------------------


;; -- arith ----------------------------------------

(defstruct (arithmetic-op (:include p))
  function ;lisp function that defines operator
  )

(defstruct (is-op (:include p))
  arithmetic-op)


;; -- variabilization-lists ----------------------------------------
(defstruct variabilization-struct
    (variabilization nil)
      (look-at-positive? t)
        (look-at-negative? nil))
