
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)
;;;deletes literal from clause if when deleted the clause covers more positive and not fewer negative tuples
;;;
;;; 01 mike 4/27/91   Deleted recover-ebl shit and made it use new prolog

(defun simplify-clause (clause ;;a linked list of literals
                        pos-tuples ;;all remaining positive tuples
                        neg-tuples ;;list of negative tuples not covered by the current clause
                        old-vars  ;;bound variables
                        &aux  new-pos-tuples ;;those covered by clause
                        newer-pos-tuples  ;those covered by clause with a term deleted
                        max-length ;;number of positive tuples covered
                        new-length ;number of positive tuples covered by clause with a term deleted
                        prolog-clause ;prolog rep of clause
                        ;flag
                        )
  ;;initialize to current clause
  (setf new-pos-tuples (filter-proved-tuples (convert-to-prolog-function clause old-vars)
					     pos-tuples))
  (setf max-length (length new-pos-tuples))
  (cond ((null *simplify-clauses*) (values clause new-pos-tuples))
        #|((multiple-value-setq (flag clause new-pos-tuples)
                              (recover-from-ebl? clause  pos-tuples max-length new-pos-tuples neg-tuples old-vars))
         (values clause new-pos-tuples))|#
         (T
         ;;delete each literal in turn
         ;;leave it deleted if better (ebl) or at least as good (induction ) without
         (do ((l clause (literal-next l)))
             ((null l))
           (unless (or (literal-deleted? l)
                       (literal-causes-unbound-vars l old-vars clause))
             (setf (literal-deleted? l) t)
             
             (cond ((setf prolog-clause (convert-to-prolog-function clause old-vars))
                    (setf newer-pos-tuples (filter-proved-tuples prolog-clause
                                                          pos-tuples))
                    
                    (setf new-length (length newer-pos-tuples))
                    (cond ((and (not(any-proved-tuples prolog-clause neg-tuples))
                                (if (eq (derivation-type (literal-derivation l)) :ebl)
                                  (< new-length max-length) ;if ebl, don't delete unless better
                                  (<= new-length max-length)))  
                           (setf new-pos-tuples newer-pos-tuples
                                 max-length new-length))
                          (t (setf (literal-deleted? l) nil))))
                   
                   (t (setf (literal-deleted? l) nil)))))    
         
         (values clause new-pos-tuples))))



;;  revisions
;;  rv  who    date     reason
;;  00  glenn  1/30/91  defines greedy version of simplification algorithm which

;;; like simplify-clause only works off of operational definition returned by ebl and is called
;;; while ebl is operationalizing the domain theory.
;;; successively deletes best literal from clause (if any) that improves info-gain 


(defun simplify-operational-clause
         (literal-conj ;;a linked list of literals
          pos-tuples ;;all remaining positive tuples (not covered by previous clauses
          neg-tuples ;;all negative tuples, we might not have completed clause
          old-vars  ;;bound variables
          new-pos-tuples ; covered by literal-conj
          new-neg-tuples ; covered by literal-conj
          new-vars ; introduced by literal-conj
          new-types ; for corresponding vars
          info-gain
          original-info
          use-negative-hash
          &aux num-lits-deleted 
          (old-clause-length (compute-clause-length literal-conj)))
    (multiple-value-bind
      (new-literal-conj newer-pos-tuples newer-neg-tuples newer-vars newer-types 
       best-info-gain)
      (simplify-operational-clause-greedy
       literal-conj pos-tuples neg-tuples old-vars new-pos-tuples new-neg-tuples 
       new-vars new-types info-gain original-info use-negative-hash)
      (setq num-lits-deleted (- old-clause-length 
                                (compute-clause-length new-literal-conj)))
      (values new-literal-conj newer-pos-tuples newer-neg-tuples newer-vars newer-types 
              best-info-gain)
))

;;  rv  who    date     reason
;;  00  glenn  1/30/91  added as an auxiliary function to for simplifications 
;;   algs. returns the length of a clause

;;; accepts a conjunction of literals and computes the length

(defun compute-clause-length (conjunction &optional (length 0))
  (if (null conjunction)
    length
    (compute-clause-length 
     (literal-next conjunction) 
     (if (literal-deleted? conjunction)
       length 
       (1+ length)))))

;;  rv  who    date     reason
;;  00  glenn  1/30/91  simplifies a clause by deleting literals trying to 
;;   improve the info gain in a greedy fashion
;;  01  mike   Dec 5    Added a flag  *simplify-operationalizations* to determine whether
;;                     to try simplifying operationalization
;; 02   mike 4/26/91    Use prolog compiler
(defun simplify-operational-clause-greedy
       (literal-conj ;;a linked list of literals
        pos-tuples ;;all remaining positive tuples (not covered by previous clauses
        neg-tuples ;;all negative tuples, we might not have completed clause
        old-vars  ;;bound variables
        new-pos-tuples ; covered by literal-conj
        new-neg-tuples ; covered by literal-conj
        new-vars ; introduced by literal-conj
        new-types ; for corresponding vars
        info-gain
        original-info
        use-negative-hash
        &optional (best-info-gain info-gain)
        &aux  
        newer-pos-matches  ;those covered by literal-conj with a term deleted
        newer-neg-matches ; those covered by the literal-conj with a term deleted
        new-pos-matches
        new-neg-matches
        newer-vars ; new vars that are refered to by new literal-conj
        newer-types ; corresponding types
        prolog-clause ;prolog rep of literal-conj
        new-info-gain
        best-literal ; save so can delete it later
        )
  ;;initialize to current clause

  (cond ((null *simplify-operationalizations*) 
         (values literal-conj new-pos-tuples new-neg-tuples new-vars new-types info-gain))
        (T (setq new-pos-matches (length new-pos-tuples))
           (setq new-neg-matches (length new-neg-tuples))
         ;;delete each literal in turn
         ;;leave it deleted if it improves info-gain 
         (do ((l literal-conj (literal-next l)))
             ((null l))
           (unless (or (literal-deleted? l) (literal-causes-unbound-vars l old-vars literal-conj))
             (setf (literal-deleted? l) t)
             (cond ((setf prolog-clause (convert-to-prolog literal-conj))
                    (multiple-value-setq 
                     (new-info-gain newer-pos-matches newer-neg-matches)
                     (info-gain-prove-immediate prolog-clause
                      (convert-to-prolog-function literal-conj old-vars prolog-clause)
                      original-info pos-tuples neg-tuples old-vars nil))
                    (cond ((and (> new-info-gain best-info-gain) ; in ebl only delete if better
				(ratio-neg-total-improves 
                                  new-pos-matches new-neg-matches
                                  newer-pos-matches newer-neg-matches))
                           (setf new-pos-matches newer-pos-matches
                                 new-neg-matches newer-neg-matches
                                 best-info-gain new-info-gain
                                 best-literal l))
                          (t nil)))
                   (t nil))
             (setf (literal-deleted? l) nil)))
         (cond (best-literal ; deleted at a literal
                (setf (literal-deleted? best-literal) t)
		; note if we have fewer new-vars we may have to rename them and do substititutions
		; (we'll do it later after the recursion bottoms out)
                (multiple-value-setq (newer-vars newer-types)
                                     (new-vars-still-bound new-vars new-types literal-conj))
                (setq new-pos-tuples (extend-tuples literal-conj pos-tuples old-vars newer-vars))
                (setq new-neg-tuples (extend-tuples literal-conj neg-tuples old-vars newer-vars))
                (simplify-operational-clause-greedy
                 literal-conj pos-tuples neg-tuples old-vars
                 new-pos-tuples new-neg-tuples newer-vars newer-types  best-info-gain
                 original-info use-negative-hash))
               (t (multiple-value-setq (newer-vars newer-types literal-conj)
                                       (fix-new-vars literal-conj old-vars new-vars new-types))
                  (setf literal-conj (cleanup-and-delete-literals literal-conj old-vars new-vars))
                  (values literal-conj new-pos-tuples new-neg-tuples newer-vars newer-types 
                          best-info-gain))))))

;;  rv  who    date     reason
;;  00  glenn  1/30/91  auxiliary function for simplify determines if the 
;;   new clause generated (by the simplify routine) improves the ratio of 
;;   positive to negative examples

;; note kludge below can probably be removed without any problems 

(defun ratio-neg-total-improves (old-pos old-neg new-pos new-neg)
  (and (or (> new-neg 0) (> new-pos 0)) ; kludge to avoid divide by 0
       (or (> old-neg 0) (> old-pos 0)) ; kludge to avoid divide by 0
  (or (< (/ new-neg (+ new-pos new-neg))
         (/ old-neg (+ old-pos old-neg)))
      (and (zerop old-neg) (zerop new-neg) 
           (> new-pos old-pos))))
) ; extra paren for kludge

;;  revisions
;;  rv  who    date     reason
;;  00  glenn  1/30/91  defines optimal version of simplification algorithm



;;  rv  who    date     reason
;;  00  glenn  1/30/91  copies a literal conjunction by copying the individual
;;    literals - maybe this should be elsewhere

(defun copy-literal-conjunction (literal-conj &aux copy)
  (setq copy (copy-literal literal-conj))
  (do* ((l literal-conj (literal-next l))
	(prev-copy copy next-copy)
	(next-copy (if (literal-next l) (copy-literal (literal-next l)))
	 (if (literal-next l) (copy-literal (literal-next l)))))
       ((null next-copy) copy)
       (setf (literal-next prev-copy) next-copy)
       (if next-copy (setf (literal-prev next-copy) prev-copy))))

;;  revision
;;  rv  who    date     reason
;;  00  glenn  12/04/90 added to insure simplify-operation-literal won't delete literals that bind
;;  variables used elsewhere

;;  rv  who    date     reason
;;  01  mike  12/24/90  Changed var-eq to equalp since arguments may be variables or numbers

;;; literal-causes-unbound-vars is an auxiliary routine for simplify-operation-literal.  Makes sure 
;;; that literal doesn't bind variables used by other literals so that it can be deleted safely. 
;;; old-vars are the vars on the left-hand side of the clause and conjunction is the entire 
;;; right-hand side (so far).

(defun literal-causes-unbound-vars (literal old-vars conjunction)
  (let* ((bound-vars
          (do ((vars old-vars)
               (l conjunction (literal-next l)))
              ((eql l literal) vars)
            (setq vars (append (literal-variablization l) vars))))
         (literal-new-vars 
          (all-images 
           #'(lambda (var)
               (if (not (member var bound-vars)) var))
           (literal-variablization literal))))
;    (format t "~%bound-vars ~A  literal-new-vars ~A" bound-vars literal-new-vars)
    (do ((l (literal-next literal) (literal-next l)))
        ((null l) nil)
      (if 
        (some 
         #'(lambda (var) 
             (member var literal-new-vars :test #'equalp)) 
         (literal-variablization l))
        (return t)))))

;;  revisions
;;  rv  who    date     reason
;;  00  glenn  1/30/91 added to insure simplify-operation-literal won't delete literals that bind
;;  variables used elsewhere
;;  01  glenn  1/30/90 extended version of literal-causes-unbound-vars to determine
;;   if there are unbound vars in a conjunction

;;; conjunction-contains-unbound-vars is an auxiliary routine for simplify-operation-literal-greedy.  Makes sure 
;;; literals of new clause bind variables before they are used by other literals (i.e., key literals weren't deleted)
;;; old-vars are the vars on the left-hand side of the clause and conjunction is the entire 
;;; right-hand side (so far).

(defun conjunction-contains-unbound-vars 
       (conjunction old-vars &aux literal-new-vars)
  (do ((vars old-vars)
       (l conjunction (literal-next l)))
      ((null l) nil)
    (cond ((literal-deleted? l)
           (setq literal-new-vars 
                 (all-images #'(lambda (var) (if (not (member var vars :test #'var-eq)) var))
                             (literal-variablization l)))
           (if (dolist (v literal-new-vars nil) ; unbound var is used elsewhere
                 (if (unbound-var-used v (literal-next l))
                   (return t)))
             (return t)))
          (t (setq vars (append-no-dup (literal-variablization l) vars))))))


;;  rv  who    date     reason
;;  00  glenn  1/30/91 added to determine if an unbound var is used in a literal 
;;   (aux function for conjunction-contains-unbound-vars)

(defun unbound-var-used (var l)
  (cond ((null l) nil)
        ((member var (literal-variablization l) :test #'var-eq) t)
        (t (unbound-var-used var (literal-next l)))))


;;  rv  who    date     reason
;;  00  glenn  1/30/91 auxiliary function for optimal-simply alg. sets 
;;   deleted bits of a clause (conjunction) give a set of indices

(defun set-deleted-bits (conjunction indices bit-val &aux (l conjunction))
  (dotimes (i (length indices) conjunction)
    (if (not (zerop (aref indices i)))
      (setf (literal-deleted? l) bit-val))
    (setf l (literal-next l))))

;;  revisions
;;  rv  who    date     reason
;;  00  glenn  11/28/90 added to fix up the new vars so that they are in the proper sequence
;;    (from old vars)

;;; accepts a conjunction of literals a set of bound (old) vars and a set of new-vars which
;;; maybe out of sequence along with their corresponding types and sorts and renames the 
;;; new-vars if necessary so that they are in proper sequence (from old-vars).  The sorted and 
;;; sequenced new-vars are returned along with their corresponding types and the conjunction 
;;; of literals with the appropriate substitutions performed in the variablizations of the
;;; individual literals

(defun fix-new-vars (conjunction old-vars new-vars new-types
				 &aux sorted-new-vars sorted-new-types new-var-index renamed-vars bindings)
  (cond((null new-vars)
	(values new-vars new-types conjunction))
       (t
	(setq sorted-new-vars (sort new-vars #'(lambda (var1 var2) (< (pcvar-id var1) (pcvar-id var2)))))
	(setq sorted-new-types
	      (mapcar 
	       #'(lambda (sorted-var) 
		   (nth (position sorted-var new-vars :test #'var-eq) new-types))
	       sorted-new-vars))
	(setq new-var-index (+ (length old-vars) (length new-vars)))
	(cond ((eql (pcvar-id (car (last sorted-new-vars))) (1- new-var-index))
	       (values sorted-new-vars sorted-new-types conjunction))
	      (t
	       (dotimes (i (length new-vars)) 
			(setq renamed-vars (cons (make-pcvar :id (decf new-var-index)) renamed-vars)))
	       (setq bindings (generate-simple-bindings sorted-new-vars renamed-vars))
	       (do ((literal conjunction (literal-next literal)))
		   ((null literal) (values renamed-vars sorted-new-types conjunction))
		   (setf (literal-variablization literal) 
			 (substitute1 (literal-variablization literal) bindings))))))))


;;  rv  who    date      reason
;;  00  glenn  11/28/90  added to perform linked list manipulations on deleted literals
;;  01  glenn   1/30/91  modified to correct bugs.  added old-vars as a parameter
;;  02  cliff   6/10/91  no-longer used is not really needed and will end up
;;                       making things for KR-FOCL harder. It is also harder to explain
;;                       why things magically disappear when running the demo.

;;; accepts a conjunction of literals and a set of new-vars (which may be out of sequence)
;;; and a set of old-vars and deletes the literals marked for deletion fixing up the linked 
;;; list of literals

#|
(defun cleanup-and-delete-literals (conjunction new-vars old-vars
                                    &aux (new-conjunction (first-literal-not-deleted conjunction)))
  (do ((literal conjunction (literal-next literal))
       (prev (literal-prev conjunction)
	     (if (literal-deleted? literal) prev literal))
       (next (literal-next conjunction) (if next (literal-next next)))
       (fix-tuples nil nil))
      ((null literal) new-conjunction)
    (cond ((literal-deleted? literal) ; delete current literal
           ;fix pointers
           (if prev (setf (literal-next prev) next))
           (if next (setf (literal-prev next) prev))
           ; need to fix pos-tuples and neg-tuples for subsequent tuples
           (setq fix-tuples t))
           ((and fix-tuples *save-examples*)
	    
            (setf (literal-pos literal) (literal-new-pos (literal-prev literal)))
            (setf (literal-neg literal) (literal-new-neg (literal-prev literal)))
            (setf (literal-new-pos literal) 
                  (extend-tuples conjunction  (literal-pos literal) old-vars new-vars))
            (setf (literal-new-neg literal) 
                  (extend-tuples conjunction (literal-neg literal) old-vars new-vars)))
           (t nil))))

|#

(defun cleanup-and-delete-literals (conjunction new-vars old-vars)
  (declare (ignore new-vars old-vars))
  conjunction)

;;  rv  who    date     reason
;;  00  glenn  11/28/90 added as an auxiliary function to cleanup-and-delete-literals to 
;;   determine the head of the new conjunction produced by deleted literals marked for deletion

;;; accepts a conjunction and returns the first literal of that conjunction that is not deleted
;;; i.e., returns the head of the conjunction after all literals that are deleted are removed.

(defun first-literal-not-deleted (conjunction)
  (cond ((null conjunction) nil)
        ((literal-deleted? conjunction)
         (first-literal-not-deleted (literal-next conjunction)))
        (t conjunction)))


;;  rv  who    date     reason
;;  00  glenn  11/28/90 added to determine which new-vars are still bound in literal-conj (after
;;   marked literals have been deleted)

;;; could probably use compute-new-vars here but we need to also return the corresponding types 

(defun new-vars-still-bound (new-vars new-types literal-conj)
  (do ((vars (reverse new-vars) (cdr vars))
       (types (reverse new-types) (cdr types))
      (bound-new-vars)
      (bound-new-types))
      ((null vars) (values bound-new-vars bound-new-types))
    (cond 
      ((do ((literal literal-conj (literal-next literal)))
          ((null literal) nil)
         (if (and (not (literal-deleted? literal))
                  (member (car vars) (literal-variablization literal) :test #'var-eq))
           (return t)))
       (setq bound-new-vars (cons (car vars) bound-new-vars))
      (setq bound-new-types (cons (car types) bound-new-types)))
      (t nil))))


;;; general utilities

;;  rv  who    date     reason
;;  00  glenn  1/30/91 appends two lists together ignoring duplicates

(defun append-no-dup (l1 l2)
  (cond ((null l1) l2)
        ((member (car l1) l2)
         (append-no-dup (cdr l1) l2))
        (t (append-no-dup (cdr l1) (cons (car l1) l2)))))


;;  rv  who    date     reason
;;  00  glenn  1/30/91 accepts a list (set) and returns a list of the subsets of the set.

(defun power-set (set &aux pset (indices (make-array (length set) :initial-element 0)))
  (dotimes (i (1- (expt 2 (length set))) (cons nil (nreverse pset)))
    (setq indices (inc-count indices (1- (length set))))
    (setq pset (cons (get-subset set indices) pset))))

;;  rv  who    date     reason
;;  00  glenn  1/30/91 accepts a list representing a set and a list of indices
;;   and returns the elements of the list corresponding to the indices

(defun get-subset (set indices &aux subset)
  (dotimes (i (length indices) (nreverse subset))
    (if (eql (aref indices i) 1) 
      (setq subset (cons (nth i set) subset)))))


;;  rv  who    date     reason
;;  00  glenn  1/30/91 increments array which is a vector of 0's and 1's 
;;    representing a binary counter

(defun inc-count (array end-pos)
  (cond ((> end-pos (1- (length array)))
         (inc-count array (1- (length array))))
        ((zerop (aref array end-pos)) 
         (setf (aref array end-pos) 1)
         (values array nil))
        ((zerop end-pos) 
         (setf (aref array end-pos) 0) 
         (values array t)) ; overflow
        (t (setf (aref array end-pos) 0) 
           (inc-count array (1- end-pos)))))

;;;  set up simplify to be greedy simplify



#|(defun recover-from-ebl? (clause;;a linked list of literals
			  pos-tuples;;all remaining positive tuples
			  length;;number of pos-tuples covered
			  new-pos-tuples
			  neg-tuples;;list of negative tuples not covered by the current clause
			  old-vars;;bound variables
			  &aux  
			  newer-pos-tuples ;those covered by clause with a term deleted
			  new-length	;number of positive tuples covered by clause with a term deleted
			  prolog-clause ;prolog rep of clause
			  any-ebl-flag all-ebl-flag saved-deleted-bits
			  )
  ;;initialize to current clause
  ;;delete
  (do ((l clause (literal-next l)))
      ((cond ((null l) (setq all-ebl-flag t) t)
	     (t (not(eq (derivation-type (literal-derivation l)) :ebl)))))
      (when (eq (derivation-type (literal-derivation l)) :ebl)
	    (push (literal-deleted? l) saved-deleted-bits)
	    (setf (literal-deleted? l) t)
	    (setf any-ebl-flag t)))
  (setq saved-deleted-bits (nreverse saved-deleted-bits))
  (cond ((or all-ebl-flag (null any-ebl-flag))
         (do ((l clause (literal-next l)))
	     ((null l))
	     (setf (literal-deleted? l) (pop saved-deleted-bits)))
         (values nil clause new-pos-tuples))
        (t (setf prolog-clause (convert-to-prolog-function clause old-vars))
           (setf newer-pos-tuples (filter-proved-tuples prolog-clause  pos-tuples))
                    
           (setf new-length (length newer-pos-tuples))
           (cond ((and (not(any-proved-tuples prolog-clause neg-tuples))
                       (<= new-length length)) 
                  (values t clause	;don't undelete
                          newer-pos-tuples))
                 (t (do ((l clause (literal-next l)))
			((null l))
			(setf (literal-deleted? l) (pop saved-deleted-bits)))
                    (values nil clause new-pos-tuples))))))
|#