
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)

;;;_______________________________________________________________________________
;;; EVAL-FUNCTION
;;;
;;;  revisions
;;;  rv  who    date      reason
;;;  00  cliff  05/21/91  Store pos matches, neg matches, gain and ratio for graphic display.
;;;  01  mp     07/03/91  Change to return 3 values info info-fixer and tie-breaker
                          

(defun eval-function(function pos neg v i &aux gain ratio 
			      (lp (length pos))(ln (length neg)))
  (incf *variablizations-checked*)
  (multiple-value-bind (o p)
                       (count-prove function  v pos)
    (multiple-value-bind (ignore n)
                         (count-prove  function v neg)
      (declare (ignore ignore))
      (cond ((= p 0) 
	     (setq gain 0)
	     (setq ratio 0))
	    (t(setq gain (i-gain i o p n))
	      (setq ratio (- (/ p (+ p n))
			     (/ lp(+ lp ln))))))
				
      (when (member :i *focl-trace-level*)
        (format t "~% ~10Tpos: ~a:~20T~a/~a~29Tneg: ~a:~40T~a/~a ~47T gain: ~4f rgain ~4F"
                o p lp n n ln gain ratio))
      
      (when *graph-learning*
        (store-info-gain-values-for-display p n
                                            (if (eq *gain-function* :information)
                                              gain
                                              ratio)))

      (if (eq *gain-function* :information)
	  (values gain ratio o)             ;;01 MP
	(values ratio ratio o)))))          ;;01 MP


(defun literal-part (x) 
  (let ((L (car x)))
    (if (eq (car L) 'not)
      (cons 'not (mapcar #'literal-part (cdr L)))
      L)))
                             
(defmacro derivation-part (x) `(cdr ,x))

(defmacro literal+derivation1 ( l d)
  `(cons ,l ,d))

(defun literal+derivation (l d) 
  (if (eq (car l) 'not)
    (cons (cons 'not (mapcar #'(lambda(a)(literal+derivation a d)) (cdr l)))
          d)
    (literal+derivation1 l d)))

(defun target-concept-p (x)
  (and (null (cdr x))
       (null (derivation-part (car x)))))

;;;_______________________________________________________________________________
;;; OPERATIONALIZE-IF-NEEDED
;;;
;;;  revisions
;;;  rv  who    date      reason
;;;  00  cliff  05/21/91  Added capacity to graph operationalization process.
;;;  01  mp     07/03/91  Change to use 3 values from eval-function: info info-fixer and tie-breaker
;;                        I needed to distinguish a second functions to check
;;                        with a tie breaker
;;  02  mp  07/04/91      Happy independance day-
;;                        changed to use a set of operators to refine hypotheses
;;  03  mp    "           Changed to add useful-if-no-change
;;                        There are two types of refinements
;;                        Those that require improvement (deletion)
;;                        and those that are applied if they don't make thing worse (specialization)

(defun operationalize-if-needed (c
                                 variabilization
                                 pos-tuples ;positive tuples 
                                 neg-tuples ;negative tuples 
                                 orig-info
                                 source)

  (let (max-tie-breaker
        max-info
        max-info-fixer
        useful-if-no-change
        new-c
        cf
        (winner c)
        winner-cf
        new-info 
        new-tie-breaker 
        new-info-fixer
        )

    (when *graph-learning*
	  (graph-clause-operationalization (mapcar #'(lambda(x) (literal-part x)) c)))

    (setq cf (convert-to-prolog-function nil
                                         variabilization
                                         (mapcar #'(lambda(x) (literal-part x)) c)))
    (setq winner-cf cf)
    (when (member :i *focl-trace-level*)
          (format t "~% ~a~a"
                  (mapcar #'(lambda(x) (literal-part x)) c)
                  variabilization))

    (multiple-value-setq (max-info max-info-fixer max-tie-breaker)
                         (eval-function cf
                                        pos-tuples
                                        neg-tuples
                                        variabilization
                                        orig-info))
    (when *graph-learning*
	  (dolist (literal (mapcar #'(lambda(x) (literal-part x)) c))
		  (add-antecedents-to-operationalization-frontier literal))) 

    (do* ((front nil (nconc front (list ld)))
          (ls c (cdr ls))
          (rest (cdr ls) (cdr ls))
          (ld (car ls) (car ls))
          (l (literal-part ld)(literal-part ld))
          (d (derivation-part ld) (derivation-part ld)))
         ((null ls))
      
	 (mapc #'(lambda(new-c.useful-if-no-change)
		   (setf new-c (car new-c.useful-if-no-change))
		   (setf useful-if-no-change (cdr new-c.useful-if-no-change))
		   (setq cf (convert-to-prolog-function nil 
							variabilization 
							(mapcar #'(lambda(x) (literal-part x)) new-c)))
		   (when (member :i *focl-trace-level*)
			 (format t "~% ~a~a"
				 (mapcar #'(lambda(x) (literal-part x)) new-c)
				 variabilization))

		   (multiple-value-setq (new-info new-info-fixer new-tie-breaker)
					(eval-function cf
						       pos-tuples
						       neg-tuples
						       variabilization
						       orig-info))
		   (when *graph-learning*
			 (display-clause-pos-neg-gain (mapcar #'(lambda(x) (literal-part x)) new-c)))

		   (when (or (and (> new-info max-info)
				  (> new-info-fixer max-info-fixer))
			     (and (>= new-info max-info)
				  (>= new-info-fixer max-info-fixer)
				  (or (> new-tie-breaker max-tie-breaker)
				      (and (= new-tie-breaker max-tie-breaker)
					   useful-if-no-change)))

			     (and (>= new-info 0)
				  (>= new-tie-breaker 0)
				  (>= new-info-fixer 0)
				  (eq source :ebl)
				  (target-concept-p winner)))
			 (setf winner new-c
			       max-info new-info
			       max-tie-breaker new-tie-breaker
			       max-info-fixer new-info-fixer
			       winner-cf cf
			       )))
	       (all-possible-refinements l d front rest)))
  
    (cond ((eq winner c)
           (when *graph-learning*
		 (dolist (literal (mapcar #'(lambda(x) (literal-part x)) winner))
			 (remove-antecedents-from-operationalization-frontier literal)))
           (cond 
            ((and (= max-info 0)
                  (eq source :ebl))
             :fail)
            (t winner)))
          (t
           (when *graph-learning*
		 (remove-clause-from-operationalization-frontier c))
	   (when (member :i *focl-trace-level*)
		 (format t "~%~% winner so far ~a~a~%"
			 (mapcar #'(lambda(x) (literal-part x)) winner)
			 variabilization))
           (operationalize-if-needed winner
                                     variabilization
                                     pos-tuples
                                     neg-tuples
                                     orig-info
                                     source)))
    )
  )


(defun possible-deletions(l d front rest)
    (declare (ignore l)(ignore d))
    (when (and *simplify-operationalizations*
               (or front rest))
      (list (cons (append front rest) *prefer-deletions*))))  ;don't do unless improves

;;perhaps useful-if-no-chnage should be T only if it (or a -1) has been operationalized before?
;;
(defun possible-specializations (l d front rest &aux call-bindings new-c s  (result nil))
   (cond ((eq (car l) 'not)
          (do* ((nfront nil (nconc nfront (list nl)))
                (ls (cdr l) (cdr ls))
                (nrest (cdr ls)(cdr ls))
                (nl (car ls)(car ls))
                (out (possible-specializations nl d nfront rest))
                )
               ((null ls) result)
            (mapcar #'(lambda(not-arg)
                        (push (cons (append front (list (literal+derivation1 (cons 'not not-arg) d))
                                      rest) *prefer-children*)
                              result))
                    out)))
         ((rule-p (setq s (get-pstruct (car l))))
          (all-images #'(lambda(clause)
                          (when (setq call-bindings (unify-list (clause-parameters clause)
                                                                (cdr l)))
                            (setq new-c (substitute1 (clause-body clause)
                                                     call-bindings))
                            (setq new-c (mapcar #'(lambda(l)
                                                    (literal+derivation l (cons (cons clause new-c) d)))
                                                new-c))
                            (cons (append front new-c rest) *prefer-children*)))
                      (rule-clauses s)))))

(defun possible-clauses-1 (l d front rest &aux s  (result nil))
   (cond ((eq (car l) 'not)
          (do* ((nfront nil (nconc nfront (list nl)))
                (ls (cdr l) (cdr ls))
                (nrest (cdr ls)(cdr ls))
                (nl (car ls)(car ls))
                (out (possible-clauses-1 nl d nfront rest))
                )
               ((null ls) result)
            (mapcar #'(lambda(not-arg)
                        (push (cons (append front (list (literal+derivation1 (cons 'not not-arg) d))
                                      rest) *prefer-deletions*)
                              result))
                    out)))
         ((rule-p (setq s (get-pstruct (car l))))
          (mapcar #'(lambda(new-name)
                      (cons (append front (list (literal+derivation (cons new-name (cdr l)) d))  rest)  *prefer-deletions*))
                  (get-clause-1-rules s)))))

;;possible refinements to hypotheses. 
;;each take 4 arguments:
;;1 a literal
;;2. a derivation for the literal
;;3: front list of (literal . derivation) before current literal
;;4-  rest   "  "            "            after       "     "
;; and returns a list of (refinement . useful-if-no-change)
(defparameter *refinement-operators* (list #'possible-deletions  #'possible-specializations #'possible-clauses-1))
;;;_______________________________________________________________________________
;;; all-possible-refinements (l d front rest)
;;;  applies refinememnt operators to a clause
;;;  revisions
;;;  rv  who    date      reason


(defun all-possible-refinements (l d front rest)
  (mapcan #'(lambda(X)(funcall x l d front rest)) *refinement-operators* ))

;;takes a list of dotted pairs ((literal . derivation)) and converts it to prolog notation
;;renames each new variable to an old
;;maintain list of new vars and types


(defun convert-from-prolog(list vars count &optional (new-vars nil)(new-types nil) (new-var-alist)
                                &aux a)
  (cond ((null list) (values nil new-vars new-var-alist count))
        (t (let ((literal (literal-part (first list)))
                 (derivation (reverse (derivation-part (first list)))))
             (cond 
              ((eq (car literal) 'not)
               (let ((negated-literals (convert-from-prolog (cdr (car (first list))) vars count new-vars 
                                                            new-types  new-var-alist)))
                 ;;note negatives don't chnage count new-types etc
                 (multiple-value-bind (next new-vars new-types new-var-alist count)
                                      (convert-from-prolog (cdr list) vars
                                                           count new-vars 
                                                           new-types  new-var-alist)
                   (values 
                    (insert-prev (make-literal :derivation (make-derivation :path derivation)
                                               :negated? t :negated-literals negated-literals
                                               :next  next))
                    new-vars new-types new-var-alist count))))
              (t (setq literal (cons (car literal)
                                     (mapcar #'(lambda(x nt)
                                                 
                                                 (cond ((or (not(pcvar-p x))
                                                            (member x vars)) ;old var
                                                        x)
                                                       ((setq a (assoc x new-var-alist))
                                                        (cdr a))
                                                       (t (setq a (make-pcvar :id count))
                                                          (incf count)
                                                          (push (cons x a) new-var-alist)
                                                          (setf new-types (nconc new-types (list nt)))
                                                          (setf new-vars (nconc new-vars (list a)))
                                                          a)))
                                             (cdr literal)
                                             (if (eq (car literal) 'is) '(:number :number)
                                                 ;;guess number, THIS NEEDS TO BE FIXED
                                                 (p-type (get-pstruct (car literal)))))))
                 (multiple-value-bind (next new-vars new-types new-var-alist count)
                                      (convert-from-prolog (cdr list) vars
                                                           count new-vars 
                                                           new-types  new-var-alist)
                   (values 
                    (insert-prev (make-literal :predicate-name (car literal)
                                               
                                               :derivation (make-derivation :path derivation)
                                               :variablization (cdr literal)
                                               :next next))
                    new-vars new-types new-var-alist count))
                 ))))))

(defun insert-prev(l)
  (when (literal-next l)
    (setf (literal-prev (literal-next l)) l))
  l)

;;;_______________________________________________________________________________
;;; RETURN-OPERATIONALIZE-LITERAL-IF-NEEDED
;;;
;;;  revisions
;;;  rv  who    date      reason
;;;  00  cliff  05/21/91  Added capacity to graph operationalization process.
;;;  01  mp     7-4-91    Fixed bug call extend-tuples with old-variables, not variabilization
;;;  02  mp     7-4-91    added call to insert-next-tuples to update tuples in literal structure.
(defun return-operational-literal-if-needed
       (clause				; clause to operationalize
        variabilization			; parameters to clause
        old-variables			; bound variables
        pos-tuples                  
        neg-tuples 
        original-info			; current information
        derivation		        ; :ebl or :constructive-induction
        &aux fun info-gain new-info-gain
        simplified-clause)

  (when *graph-learning*
    (reset-operationalization-frontier clause derivation))

  (let ((operational-clause
         (operationalize-if-needed (mapcar #'(lambda(x)
                                               (literal+derivation x nil))
                                           clause)
                                   variabilization
                                   pos-tuples 
                                   neg-tuples
                                   original-info
                                   derivation))
        new-vars
        new-types
        new-pos-tuples 
        new-neg-tuples)

    (cond 
     ((eq operational-clause :fail) :fail)
     (t (multiple-value-setq (operational-clause new-vars new-types)
                             (convert-from-prolog  operational-clause
                                                   old-variables
                                                   (length old-variables)))
        (setq new-pos-tuples (extend-tuples operational-clause pos-tuples old-variables new-vars)) ;;01
        (setq new-neg-tuples (extend-tuples operational-clause neg-tuples old-variables new-vars)) ;;01
        (when *save-examples* 
          (insert-next-tuples operational-clause pos-tuples neg-tuples old-variables))   ;;02 mp
        (insert-derivation-type-of-every-literal operational-clause derivation)
        
        (setq fun (convert-to-prolog-function operational-clause old-variables))
        (if (equal variabilization old-variables)
          (setq info-gain 
                (info-gain-prove-immediate operational-clause fun
                                           original-info
                                           pos-tuples 
                                           neg-tuples 
                                           old-variables
                                           nil ;no cacheing of neg-tuples since theres no clause
                                           ))
          (setq info-gain
                (info-gain-prove operational-clause fun
                                 original-info
                                 pos-tuples 
                                 neg-tuples 
                                 old-variables
                                 nil ;no cacheing of neg-tuples since theres no clause
                                 )))
        ;;; simplify and try to improve info-gain
        (multiple-value-setq 
         (simplified-clause new-pos-tuples new-neg-tuples new-vars new-types new-info-gain)
         (values operational-clause  new-pos-tuples 
                 new-neg-tuples new-vars new-types info-gain
                 original-info))
        (if (> new-info-gain 0)
          (values simplified-clause
                  new-vars
                  new-types
                  new-pos-tuples
                  new-neg-tuples
                  ;recompute gain of operational clause
                  ;it may cover fewer positive
                  
                  new-info-gain
                  )
          :fail)))))
;;;_______________________________________________________________________________
;;; GET-CLAUSE-1-RULES
;;;;;;MP- creates new rules like the old rule, but missing 1 clause

;;;  revisions
;;;  rv  who    date      reason
;;;  00 mp  7/4/91        returns list of names rather than list of structs
(defun get-clause-1-rules(s)
  (or (rule-clauses-1 s)
      (let ((r (rule-name s))
            p c clauses
            (i -1))
        (when (cdr (rule-clauses s))
          (setf (rule-clauses-1 s)
                (mapcar #'(lambda(clause)
                            (incf i)
                            (setq p (intern (format nil "~a-*-~a" r i)))
                            (setq c (subst p r (remove clause clauses)))
                            (eval `(def-rule ,p :clauses ,c
                                                  :type ,(rule-type s) :constraint ,(rule-constraint s)
                                                  :mode ,(rule-mode s) :commutative ,(rule-commutative s)
                                                  :induction nil :vars ,(rule-vars s)
                                                  :from-rule (cons r i)
                                                  :questions ,(rule-questions s))))
                            
                        (setq clauses (get r 'clauses))))))))



;;;_______________________________________________________________________________
;;; INSERT-NEXT-TUPLES
;;;;;;MP- inserts next-tuples into literals

;;;  revisions
;;;  rv  who    date      reason
;;;needs to check for deleted literals

(defun insert-next-tuples (literal pos-tuples neg-tuples old-variables)
  (unless (null literal)
    (let ( (next (literal-next  literal))  ; to trick extend tuples
           (new-vars (delete-duplicates (remove-if #'(lambda(x)
                                                       (member x old-variables))
                                                   (literal-variablization literal) ))))
      
      (setf (literal-next literal) nil)
      (let ((new-pos-tuples (extend-tuples literal pos-tuples old-variables new-vars))
            (new-neg-tuples (extend-tuples literal neg-tuples old-variables new-vars)))
        (setf (literal-next literal) next)
        (when *save-examples*    
          (setf (literal-pos literal) pos-tuples)
          (setf (literal-neg literal) neg-tuples)
          (setf (literal-new-pos literal) new-pos-tuples)
          (setf (literal-new-neg literal) new-neg-tuples))
       (insert-next-tuples next new-pos-tuples new-neg-tuples (append old-variables new-vars))))))
