
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)

(defconstant scale-factor 100)
(defconstant max-level (* 100 scale-factor))


;;;______________________________________________________________________________
;;; INTRODUCE-CLASS-NOISE
;;;
;;;  NOTE: The noise examples are NOT randomly distributed.  The misclassified
;;;        negative examples appear at the end of the noisy-pos list, while the
;;;        misclassified positive examples appear at the begining of the noisy-
;;;        pos list.
;;;        
;;;  revisions
;;;  rv  who    date      reason
;;;  00  cliff   4/10/91  Created

(defun introduce-class-noise (real-pos real-neg percent-noise)
  (let ((noise-level (* percent-noise scale-factor))
        (noisy-pos nil)
        (noisy-neg nil))

    (dolist (p real-pos)
      (if (< (random max-level) noise-level)
        (if (< (random 100) 50)
          (push p noisy-neg)
          (push p noisy-pos))
        (push p noisy-pos)))

    (dolist (n real-neg)
      (if (< (random max-level) noise-level)
        (if (< (random 100) 50)  
          (push n noisy-pos)
          (push n noisy-neg))
        (push n noisy-neg)))

    (values noisy-pos noisy-neg)))



;;;______________________________________________________________________________
;;; PARTITION-EXAMPLES
;;;        
;;;  revisions
;;;  rv  who    date      reason
;;;  00  cliff   4/10/91  Created

(defun partition-examples (percent-prune-set pos neg)
  (let* 
    ((percent-prune-set-size (/ percent-prune-set 100))
     (u-pos (copy-list pos))
     (u-neg (copy-list neg))
     (p-pos nil)
     (p-neg nil)
     (length-pos (length pos))
     (length-neg (length neg))
     (p-set-size (round (* percent-prune-set-size (+ length-pos length-neg))))
     (p-pos-size (round (* percent-prune-set-size length-pos)))
     (p-neg-size (- p-set-size p-pos-size)))
    
    (do* ((i 1)
          (position (random length-pos) (random length-pos))
          (element (nth position u-pos) (nth position u-pos)))
         ((> i p-pos-size))
      (setf (nth position u-pos) nil)
      (when element
        (setf p-pos (push element p-pos))
        (incf i)))

     (do* ((i 1)
          (position (random length-neg) (random length-neg))
          (element (nth position u-neg) (nth position u-neg)))
         ((> i p-neg-size))
      (setf (nth position u-neg) nil)
      (when element
        (setf p-neg (push element p-neg))
        (incf i)))
          
     (values p-pos p-neg (delete nil u-pos) (delete nil u-neg))))



;;;______________________________________________________________________________
;;; CLASS-NOISE-LEAVE-ONE-OUT-TESTING
;;;
;;; [XXXX]  This function is hardwired to test
;;;           No Stopping   -  Standard FOCL
;;;           Stopping      -  FOIL's stopping criteria
;;;           REP           -  Reduced Error Pruning
;;;
;;;  revisions
;;;  rv  who    date      reason
;;;  00  cliff   4/10/91  Created

(defun class-noise-leave-one-out-testing (concept 
                                          percent-class-noise
                                          percent-prune-set-size
                                          &rest keys
                                          &key the-ignored-key &allow-other-keys)
  (declare (ignore the-ignored-key))
  (let* ((s (get-pstruct concept))
         (real-pos (pred-pos s))
         (real-neg (pred-neg s))
         (arity (pred-arity s))
         (number-of-examples (+ (length real-pos) (length real-neg)))

         (std-MCP 0)  (std-MCN 0)  (std-CCP 0)  (std-CCN 0)
         (foil-MCP 0) (foil-MCN 0) (foil-CCP 0) (foil-CCN 0)
         (rep-MCP 0)  (rep-MCN 0)  (rep-CCP 0)  (rep-CCN 0))

    (dolist (p real-pos)
      (multiple-value-bind
        (noisy-pos noisy-neg)
        (introduce-class-noise (remove p real-pos :test #'equal)
                               real-neg
                               percent-class-noise)
        (eval `(def-pred ,concept
                 :induction nil
                 :pos ,noisy-pos
                 :neg ,noisy-neg))
        
        ;;;  STANDARD FOCL
        (let ((learned-concept (apply #'focl concept (append '(:noise-tolerance nil) keys))))
          (if (prove-function? (make-concept-function 'learned-concept arity learned-concept) nil nil p)
            (incf std-CCP)
            (incf std-MCP)))

        ;;;  FOCL USING FOIL'S STOPPING CRITERIA
        (let ((learned-concept (apply #'focl concept (append '(:noise-tolerance :FOIL) keys))))
          (if (prove-function? (make-concept-function 'learned-concept arity learned-concept) nil nil p)
            (incf foil-CCP)
            (incf foil-MCP)))
 
        ;;;  REDUCED ERROR PRUNING
        (multiple-value-bind 
          (prune-pos 
           prune-neg
           train-pos
           train-neg)
          (partition-examples percent-prune-set-size
                              noisy-pos
                              noisy-neg)
          (eval `(def-pred ,concept
                   :induction nil
                   :pos ,train-pos
                   :neg ,train-neg))
          (let* ((learned-concept (apply #'focl concept (append '(:noise-tolerance nil) keys)))
                 (pruned-concept (Reduced-Error-Pruning :concept-description learned-concept
                                                        :pos-set prune-pos
                                                        :neg-set prune-neg)))
          (if (prove-function? (make-concept-function 'learned-concept arity pruned-concept) nil nil p)
              (incf rep-CCP)
              (incf rep-MCP))))))


    (dolist (n real-neg)
      (multiple-value-bind
        (noisy-pos noisy-neg)
        (introduce-class-noise real-pos
                               (remove n real-neg :test #'equal)
                               percent-class-noise)
         (eval `(def-pred ,concept
                 :induction nil
                 :pos ,noisy-pos
                 :neg ,noisy-neg))

        ;;;  STANDARD FOCL
        (let ((learned-concept (apply #'focl concept (append '(:noise-tolerance nil) keys))))
          (if (prove-function? (make-concept-function 'learned-concept arity learned-concept) nil nil n)
            (incf std-MCN)
            (incf std-CCN)))

        ;;;  FOCL USING FOIL'S STOPPING CRITERIA
        (let ((learned-concept (apply #'focl concept (append '(:noise-tolerance :FOIL) keys))))
          (if (prove-function? (make-concept-function 'learned-concept arity learned-concept) nil nil n)
            (incf foil-MCN)
            (incf foil-CCN)))

        ;;;  REDUCED ERROR PRUNING
        (multiple-value-bind 
          (prune-pos
           prune-neg
           train-pos
           train-neg)
          (partition-examples percent-prune-set-size
                              noisy-pos
                              noisy-neg)
          (eval `(def-pred ,concept 
                   :induction nil 
                   :pos ,train-pos 
                   :neg ,train-neg))
          (let* ((learned-concept (apply #'focl concept (append '(:noise-tolerance nil) keys)))
                 (pruned-concept (Reduced-Error-Pruning :concept-description learned-concept
                                                        :pos-set prune-pos
                                                        :neg-set prune-neg)))
            (if (prove-function? (make-concept-function 'learned-concept arity pruned-concept) nil nil n)
              (incf rep-MCN)
              (incf rep-CCN))))))

    (setf std-CCP (/ std-CCP number-of-examples)
          std-CCN (/ std-CCN number-of-examples)
          std-MCP (/ std-MCP number-of-examples)
          std-MCN (/ std-MCN number-of-examples)

          foil-CCP (/ foil-CCP number-of-examples)
          foil-CCN (/ foil-CCN number-of-examples)
          foil-MCP (/ foil-MCP number-of-examples)
          foil-MCN (/ foil-MCN number-of-examples)

          rep-CCP (/ rep-CCP number-of-examples)
          rep-CCN (/ rep-CCN number-of-examples)
          rep-MCP (/ rep-MCP number-of-examples)
          rep-MCN (/ rep-MCN number-of-examples))
          
    (format t "~%;CCP~aCCN~aMCP~aMCN~aSIZE" #\tab #\tab #\tab #\tab)
    (format t "~%;---~A---~A---~A---~A----" #\tab #\tab #\tab #\tab)
    (format t "~%~5f~A~5f~A~5f~A~5f~A~5f~A No Stopping"
            std-CCP #\tab std-CCN #\tab std-MCP #\tab std-MCN #\tab number-of-examples #\tab)
    (format t "~%~5f~A~5f~A~5f~A~5f~A~5f~A Stopping"
            foil-CCP #\tab foil-CCN #\tab foil-MCP #\tab foil-MCN #\tab number-of-examples #\tab)
    (format t "~%~5f~A~5f~A~5f~A~5f~A~5f~A REP (~a)"
            rep-CCP #\tab rep-CCN #\tab rep-MCP #\tab rep-MCN #\tab number-of-examples #\tab percent-prune-set-size)
 
    (eval `(def-pred ,concept             ;; Reset Initial Examples
             :induction nil 
             :pos ,real-pos 
             :neg ,real-neg))))



;;;______________________________________________________________________________
;;; DROP-ONE-STUDENT-TESTING
;;;
;;; [XXXX]  This function is hardwired to test
;;;           No Stopping   -  Standard FOCL
;;;           Stopping      -  FOIL's stopping criteria
;;;           REP           -  Reduced Error Pruning
;;;
;;;  revisions
;;;  rv  who    date      reason
;;;  00  cliff   4/10/91  Created

(defun drop-one-student-testing ()
  (format t "~%~%~%~%;; Student Loan 20% classification noise REP 33.33 Prune Set")
  (dotimes (i 10)
    (format t "~%;; RANDOM-STATE : ~A" (setf *random-state* (make-random-state t)))
    (class-noise-leave-one-out-testing 'not_in_default 20 33.33
                                       :clauses nil
                                       :reset-hash-tables t
                                       :max-new-variables 2
                                       :operationalize-constructive nil
                                       :constructive-induction t
                                       :trace nil
                                       :simplify-clauses t
                                       :reset-statistics t  
                                       :save-examples nil  
                                       :prefer-theory nil
                                       :proof-vars-available t
                                       :partial-dt-0-gain nil
                                       :simplify-operationalizations nil
                                       :batch-mode nil)))
