
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)
;; -- deduce ----------------------------------------

(defmacro delay (&body body)
  `(make-generator :closure #'(lambda () ,@body)))

#|
(set-macro-character #\?
                     #'(lambda (stream char)
                         (make-pcvar :id (read stream t nil t)))
                     t)
|#

;; -- count ----------------------------------------

;;;all-images (fn lis)- like  mapcar, only doesn't add nil to value
(defmacro all-images (fn lis)
    `(do* ((flist ,lis (cdr flist))
                    (little-result )
                    (result nil))  ((null flist) (nreverse result))
           (if (setq little-result (funcall ,fn (car flist)))
                        (push little-result result))))

;;;all-unique-images (fn lis)- like  mapcar, only doesn't add nil to value
;;;also doesn't add duplicates (while equal check) to value
(defmacro all-unique-images (fn lis)
  `(do* ((flist ,lis (cdr flist))
         (little-result )
         (result nil))
    ((null flist) (nreverse result))
    (if (setq little-result (funcall ,fn (car flist)))
        (unless (member little-result result :test #'equal)
          (push little-result result)))))

;;defines an instance of a builtin predicate
;;  rv  who    date       reason
;;  00  glenn  05/12/91   added fields to distinguish equality builtins and to provide
;;                        a sorting fn to make non-numeric builtins possible
;;  01  cliff  07/02/91   added quote to make it compatible with MACL compilation  

(defmacro def-builtin (name
                       function

                       &key
                       (type '(:numeric :numeric))
                       (constraint :unique-vars)
                       (arity 2)
                       (mode '(:+ :+))
                       (commutative nil)
                       (induction nil)
                       (infix t)
                       (one-variable-comp t)
                       (treat-as-commutative t)
                       (vars nil)
                       (questions nil) 
                       (equality? nil)
                       (sort-fn '#'<))            ;;  CB (01)

  `(let*  ((name ',name)
           (type ',type) 
           (constraint ',constraint)
           (mode ',mode) 
           (commutative ',commutative) 
           (induction ',induction)
           (infix ',infix)
           (bucket (assoc name *builtin-preds*))
           (arity ',arity)
           (vars ',vars)
           (questions ',questions)
           (function ,function)
           (one-variable-comp ,one-variable-comp) 
           (treat-as-commutative ,treat-as-commutative) 
           (equality? ,equality?)
           (sort-fn ,sort-fn)
           (struct (make-builtin :arity arity
                             :type type
                             :constraint constraint
                             :mode mode
                             :commutative commutative
                             :induction induction
                             :infix infix
                             :vars vars
                             :questions questions
                             :name name
                             :function function
                             :one-variable-comp one-variable-comp 
                             :treat-as-commutative treat-as-commutative
                             :equality? equality?
                             :sort-fn sort-fn)) 
           )
     (setf (get name 'builtin) struct)
     (if bucket (setf (cdr bucket) struct)
         (push (cons name struct) *builtin-preds*))
     name))


;; defines an arithmetic operator
(defmacro def-arithmetic-op (name function &key (type '(:numeric :numeric)) (constraint :unique-vars) (arity 2)
                               (mode '(:+ :+)) (commutative nil) (induction nil)(infix t)
                               (treat-as-commutative t)(vars nil)(questions nil) )
  `(let*  ((name ',name)
           (is-op-name ',(intern (format nil "is-~A" name)))
           (type ',type)
           (constraint ',constraint)
           (mode ',mode)
           (commutative ',commutative) 
           (induction ',induction)
           (infix ',infix)
           (bucket (assoc name *arithmetic-ops*))
           (is-bucket (assoc is-op-name *is-ops*))
           (arity ',arity)
           (vars ',vars)
           (questions ',questions)
           (function ,function)
           (treat-as-commutative ,treat-as-commutative) 
           (struct (make-arithmetic-op :arity arity
                                      :type type
                                      :constraint constraint
                                      :mode mode
                                      :commutative commutative
                                      :induction induction
                                      :infix infix 
                                      :vars vars
                                      :questions questions
                                      :name name
                                      :function function
                                      :treat-as-commutative treat-as-commutative))
           ; note this is internal so we probably don't need stuff like vars and questions
           (is-op-struct (make-is-op :arity (1+ arity)
                                     :type ',(cons (car type) type) ; same as first arg - maybe do something fancy here
                                     :constraint constraint
                                     :mode (cons ':- mode)
                                     :commutative commutative
                                     :induction induction
                                     :infix nil 
                                     :arithmetic-op name
                                     :name is-op-name))

           )
     (setf (get name 'arithmetic-op) struct)
     (setf (get is-op-name 'is-op) struct)
     (if bucket (setf (cdr bucket) struct)
         (push (cons name struct) *arithmetic-ops*))
     (if is-bucket (setf (cdr is-bucket) is-op-struct)
         (push (cons is-op-name is-op-struct) *is-ops*))
     name))



;;defines a new predicate

(defmacro def-pred (name &key pos (neg nil) (type nil) (constraint nil)
                         (mode nil) (commutative nil) (induction t)(infix nil)(vars nil)
                         (questions nil) )
  `(let*  ((name ',name)
           (pos ',pos)
           (neg ',neg) 
           (type ',type) 
           (constraint ',constraint)
           (mode ',mode) 
           (commutative ',commutative) 
           (induction ',induction)
           (infix ',infix)
           (vars ',vars)
           (questions ',questions)
           (bucket (assoc name *extensional-preds*))
           (arity (length (or (first pos)(first neg) vars)))
           (pred (make-pred :arity arity
                            :type (if type
                                    type
                                    (make-list arity :initial-element ':anything))
                            :constraint constraint
                            :mode mode   ;nil means anything, and is easier to check
                            :commutative commutative
                            :induction induction
                            :infix infix
                            :vars vars
                            :questions questions
                            :name name
                            :pos pos
                            :neg (if (eq neg ':computed)
                                   (remove-if #'(lambda(X)
                                                  (member X pos :test #'equal))
                                              (all-typed-tuples type))
                                   neg)
                            :pos-hash (make-pos-hash pos)
                            :neg-tuples-hash  (make-hash-table :test #'equal 
                                                               :size (+ 1 (* arity 10)))   
                            :neg-tuples-hash-for-negated (make-hash-table :test #'equal 
                                                                          :size (+ 1 (* arity 10)))   
                            
                            :slot-value-hash (make-slot-value-hash arity pos)))
           )
     (setf (get name 'pred) pred)
     (if bucket (setf (cdr bucket) pred)
         (push (cons name pred) *extensional-preds*))
     (focl-compile-facts name)
     name))




;;;  00  glenn  05/17/91  added reduction-type and reduction-variabilization fields for
;;;    the processing of the recursive cliches - creations reduction-pred structure but
;;;    puts it on the pred property and stores it on list of *extensional-preds* so that
;;;    they'll be treated like preds

(defmacro def-reduction-pred (name &key pos (neg nil) (type nil) (constraint nil)
                                   (mode nil) (commutative nil) (induction t)(infix nil)
                                   (vars nil) (questions nil) (reduction-type nil) 
                                   (reduction-variabilization nil))
  `(let*  ((name ',name)
           (pos ',pos)
           (neg ',neg) 
           (type ',type) 
           (constraint ',constraint)
           (mode ',mode) 
           (commutative ',commutative) 
           (induction ',induction)
           (infix ',infix)
           (vars ',vars)
           (questions ',questions)
           (bucket (assoc name *extensional-preds*))
           (arity (length (or (first pos)(first neg) vars)))
           (reduction-variabilization ',reduction-variabilization)
           (reduction-type ',reduction-type)
           (pred (make-reduction-pred :arity arity
                                      :type (if type
                                              type
                                              (make-list arity :initial-element ':anything))
                                      :constraint constraint
                                      :mode mode   ;nil means anything, and is easier to check
                                      :commutative commutative
                                      :induction induction
                                      :infix infix
                                      :vars vars
                                      :questions questions
                                      :name name
                                      :pos pos
                                      :neg (if (eq neg ':computed)
                                             (remove-if #'(lambda(X)
                                                            (member X pos :test #'equal))
                                                        (all-typed-tuples type))
                                             neg)
                                      :pos-hash (make-pos-hash pos)
                                      :neg-tuples-hash  (make-hash-table :test #'equal 
                                                                         :size (+ 1 (* arity 10)))   
                                      :neg-tuples-hash-for-negated (make-hash-table :test #'equal 
                                                                                    :size (+ 1 (* arity 10)))   
                                      
                                      :slot-value-hash (make-slot-value-hash arity pos)
                                      :reduction-type reduction-type
                                      :reduction-variabilization reduction-variabilization))
           )
     (setf (get name 'pred) pred)
     (if bucket (setf (cdr bucket) pred)
         (push (cons name pred) *extensional-preds*))
     (focl-compile-facts name)
     name))

;;macro for defining rule
(defvar *compile-each-clause* t)
;;;  rv  who    date      reason
;;;  00  glenn  05/17/91  added source-cliche field stores the name of the cliche used to create the
;;;     the rule was created by a cliche

(defmacro def-rule (name &key clauses  (type nil) (constraint nil)
                         (mode nil) (commutative nil) (induction t)(vars nil)
                         (questions nil) (source-cliche nil)(from-rule nil))
  `(let*  ((name ',name)
           (type ',type) 
           (constraint ',constraint)
           (mode ',mode) 
           (clauses ',clauses) 
           (from-rule ',from-rule) 
           (source-cliche ',source-cliche)
           (vars ',vars)
           (questions ',questions)
           (commutative ',commutative) 
           (induction ',induction)
           (bucket (assoc name *intensional-preds*))
           (arity (length (if vars vars (cdr (first (first clauses))))))
           (clauseno 0)
           (rule (make-rule :arity arity
                            :type (if type
                                    type
                                    (make-list arity :initial-element ':anything))
                            :constraint constraint
                            :mode (if mode
                                    mode
                                    (make-list arity :initial-element ':?))

                            :vars vars
                            :questions questions
                            :commutative commutative
                            :induction induction
                            :name name
                            :from-rule nil
                            :source-cliche source-cliche
                            :clauses (progn (setf (get name 'brules) nil)
                                            (mapcar #'(lambda(clause &aux (new (uniquify-variables clause)))
                                                        (push (cons '<- new)
                                                              (get name 'brules))
                                                        (prog1 (make-clause :body (cdr new)
                                                                            :number clauseno
                                                                            :neg-tuples-hash (make-hash-table :test #'equal 
                                                                                                              :size 2)
                                                                            :head (car (car new))
                                                                            :new-vars (compute-new-vars
                                                                                       (cdr new)
                                                                                       (cdr (car new)))
                                                                            :parameters (cdr (car new))
									    :prolog-function (when *compile-each-clause*
												   (focl-compile-clause-function clause arity)))
                                                          (incf clauseno)))
                                                    clauses))
                            :neg-tuples-hash  (make-hash-table :test #'equal 
                                                               :size (+ (* arity 10) 1))   
                            :neg-tuples-hash-for-negated (make-hash-table :test #'equal 
                                                                          :size (+ (* arity 10) 1)   
                            
                            ))
           ))
     (setf (get name 'rule) rule)
     (if bucket (setf (cdr bucket) rule)
         (push (cons name rule) *intensional-preds*))
     (setf (get name 'brules)
           (nreverse (get name 'brules)))
     (setf (get name 'clauses)
           clauses)
     (setf (rule-prolog-function rule) (focl-compile-predicate name arity clauses))

     name))



(defmacro def-type (name &rest instances)
  `(progn (pushnew ',name *all-types*)
          (setf (get ',name 'focl-instances) ',instances)
          ',name))
(defmacro get-type-instances(type)
  `(get ,type 'focl-instances))


;; -- focl

;; -- find-literal

;;  revisions
;;  rv  who    date     reason
;;  00  glenn  11/01/90 added for consistent pruning III

;;;  this will set the global var *covered-all-pos-tuples - this should only in as few places as 
;;;  possible (find-max-variables and find-literal-builtin-thresh).  other functions should
;;;  use check-pruning-III

(defmacro check-pruning-III-and-prune 
          (covered-all-pos-tuples return-point pred variables variabilization values)
  `(when (and ,covered-all-pos-tuples *perform-pruning-III*)
     (setf *covered-all-pos-tuples* t)
     (return-from ,return-point
                (progn
                  (when (member :lt *focl-trace-level*)
                    (format t "~&PRUNING III: old-vars: ~a winning predicate: ~a winning variabilization: ~a~%~%" 
                            ,variables
                            (if (null ,pred)
                              nil
                              (p-name ,pred)) ; ges changed pred-name to p-name
                            ,variabilization))
                  ,values))))



;;;  this function checks for pruning III but does not actually set *covered-all-pos-tuples*

;;  revisions
;;  rv  who    date     reason
;;  00  glenn  11/01/90 added for consistent pruning III checks
(defmacro check-pruning-III (covered-all-pos-tuples return-point values)
  `(when (and *perform-pruning-III* ,covered-all-pos-tuples)
     (return-from ,return-point ,values)))

;;;  this function checks for pruning III but does not actually set *covered-all-pos-tuples*

;;  revisions
;;  rv  who    date     reason
;;  00  glenn  02/23/91 added only tests no actual pruning
(defmacro pruning-III-test (covered-all-pos-tuples)
  `(and *perform-pruning-III* ,covered-all-pos-tuples))

;; -- summarize

;; -- builtin


;; note these are also used by cliches.lisp

;;  rv  who    date       reason
;;  00  glenn  05/13/91   added to process variabilizations with thresholds for relational
;;    builtins (i.e., non-equality builtins) body is passed in to facilitate use with cliches 
;;    which don't compute info-gain for thresholds in the middle of the cliche

;;;  might want to use these in builtins
(defmacro process-threshold-variabilizations (builtins 
                                              var-restrictions
                                              variables
                                              variable-types
                                              pos-tuples
                                              neg-tuples
                                              variabilization
                                              instantiated-cliche
                                              exit-cond ; for do
                                              &rest body)
  `(when ,builtins
             ; for now assume all builtins require the same # of bits
     (cond 
      ((and *stopping-criteria-enabled*
            (predicate-requires-too-many-bits (car ,builtins))) nil)
      (t
       (let (pos
             neg
             boundary-pts
             (overall-builtin-type (overall-builtin-type ,builtins))
             sort-fn
             last-sort-fn) ; to filter variables
         (do* ((old-variables 
                ; (2)
                (apply-thresh-var-restrictions ,var-restrictions 
                                               ,variables
                                               ,instantiated-cliche)
                (cdr old-variables))
               (var (car old-variables) (car old-variables))
               (old-types (retrieve-corresponding-elements old-variables ,variables ,variable-types)
                          (cdr old-types))
               (type (car old-types) (car old-types)))
              
              ((null old-variables) ,exit-cond)
           (setq last-sort-fn nil)
           ;;compute info gain of predicate and negation, updating max if necessary
           (when (and (satisfies-type type overall-builtin-type) ; first filter out vars
                      (bound-var? var))
             (do* ((comps (if (eql overall-builtin-type 'numeric-type) ; use only applicable builtins
                           ,builtins 
                           (remove-if-not 
                            #'(lambda (c) 
                                (satisfies-type type (get-builtin-type (cdr c))))
                            ,builtins))
                         (cdr comps))
                   (comp (cdr (car comps)) (cdr (car comps))))
                  ((null comps))
               ;; sort points and set up sort-fn (hopefully won't intersperce non-numeric and 
               ;; numeric builtins - we may want to separate them or order the builtins by their
               ;; sort functions)
               (when (not (eql last-sort-fn (setq sort-fn (builtin-sort-fn comp))))
                 (setq pos (sort (mapcar #'(lambda (tuple) (nth (pcvar-id var) tuple)) ,pos-tuples) 
                                 sort-fn))
                 (setq neg (sort (mapcar #'(lambda (tuple) (nth (pcvar-id var) tuple)) ,neg-tuples)
                                 sort-fn))
                 (setq boundary-pts (compute-boundary-points pos neg sort-fn))
                 (setq last-sort-fn sort-fn))
                 
               (do* ((boundary-points boundary-pts (cdr boundary-points))
                     (boundary-point (car boundary-points) (car boundary-points)))
                    ((null boundary-points))
                 (setq ,variabilization (list var boundary-point))
                 ,@body)))))))))


;;  rv  who    date       reason
;;  00  glenn  05/13/91   added to process variabilizations which introduce constants for 
;;    equality builtins body is passed in to facilitate use with cliches which don't 
;;    compute info-gain for thresholds in the middle of the cliche

;;; note eql is a pre-defined builtin for this and will only be available internally
;;; i.e., constants can only be added in via cliches.
;;; or at least figure out later where you want them

(defmacro process-equality-constant-varzns (builtins
                                            var-restrictions
                                            variables 
                                            variable-types
                                            pos-tuples
                                            neg-tuples
                                            variabilization
                                            negated?
                                            instantiated-cliche
                                            exit-cond
                                            &rest body)
  `(when ,builtins
     (let (pos
           neg
           (overall-builtin-type (overall-builtin-type ,builtins))) ; to filter variables
       (do* ((old-variables 
              ; (2)
              (apply-thresh-var-restrictions ,var-restrictions 
                                             ,variables
                                             ,instantiated-cliche)
              (cdr old-variables))
             (var (car old-variables) (car old-variables))
             (old-types (retrieve-corresponding-elements old-variables 
                                                         ,variables ,variable-types)
                        (cdr old-types))
             (type (car old-types) (car old-types)))
            
            ((null old-variables) ,exit-cond)
         ;;run over pos and neg vals only if var is non-numeric and bound
         (when (and (satisfies-type type overall-builtin-type) ; first filter out vars
                    (bound-var? var))
           ; only need to check positive tuple vals when dealing with positive literals - 
           ; otherwise (eql var constant) won't match any positive tuples
           (setq pos (remove-duplicates
                      (mapcar #'(lambda (tuple) (nth (pcvar-id var) tuple)) ,pos-tuples)))
           (setq neg (remove-duplicates
                      (mapcar #'(lambda (tuple) (nth (pcvar-id var) tuple)) ,neg-tuples)))
           (do* ((comps (if (eql overall-builtin-type 'numeric-type) ; use only applicable builtins
                          ,builtins 
                          (remove-if-not 
                           #'(lambda (c) 
                               (satisfies-type type (get-builtin-type (cdr c))))
                           ,builtins))
                        (cdr comps))
                 (comp (cdr (car comps)) 
                        (cdr (car comps))))
                ((null comps))
             (do* ((constants pos (cdr constants))
                   (constant (car constants) (car constants)))
                  ((null constants))
               (setq ,variabilization (list var constant))
               (setq ,negated? nil)
               ,@body)
             ; only need to check negative tuple values for negative eql literals - otherwise
             ; won't exclude any negative examples
             
             (do* ((constants neg (cdr constants))
                   (constant (car constants) (car constants)))
                  ((null constants))
               (setq ,variabilization (list var constant))
               (setq ,negated? t)
               ,@body)))))))


(defmacro def-example (name &rest preds)
  `(let ((preds (cons  (list 'example ',name) ',preds)))
     (mapc #'(lambda (p)
               (when (setq neg (eq (car p) '-))
                 (setq p (cadr p)))
           (cond ((get (car p) 'pred)
                  (if neg (insert-neg (get (car p) 'pred) p)
                      (insert-pos p)))
                  (t (format t "~%~a undefined fact" p))))
           preds)
     ',name))




