
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)

;;; defined is as a builtin function
(defstruct (builtin-fn (:include p)))

;;defines an instance of a builtin predicate
(defmacro def-builtin-fn (name &key (type '(:numeric :anything)) (constraint :unique-vars) (arity 2)
                               (mode '(:? :?)) (commutative nil) (induction nil)(infix t)
                               (treat-as-commutative t)(vars nil)(questions nil) )
  `(let*  ((name ',name)
           (type ',type)
           (constraint ',constraint)
           (mode ',mode)
           (commutative ',commutative) 
           (induction ',induction)
           (infix ',infix)
           (bucket (assoc name *arithmetic-ops*))
           (arity ',arity)
           (vars ',vars)
           (questions ',questions)
           (treat-as-commutative ,treat-as-commutative) 
           (struct (make-builtin-fn :arity arity
                                    :type type
                                    :constraint constraint
                                    :mode mode
                                    :commutative commutative
                                    :induction induction
                                    :infix infix 
                                    :vars vars
                                    :questions questions
                                    :name name
                                    :treat-as-commutative treat-as-commutative))
           )
     (setf (get name 'builtin-fn) struct)
     (if bucket (setf (cdr bucket) struct)
         (push (cons name struct) *builtin-fns*))
     name))

(defun builtin-fn? (literal)
  (builtin-fnp (get (car literal) 'builtin-fn)))

;;like count tuples, but instantiates new vars and append to end of teach tuple
;;note that new-vars are now indicated by a list of new-variables
;;all-unique-images dousn't add duplicates
(defun extend-tuples-is (tuples vars is-var is-exp)
  is-var
  (let (
        new-is-exp
        is-val)
    (mapcar #'(lambda(tuple)
                (setq new-is-exp (substitute1 is-exp (unify vars tuple)))
                (setq is-val (eval new-is-exp))
                (append tuple (list is-val)))
            tuples)))
