;;-*- Mode: Lisp; Package: CCL -*-
;; scrolling-fred-dialog-item.lisp
;; Copyright  1990, Apple Computer, Inc.
;;
;; The SCROLLING-FRED-DIALOG-ITEM class is a FRED-DIALOG-ITEM
;; with a scroll bar.

;;;;;;;;;;;;;
;;
;; Modification History
;;
;; 03/05/92 bill declare h-scroller & v-scroller in fred-update to
;;               prevent file compiler warnings.

(in-package :ccl)

(defvar *fred-track-thumb-p* t)

(defclass scrolling-fred-dialog-item (scroller-mixin fred-dialog-item) ()
  (:default-initargs
    :h-scroll-class 'fred-h-scroll-bar
    :v-scroll-class 'fred-v-scroll-bar
    :track-thumb-p *fred-track-thumb-p*
    :h-scrollp t
    :v-scrollp t
    :view-font *fred-default-font-spec*
    :allow-returns t
    :allow-tabs t
    :margin 3
    :draw-outline nil
    :draw-scroller-outline t))

(defmethod scroll-bar-limits ((view scrolling-fred-dialog-item))
  (values #@(0 511) #@(0 30000)))

(defclass fred-h-scroll-bar (scroll-bar-dialog-item) ())
(defclass fred-v-scroll-bar (scroll-bar-dialog-item) ())

(defmethod track-scroll-bar ((item fred-v-scroll-bar) value part)
  (if (eq part :in-thumb)
    (progn
      (setf (scroll-bar-setting item) value)
      (dialog-item-action item))
    (let* ((view (scroll-bar-scrollee item))
           (frec (frec view))
           (mark (fred-display-start-mark view)))
      (when (memq part '(:in-up-button :in-down-button :in-page-up :in-page-down))
        (set-mark mark
                  (frec-screen-line-start
                   frec mark
                   (case part
                     (:in-up-button -1)
                     (:in-down-button 1)
                     (:in-page-up (- 1 (frec-screen-lines frec)))
                     (:in-page-down (- (frec-screen-lines frec) 1)))))
        (fred-update view)))))

(defmethod track-scroll-bar ((item fred-h-scroll-bar) value part)
  (if (eq part :in-thumb)
    (progn
      (setf (scroll-bar-setting item) value)
      (dialog-item-action item))
    (let* ((view (scroll-bar-scrollee item))
           (hscroll (fred-hscroll view)))
      (declare (fixnum hscroll))
      (when (memq part '(:in-up-button :in-down-button :in-page-up :in-page-down))
        (set-fred-hscroll view
                          (+ hscroll
                             (case part
                               (:in-up-button -6)
                               (:in-down-button (if (eql 0 hscroll)
                                                  (fred-margin view) 6))
                               (:in-page-up (- (ash (point-h (view-size view)) -1)))
                               (:in-page-down (ash (point-h (view-size view)) -1)))))
        (fred-update view)))))

; This handles the case when the user drags the thumb.
(defmethod dialog-item-action ((item fred-v-scroll-bar))
  (let* ((setting (scroll-bar-setting item))
         (view (scroll-bar-scrollee item))
         (max (scroll-bar-max item))
         (frec (frec view))
         (mark (fred-display-start-mark view))
         (size (buffer-size mark))
         (new-pos (round (* setting size) max)))
    (set-mark mark (frec-screen-line-start frec new-pos))
    (fred-update view)))

(defmethod dialog-item-action ((item fred-h-scroll-bar))
  (let* ((view (scroll-bar-scrollee item)))
    (set-fred-hscroll view (scroll-bar-setting item))
    (fred-update view)))

; This repositions the scroll bars
(defmethod fred-update :after ((view scrolling-fred-dialog-item))
  (declare (ftype (function (*) *) h-scroller v-scroller))
  (let ((h-scroll (h-scroller view))
        (v-scroll (v-scroller view)))
    (when v-scroll
      (let* ((max (scroll-bar-max v-scroll))
             (mark (fred-display-start-mark view))
             (pos (buffer-position mark))
             (size (buffer-size mark)))
        (set-scroll-bar-setting v-scroll (if (eql 0 size) 0 (round (* pos max) size)))))
    (when h-scroll
      (set-scroll-bar-setting h-scroll (fred-hscroll view)))))

(provide :scrolling-fred-dialog-item)

#|
(defparameter *w* (make-instance 'window :view-size #@(500 200)))

(defparameter *f* (make-instance 'scrolling-fred-dialog-item
                                 :view-container *w*
                                 :view-size #@(450 150)))

|#
