;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold without
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstein
;;;; and Kamal Ali.  

;;; work keeps track of the number of times the gain metric
;;; is computed for an object created by a given component.

(defun clear-work (work-struct)
  (setf (work-extensional work-struct) 0
        (work-builtin work-struct) 0
        (work-intensional work-struct) 0
        (work-determinate work-struct) 0
        (work-cliche work-struct) 0
        (work-ebl work-struct) 0
        (work-simplify-operationalization work-struct) 0
        (work-simplify-clause work-struct) 0
        (work-frontier-ebl work-struct) 0
        (work-frontier-induction work-struct) 0
        (work-frontier-simpliciation work-struct) 0))

(defun increment-work (work-struct source)
  (case source
    (:extensional (incf (work-extensional work-struct)))
    (:builtin (incf (work-builtin work-struct)))
    (:intensional (incf (work-intensional work-struct)))
    (:determinate (incf (work-determinate work-struct)))
    (:cliche (incf (work-cliche work-struct)))
    (:ebl (incf (work-ebl work-struct)))
    (:simplify-o (work-simplify-operationalization work-struct))
    (:simplify-c (work-simplify-clause work-struct))
    (:frontier-ebl (work-frontier-ebl work-struct))
    (:frontier-induction (work-frontier-induction work-struct))
    (:frontier-simpliciation (work-frontier-simpliciation work-struct))
    (otherwise (format t "~%Warning - work type ~S unknown" source))))

(defun add-work (work work-being-added-to)
  (incf (work-extensional work-being-added-to) (work-extensional work))
  (incf (work-builtin work-being-added-to) (work-builtin work))
  (incf (work-intensional work-being-added-to) (work-intensional work))
  (incf (work-determinate work-being-added-to) (work-determinate work))
  (incf (work-cliche work-being-added-to) (work-cliche work))
  (incf (work-ebl work-being-added-to) (work-ebl work))
  (incf (work-simplify-operationalization work-being-added-to) (work-simplify-operationalization work))
  (incf (work-simplify-clause work-being-added-to) (work-simplify-clause work))
  (incf (work-frontier-ebl work-being-added-to) (work-frontier-ebl work))
  (incf (work-frontier-induction work-being-added-to) (work-frontier-induction work))
  (incf (work-frontier-simpliciation work-being-added-to) (work-frontier-simpliciation work)))


(defun print-work (stream work)
  (format stream "Extensional : ~A   Builtin : ~A   Intensional : ~A   Cliche : ~A   EBL : ~A   Determinate : ~A    TOTAL : ~A"
          (work-extensional work)
          (work-builtin work)
          (work-intensional work)
          (work-cliche work)
          (work-ebl work)
          (work-determinate work)
          (+ (work-extensional work)
             (work-builtin work)
             (work-intensional work)
             (work-cliche work)
             (work-ebl work)
             (work-determinate work))))

(defun change-status (new-status)
  (if *status*
    (rplaca *status* new-status)
    (setf *status* (list new-status)))
  (when *display-learning?* (display-status new-status)))

(defun set-status (new-status)
  (setf *status* (list new-status))
  (when *display-learning?* (display-status new-status)))

(defun push-status (new-status)
  (setf *status* (push new-status *status*))
  (when *display-learning?* (display-status new-status)))

(defun pop-status ()
  (pop *status*)
  (when *display-learning?* (display-status (first *status*))))

(defun current-status ()
  (first *status*))

